package com.xdja.safeclient.certcreation.bean.request;

import android.os.Parcel;
import android.os.Parcelable;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * 2.13.【I-airIssue-api-014】实体认证-无需活体检测(同2.2)
 * Created by zjc on 2018/6/7 0007.
 */

public class VerifyInfoSelfieRequest extends BaseRequest implements Parcelable {

    @JSONField(ordinal = 1)
    private String faceImg;

    @JSONField(ordinal = 2)
    private IDCard idCardInfo;

    @JSONField(ordinal = 3)
    private SimpleChipInfo chipInfo;

    @JSONField(ordinal = 4)
    private String caAlg;

    public VerifyInfoSelfieRequest() {

    }

    protected VerifyInfoSelfieRequest(Parcel in) {
        faceImg = in.readString();
        idCardInfo = in.readParcelable(IDCard.class.getClassLoader());
        chipInfo = in.readParcelable(SimpleChipInfo.class.getClassLoader());
        caAlg = in.readString();
    }

    public static final Creator<VerifyInfoSelfieRequest> CREATOR = new Creator<VerifyInfoSelfieRequest>() {
        @Override
        public VerifyInfoSelfieRequest createFromParcel(Parcel in) {
            return new VerifyInfoSelfieRequest(in);
        }

        @Override
        public VerifyInfoSelfieRequest[] newArray(int size) {
            return new VerifyInfoSelfieRequest[size];
        }
    };

    public String getFaceImg() {
        return faceImg;
    }

    public void setFaceImg(String faceImg) {
        this.faceImg = faceImg;
    }

    public IDCard getIdCardInfo() {
        return idCardInfo;
    }

    public void setIdCardInfo(IDCard idCard) {
        this.idCardInfo = idCard;
    }

    public SimpleChipInfo getChipInfo() {
        return chipInfo;
    }

    public void setChipInfo(SimpleChipInfo chipInfo) {
        this.chipInfo = chipInfo;
    }

    public String getCaAlg() {
        return caAlg;
    }

    public void setCaAlg(String caAlg) {
        this.caAlg = caAlg;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(faceImg);
        parcel.writeParcelable(idCardInfo, i);
        parcel.writeParcelable(chipInfo, i);
        parcel.writeString(caAlg);
    }

    @Override
    public String toString() {
        return "VerifyInfoSelfieRequest{" +
                "faceImg='" + faceImg + '\'' +
                ", idCardInfo=" + idCardInfo +
                ", chipInfo=" + chipInfo +
                ", caAlg='" + caAlg + '\'' +
                '}';
    }

}
