package com.xdja.safeclient.certcreation.databases;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;

import com.aircert.util.ModuleLog;
import com.xdja.log.XdjaLog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by wanghao on 2017/7/13.
 */

public class DatabaseManager {

    private static final DatabaseManager databaseManager = new DatabaseManager();

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return databaseManager;
    }

    /**
     * 拷贝文件到当前私有目录
     *
     * @param context
     */
    public void copyAssetDatabase2PriPath(Context context) {

        context.deleteDatabase(CertConfigDataBase.FILE_NAME);

        /**
         * vivo手机与其他手机的文件路径不一致
         * vivo路径：/data/user/0/com.xdja.aircert_sspace/databases/certDataBase.db
         * 其他手机路径
         */
        String distDirPath = context.getDatabasePath(CertConfigDataBase.FILE_NAME).getPath();
        int lastIndex = distDirPath.lastIndexOf("/");
        String databaseDirPath = distDirPath.substring(0,lastIndex);
        File databaseDir = new File(databaseDirPath);
        if(!databaseDir.exists()){
            boolean result = databaseDir.mkdirs();
            XdjaLog.i("WANGHAO","mkdir "+result);
        }else{
            /***mate20 mate9 部分机器出现进入"技术支持"模式界面 添加如下逻辑修正****/
            XdjaLog.i("WANGHAO","databaseDir exists");
            File[] files = databaseDir.listFiles();
            for(File file : files){
                if(file.getName().indexOf(CertConfigDataBase.FILE_NAME) > -1) {
                    boolean result = file.delete();
                    XdjaLog.i("WANGHAO","delete old db"+result);
                }
            }
            /*******end***************/
        }

        AssetManager manager = context.getAssets();
        String[] files;
        try {
            files = manager.list("");
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            byte[] buffer = new byte[1024];
            int length;
            for(String file : files){
                if(file.endsWith(".db")){
                    try {
                        inputStream = manager.open(file);
                        String distFilePath = context.getDatabasePath(file).getPath();
                        fileOutputStream = new FileOutputStream(distFilePath);
                        while ((length = inputStream.read(buffer)) != -1) {
                            fileOutputStream.write(buffer, 0, length);
                        }
                        fileOutputStream.flush();

                    } catch (IOException e) {
                        e.printStackTrace();
                    } finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public String exportDatabase2Sdcard(Context context) {
        String sourceFile = "data/data/" + context.getPackageName() + "/databases/" + CertConfigDataBase.NAME + ".db";
        String distFile = Environment.getExternalStorageDirectory() + "/" + CertConfigDataBase.NAME + ".db";
        InputStream inputStream = null;
        OutputStream outputStream = null;

        try {
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(distFile);
            byte[] buffer = new byte[1024];
            int length;
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();

            File file = new File(distFile);
            ModuleLog.d("导出完成，大小：" + file.length());

            return distFile;
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

}
