package com.xdja.safeclient.certcreation.device;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.aircert.util.ModuleLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.util.OttoUtil;

import java.io.File;

/**
 * 联网卡VHSM相关操作
 * Created by jff on 2019/7/8.
 */
public class NetVHSMHandle {
    /**
     * vhsm初始化
     *
     * @param context
     * @param ip      联机版服务端的ip
     * @param port    联机版服务端的port
     * @return 初始化结果
     */
    public static void initVHSM(final Context context, final String ip, final int port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                NetRespository netRespository = NetRespository.create(context, ip, port);
                int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
                Log.e("jff", "37 NetVHSMHandle run :initResult =  " + initResult);
                if (initResult == 0) {//联网版VHSM初始化成功
                    ModuleLog.e("VHSM初始化成功");
                    int initFile = NetRespository.initVhsmlibFile(context, ip, port);
                    Message msg = new Message();
                    msg.obj = "success";
                    Bundle data = new Bundle();
                    data.putInt("value", initFile);
                    msg.setData(data);
                    handler.sendMessage(msg);
                } else {
                    Message msg = new Message();
                    msg.obj = "fail";
                    Bundle data = new Bundle();
                    data.putInt("value", initResult);
                    msg.setData(data);
                    handler.sendMessage(msg);
                }
            }
        }).start();

    }

    private static Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            int initFile = (int) msg.getData().get("value");
            OttoUtil.postNet_VHSMinitResult(initFile);
        }
    };


    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    public static String getNetVhsmCardId(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId(NetVhsmDeviceIdUtils.getDevId(context));
        Log.e("jff", "77 NetVHSMHandle getNetVhsmCardId : " + netVhsmCardId);
        return netVhsmCardId;
    }

    static final String FILE_DIR = "xdja/vhsm/net/";
    static final String randFilePath = FILE_DIR + "rand.bin";
    static final String kdatFilePath = FILE_DIR + "vhsm.dat";
    static final String wboxFilePath = FILE_DIR + "wbox.lib";
    static final String vhsmLibFilePath = FILE_DIR + "vhsm.lib";


    public static boolean isNetVHSMCanUse() {
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, randFilePath);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        File vhsmLibFile = new File(storageDir, vhsmLibFilePath);
        if (!vhsmLibFile.exists()) {
            return false;
        }

        return true;
    }


}
