package com.xdja.safeclient.certcreation.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.activity.CertViewActivity;
import com.xdja.safeclient.certcreation.activity.EmbeddedCertViewActivity;

import static android.content.Intent.FLAG_ACTIVITY_NEW_TASK;

/**
 * Created by Administrator on 2019/7/22 0022.
 */

public class LaunchReceiver extends BroadcastReceiver {


    @Override
    public void onReceive(Context context, Intent intent) {

        if (context == null) {
            return;
        }

        String packageName = context.getPackageName();

        ModuleLog.d("launch", packageName);

        if (intent.getAction().equals("com.xdja.certview")) {

            //
            if (packageName.equals("com.xdja.aircert")) {
                ModuleLog.d("launch", "独立版不能调用");
                return;
            }

            if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
                Intent activityIntent = new Intent(context, EmbeddedCertViewActivity.class);
                activityIntent.setFlags(FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(activityIntent);
            } else {
                Intent activityIntent = new Intent(context, CertViewActivity.class);
                activityIntent.setFlags(FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(activityIntent);
            }


        }

    }

}
