package com.xdja.safeclient.certcreation.task;

import android.os.AsyncTask;

import com.xdja.safeclient.certcreation.bean.ServerAddress;

import org.apache.commons.net.telnet.TelnetClient;

import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by Administrator on 2020/3/6 0006.
 */

public class ChooseTask extends AsyncTask<Void, Void, Integer> {

    public interface ChooseResult {

        void success(ServerAddress address);

        void fail(long time);
    }

    private ArrayList<ServerAddress> list;

    private ChooseResult result;

    private long start;

    private int singleTimeout;

    public ChooseTask(ArrayList<ServerAddress> list, int singleTimeout, ChooseResult result) {
        start = System.currentTimeMillis();
        this.list = list;
        this.result = result;
        this.singleTimeout = singleTimeout;
    }

    @Override
    protected Integer doInBackground(Void... voids) {

        TelnetClient telnet = null;

        int successPosition = -1;

        int position = 0;

        if (list == null || list.size() == 0) {
            return -1;
        }

        for (; position < list.size(); position++) {

            ServerAddress address = list.get(position);

            String ip = address.getIp();
            String port = address.getPort();

            try {

                telnet = new TelnetClient();

                telnet.setConnectTimeout(singleTimeout);
                telnet.connect(ip, Integer.parseInt(port));

                telnet.disconnect();

                successPosition = position;

                break;

            } catch (Exception e) {
                e.printStackTrace();
                try {
                    telnet.disconnect();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            } finally {
                if (successPosition != -1
                        ) {
                    // 已经找到了正确的地址
                    break;
                } else {
                    continue;
                }

            }

        }

        return successPosition;

    }

    @Override
    protected void onPostExecute(Integer successPosition) {
        super.onPostExecute(successPosition);

        if (successPosition == -1) {
//                ModuleToast.show(context, "所有地址都连接失败");
            result.fail(System.currentTimeMillis() - start);
        } else {
            result.success(list.get(successPosition));
//                ModuleToast.show(context, list.get(successPosition).getIp() + "连接成功");
        }
    }
}
