package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.content.res.AssetManager;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/**
 * Created by yangpeng on 2018/5/3.
 */

public class Util {

    /**
     * 查询asset 下是否包含此文件
     *
     * @param fileName
     * @return
     */
    public static boolean assetFileIsExist(Context context, String fileName) {
        InputStream inputStream = null;
        AssetManager manager = context.getAssets();
        try {
            inputStream = manager.open(fileName);
            if (inputStream != null) {
                return true;
            }
        } catch (IOException e) {
            return false;
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }




    /**
     * 数组转换成十六进制字符串
     *
     * @param
     * @return HexString
     */
    public static String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        String sTemp;
        for (int i = 0; i < bArray.length; i++) {
            sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2)
                sb.append(0);
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }



    /**
     * 判断证书是否在有效期内
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     * @return true 有效; false 过期
     */
    public static boolean certIsValid(CertDetailInfo info) {


        Date dataStart = info.notBefore;
        Date dataEnd = info.notAfter;

        Date currentDate = new Date();

        if((currentDate.getTime() - dataStart.getTime() <= 5*60*1000 || dataStart.getTime() - currentDate.getTime() <= 5*60*1000)&&
        currentDate.before(dataEnd)){
//            ModuleLog.e("currentDate = " + currentDate.toString());
//            ModuleLog.e("currentDate.after(dataStart) = " + currentDate.after(dataStart));
//            ModuleLog.e("currentDate.before(dataEnd) = " + currentDate.before(dataEnd));
//        if (
//                currentDate.after(dataStart) &&
//                currentDate.before(dataEnd)) {
            return true;
        } else {
            return false;
        }

    }


    /**
     * 证书有效期将至（距离失效小于15天）
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     * @return
     */
    public static boolean certValidIsExpire(CertDetailInfo info) {

        Date dataEnd = info.notAfter;

        Date currentDate = new Date();

        ModuleLog.e("currentDate = " + currentDate.toString());
        ModuleLog.e("currentDate.getTime() = " + currentDate.getTime());
        ModuleLog.e("dataEnd.getTime() = " + dataEnd.getTime());
        if (certIsValid(info) && (dataEnd.getTime() - currentDate.getTime() < 15 * 24 * 60 * 60 * 1000)) {
            return true;
        } else {
            return false;
        }


    }


}
