package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.BusProvider;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.PhoneApplyActivity;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.RevokeOwnOldCertRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.NET_VHSMInitResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.CertOperate;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;

import java.io.IOException;
import java.util.ArrayList;

import okhttp3.Call;
import okhttp3.RequestBody;

import static com.xdja.safeclient.certcreation.bean.OkNetError.handleErrorCodeToMsg;

/**
 * Created by yangpeng on 2018/4/20.
 */

public class CertItemView extends RelativeLayout {

    private CertService certService = new CertService();

    private FrameLayout container_child;
    private View marginView;
    private ImageView inUse;
    private ChipBean chipBean;
    private int containerNum;
    private Context context;

    /**
     * 写入证书失败的原因
     */
    private static int importCertErrorCode = 0;

    // REFACTOR: 2019/8/8 jff  此处定义需明确
    private static final int QUERY_CERT_INFO_FROM_SERVER = 0;
    /**
     * 实体认证结果查询通过
     */
    private static final int APPLY_CERT_REQUEST = 1;
    /**
     * 实体认证结果查询失败
     */
    private static final int QUERY_AUTHENTICATION_RESULT = 2;
    /**
     * 证书写卡失败
     */
    private static final int IMPORT_CERT_FAIL = 3;

    /**
     * 客户端服务端证书机制不一致
     */
    private static final int CLIENT_SERVER_CERT_RULE_DIFFERENT = 4;

    // REFACTOR: 2019/8/8 jff  object具体内容
    private String object;

    /**
     * 加密设备ID
     */
    private String deviceID;

    /**
     * 加密设备类型
     */
    private String cardNum;
    private CryptoDevType chipBeanType;

    // REFACTOR: 2019/8/8 jff  CertItemBean  实际可以用CryptoDevInfo代替，这里重新定义一个是否有必要
    private CertItemBean certItemBean;


    private String certRule;

    private String certType;

    private RecyclerViewAdapter recyclerViewAdapter;

    private boolean isCertOK = false; //证书是否处于正常状态

    private boolean allowApplyCert;

    /**
     * 实体认证结果msg
     */
    private String authResultMsg;

    private MyHandler myHandler;

    private String procudure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

    private boolean isOnlineVHSM = AppConfig.getInstance().getCertConfig().getVHSMType()
            .equals(CardType.ONLINE_VHSM);

    /**
     * 本地读取证书
     */
    private static final int TAG_QUERY_CERT_STATE = 0;

    /**
     *
     */
    public static final int TAG_QUERY_CERT_STATE_WITH_POLL = 1;

    /**
     * 是否是同一设备的第一个容器
     */
    private boolean isFirst;

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from(context).inflate(R.layout.cert_item_layout_new, this);

        BusProvider.register(this);

    }


    /**
     * 本地是否有证书，在RecyclerViewAdapter判断是否跳转到详情页
     *
     * @return true 本地有证书  false 本地无证书
     */
    public boolean isCertOK() {
        return isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter,
                        CertItemBean certItemBean, String object, boolean isFirst) {

        this.object = object;

        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;

        this.isFirst = isFirst;

        chipBeanType = this.certItemBean.getCryptoDevInfo().getType();

        initView();
        deviceID = DeviceWrapper.getInstance().getCardID(chipBeanType);
        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM) && chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            deviceID = NetVHSMHandle.getNetVhsmCardId(context);
        }


        if (TextUtils.isEmpty(deviceID)) {
            showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        } else {
            RequestCache.getInstance().putType(deviceID, chipBeanType.getType());
        }

        containerNum = this.certItemBean.getCertConfig().getContainerNum();

        certRule = this.certItemBean.getCertConfig().getCertRule();

        certType = this.certItemBean.getCertConfig().getCertType();

        allowApplyCert
                = this.certItemBean.getCertConfig().getCertPermission().equals(CertPermission.APPLY);

        cardNum = DeviceWrapper.getInstance().getCardID(chipBeanType);

        myHandler = new MyHandler(this, allowApplyCert);

        if (isOnlineVHSM
                && chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            cardNum = NetVHSMHandle.getNetVhsmCardId(context);
        }
        this.recyclerViewAdapter = recyclerViewAdapter;

        initView();
        if (TextUtils.isEmpty(cardNum)) {
            showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        } else {
            RequestCache.getInstance().putType(cardNum, chipBeanType.getType());
        }

        queryCertInfo(false);
    }

    private ChipExecutorService chipExecutorService = new ChipExecutorService();

    /**
     * 本地读取证书
     */
    private void queryCertInfo(final boolean pollAddress) {

        // 融合版空包IP为null，直接展示网络异常
        if (getIPState() == IP_NULL) {
            showNoCertDatabaseErrorLayout();
            return;
        }

        showChecking();
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);

                CertDetailInfo info;

                info =
                        DeviceWrapper.getInstance().readCertFromContainer(
                                CertItemView.this.chipBeanType, containerNum,
                                certType);

                if (info != null) {
                    ModuleLog.d("CertItemView", info);
                }
                bean.setCertDetailInfo(info);

                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                } else {

                    if (!Util.certIsValid(bean.getCertBean())) {
                        // 证书已过期
                        bean.setState(CertState.CERT_OUT_OF_DATE);
                    } else {
                        bean.setState(CertState.SUCCESS);
                    }


                    if (!BuildConfig.isAAR || !FeatureConfig.getInstance().isDisableMakeNewCert()) {
                        boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(
                                context, chipBeanType, containerNum);
                        bean.setIsVerify(isVerify);
                    }
                }

                if (pollAddress) {
                    chipExecutorService.sendMessage(myHandler, TAG_QUERY_CERT_STATE_WITH_POLL, bean);
                } else {
                    chipExecutorService.sendMessage(myHandler, TAG_QUERY_CERT_STATE, bean);
                }

            }
        };
        chipExecutorService.exe(runnable);
    }

    /**
     * 获取ChipBean
     *
     * @return
     */
    public ChipBean getChipBean() {
        return chipBean;
    }

    public static final int IP_SUCCESS = 0;

    public static final int IP_NULL = -1;

    public static final int IP_POLL_FAIL = -2;

    private int getIPState() {

        String ip = AppConfig.getInstance().getServerSettingConfig()
                .getIp();

        if (TextUtils.isEmpty(ip)) {
            return IP_NULL;
        } else if (ip.contains("|")) {
            return IP_POLL_FAIL;
        } else {
            return IP_SUCCESS;
        }

    }

    private boolean isVHSMIPFail() {
        String ip = AppConfig.getInstance().getServerSettingConfig()
                .getVhsm_ip();
        if (ip == null) {
            return true;
        } else {
            return ip.contains("|");
        }
    }

    private static class MyHandler extends WeakReferenceHandler<CertItemView> {

        boolean allowApply;

        boolean pollAddress;

        public MyHandler(CertItemView reference, boolean allowApply) {
            super(reference);
            this.allowApply = allowApply;
        }

        @Override
        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean) msg.obj;

            if (msg.what == TAG_QUERY_CERT_STATE_WITH_POLL) {
                pollAddress = true;
            } else {
                pollAddress = false;
            }

            if (msg.what == TAG_QUERY_CERT_STATE
                    || msg.what == TAG_QUERY_CERT_STATE_WITH_POLL) {

                if (reference.chipBean.getState() == CertState.SUCCESS
                        && !reference.chipBean.getIsVerify()) {
                    //有证书但验签不通过，只展示证书信息，不再获取证书状态
                    reference.showCertDetail(R.string.cert_creation_cert_not_in_system, reference.chipBean);
                    //关闭下拉刷新动画
                    OttoUtil.postQueryFishied();
                } else {
                    // 展示证书的情况下，无证书直接显示无证书，有证书直接显示本地证书
                    // 不再去服务端查询状态
                    if (!allowApply) {
                        if (reference.chipBean.getState() == CertState.NO_CERT) {

                            // 如果是多运营商，直接展示网络异常
                            if (reference.getIPState() == IP_POLL_FAIL) {
//                                reference.showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                                reference.queryCertStateFromServer(pollAddress, true);
                            } else {
                                // 否则，直接展示无证书
                                reference.showNoCert();
                            }

                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    } else if (BuildConfig.isAAR && FeatureConfig.getInstance().isDisableMakeNewCert()) {

                        //融合版如果没证书不再继续查找去服务端查找证书

                        if (reference.chipBean.getState() == CertState.NO_CERT) {
                            reference.showNoCert();
                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    } else {
                        reference.queryCertStateFromServer(pollAddress);
                    }
                }

            } else {
                if (reference.chipBean.getState() == CertState.NO_CERT) {
                    reference.showNoCert();
                } else {
                    reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                }
            }
        }
    }


    private void initView() {
        TextView name = (TextView) findViewById(R.id.name);
        ImageView icon = findViewById(R.id.icon);
        marginView = findViewById(R.id.margin);
        container_child = (FrameLayout) findViewById(R.id.container_child);
        if (chipBeanType == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.cert_creation_tf_cert);
            icon.setBackgroundResource(R.drawable.tf_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.cert_creation_chip_cert);
            icon.setBackgroundResource(R.drawable.chip);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.cert_creation_tiemo_cert);
            icon.setBackgroundResource(R.drawable.sim_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.cert_creation_soft_cert);
            icon.setBackgroundResource(R.drawable.vhsm);
        }

        // 同一个设备有多个容器时，非第一个容器的卡类型所在的布局都隐藏
        View item = findViewById(R.id.item);


        if (isFirst) {
            item.setVisibility(VISIBLE);

            String cardType = certItemBean.getCertConfig().getCardType();
        } else {
            item.setVisibility(GONE);
        }


        TextView cardNo = (TextView) findViewById(R.id.card_num);
        cardNo.setText(certItemBean.getCryptoDevInfo().getCardId());

        TextView tvContainerNum = findViewById(R.id.tv_container_num);
        tvContainerNum.setText(context.getString(R.string.cert_creation_config_container_num)
                + "："
                + String.valueOf(containerNum));

        inUse = (ImageView) findViewById(R.id.in_use);

        // TODO: 2019/3/27 0027 加一个正在使用判断显示隐藏的接口
        if (chipBean != null || DeviceWrapper.getInstance().getInUse() == null) {
            if (chipBean.getCertBean() != null) {
                if (DeviceWrapper.getInstance().getInUse().equals(chipBean.getCertBean().sn)) {
                    //是否正在使用当前证书，根据证书编号判断
                    inUse.setVisibility(VISIBLE);
                } else {
                    inUse.setVisibility(GONE);
                }
            } else {
                inUse.setVisibility(GONE);
            }

        } else {
            inUse.setVisibility(GONE);
        }


        container_child.setVisibility(View.VISIBLE);
    }

    public boolean inUse() {
        return inUse.getVisibility() == VISIBLE;
    }

    private void showChecking() {
        showChecking(-1);
    }

    /**
     * 显示Loading
     */
    private void showChecking(int strId) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView) view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(context, imageView);
        showView(view);

        if (strId != -1) {
            TextView textView = view.findViewById(R.id.checking_text);
            textView.setText(getResources().getText(strId));
        }
        marginView.setVisibility(View.VISIBLE);
    }

    /**
     * netVHSM初始化失败
     */
    private void showInitNetVHSMFailLayout() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView) view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);
        fail_reason.setText("VHSM初始化失败，请重试");
        bottom_button_layout.setVisibility(VISIBLE);
        tv_apply.setText(R.string.cert_creation_reinit);
        bottom_button_layout.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                showChecking(R.string.cert_creation_vhsm_init);
                //                String ipStr[] = getVhsmUrl();
                //                if (ipStr == null) {
                //                    return;
                //                }
                NetVHSMHandle.initVHSM(context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                //初始化的结果在handleNetVhsmInitResult里处理
            }
        });
        showView(view);

    }

    @Subscribe
    public void handleNetVhsmInitResult(NET_VHSMInitResult initResult) {
        if (chipBeanType.getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            int initResultInt = initResult.getNet_VHSMinitResult();
            ModuleLog.e("481 CertItemView handleNetVhsmInitResult" + this.object.toString());
            if (initResultInt == 0) {//初始化成功获取p10
                CryptoDevManager.getInstance().onDriverDeviceAdded(
                        new ChipManagerDriver(), CryptoDevType.DEV_TYPE_Soft,
                        NetVHSMHandle.getNetVhsmCardId(context));
                DeviceWrapper.getInstance().getDevInfo();
                showChecking(R.string.cert_creation_is_applying_cert);
                OttoUtil.postSwipPullResult(false);
                ModuleLog.e("489 CertItemView handleNetVhsmInitResult ");
                getP10ReqestBCAndApplyCert(authResultMsg);
            } else {//初始化失败展示当前界面
                showInitNetVHSMFailLayout();

            }

        }

    }


    /**
     * 展示服务端返回的异常对应的界面
     *
     * @param message
     */
    private void showErrorResponseLayout(String title, String message, boolean isReapply) {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView) view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);


        fail_reason.setText(message);

        if (isReapply) {

            bottom_button_layout.setVisibility(VISIBLE);
            tv_apply.setText(R.string.cert_creation_reapply);
            bottom_button_layout.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    ModuleLog.d("0showErrorResponseLayout,请求权限");
                    requestPhonePermission();
                }
            });
        } else {
            bottom_button_layout.setVisibility(GONE);
        }

        // 禁止申请证书，隐藏申请证书按钮
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            bottom_button_layout.setVisibility(GONE);
        }

        //错误码是一人一卡一证书
        //todo 2018-08-15 jff 手机号流程一人一卡一证及一人一证文案需要进一步修改
        if (message.contains(context.getString(R.string.cert_creation_one_person_one_cert))
                || message.contains(context.getString(R.string.cert_creation_one_person_one_cardType_one_cert))) {
            tv_apply.setText(R.string.cert_creation_revoke_old_cert);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    //todo 撤销非当前设备的证书并申请证书
                    revokeOwnOldCert();
                }
            });
        }

        //vhsm同步人员失败，重新初始化
        if (message.contains(context.getString(R.string.cert_creation_vhsm_import_person_fail))) {
            tv_apply.setText(R.string.cert_creation_reinit);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    //重新进行实体认证
                    applyCert(chipBeanType.getType());
                }
            });
        }


        // TODO: 2018/11/2 0002 文字变成刷新之后，点击事件也要随之变化
        if (message.contains(context.getString(R.string.cert_creation_server_error_short))) {
            tv_apply.setText(R.string.cert_creation_retry);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    queryCertStateFromServer(true);
                }
            });
        }


        showView(view);

    }

    /**
     * 展示服务端返回的异常对应的界面
     *
     * @param message
     */
    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(VISIBLE);

        Button button = (Button) view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                ModuleLog.d("0showErrorResponseLayout", "请求权限");
                requestPhonePermission();
            }
        });

        // TODO: 2018/11/2 0002 文字变成刷新之后，点击事件也要随之变化
        if (message.contains(context.getString(R.string.cert_creation_server_error_short))
                || message.contains(context.getString(R.string.cert_creation_app_time_exception_user))) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    queryCertStateFromServer(true);
                }
            });
        }

        if (message.contains("安全设备失败")) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    cardNum = DeviceWrapper.getInstance().getCardID(chipBeanType);
                    if (TextUtils.isEmpty(cardNum)) {
                        showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
                        return;
                    } else {
                        queryCertStateFromServer(true);
                    }
                }
            });
        }


        TextView content = (TextView) view.findViewById(R.id.fail_reason);
        content.setText(message);

        showView(view);
    }


    /**
     * 设备未激活
     */
    private void showDevNOActivation() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_dev_no_activition, null);
        showView(view);
    }

    /**
     * 展示没有证书，去申请
     */
    private void showNoCert() {
        final View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_no_cert, null);

        View layoutApplyCert = view.findViewById(R.id.apply_cert_layout);

        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            layoutApplyCert.setVisibility(GONE);
        } else if (!AppConfig.getInstance().isHasDB()) {
            layoutApplyCert.setVisibility(GONE);
        } else if (!allowApplyCert) {
            layoutApplyCert.setVisibility(GONE);
        } else {
            layoutApplyCert.setVisibility(VISIBLE);
        }


        Button appBtn = view.findViewById(R.id.apply_cert_btn);
        if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                && !NetVHSMHandle.isNetVHSMCanUse()) {
            ((TextView) view.findViewById(R.id.cert_item_top_one_content)).setText(R.string.cert_creation_no_init);
            appBtn.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        }

        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ModuleLog.d("0showNoCert, 请求权限");

                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();

                if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && (!NetVHSMHandle.isNetVHSMCanUse())
                        && isVHSMIPFail()
                        ) {

                    showChecking(R.string.cert_creation_choose_address);

                    ArrayList<ServerAddress> list =
                            AppConfig.getInstance()
                                    .getServerSettingConfig()
                                    .getVhsmAddressList();

                    int timeout = 2000;

                    ChooseTask task = new ChooseTask(
                            list
                            , timeout
                            , new ChooseTask.ChooseResult() {
                        @Override
                        public void success(ServerAddress address) {

                            showNoCert();

                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_port(address.getPort());

                            requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {

                            OttoUtil.postCancelChooseAddressLoading();

                            showErrorVHSMAddressLayout();

                        }


                    });

                    task.execute();

                } else {
                    requestPhonePermission();
                }

            }
        });
        showView(view);
    }

    private void showErrorVHSMAddressLayout() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(VISIBLE);

        String message;

        if (!CommonUtil.isNetworkConnected(context)) {
            message = context.getString(R.string.net_disconnected_text);
            chipBean.setState(CertState.NET_ERROR);
        } else {
            message = context.getString(R.string.net_timeout);
            chipBean.setState(CertState.NET_TIMEOUT);
        }

        Button button = (Button) view.findViewById(R.id.tv_apply);
        button.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        button.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

                ModuleLog.d("0showNoCert, 请求权限");

                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();

                if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && vhsmIP.contains("|")
                        ) {

                    showChecking(R.string.cert_creation_choose_address);

                    ArrayList<ServerAddress> list =
                            AppConfig.getInstance()
                                    .getServerSettingConfig()
                                    .getVhsmAddressList();

                    int timeout = 2000;

                    ChooseTask task = new ChooseTask(
                            list
                            , timeout
                            , new ChooseTask.ChooseResult() {
                        @Override
                        public void success(ServerAddress address) {

                            OttoUtil.postCancelChooseAddressLoading();

                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_port(address.getPort());

                            requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {

                            OttoUtil.postCancelChooseAddressLoading();

                            showErrorVHSMAddressLayout();

                        }


                    });

                    task.execute();

                } else {
                    requestPhonePermission();
                }

            }
        });

        TextView content = (TextView) view.findViewById(R.id.fail_reason);
        content.setText(message);

        showView(view);

    }

    private void requestPhonePermission() {
        ModuleLog.d("1点击准备申请证书");
        // 处理权限请求的地方在CertViewActivity中
        // OttoUtil.postRequestPhonePermission(CertItemView.this.chipBeanType.getType(), cardNum);

        applyCert(chipBeanType.getType());
    }

    private void applyCert(int cardType) {

        //        String imsi = DeviceWrapper.getInstance().getIMSI();
        //        if (imsi == null || imsi.equals("")) {
        //            // ModuleToast.show(context, R.string.get_imsi_failed);
        //
        //            SinglePermissionDialog dialog = new SinglePermissionDialog();
        //            dialog.build(context, context.getString(R.string.cert_creation_get_imsi_failed));
        //            dialog.show();
        //
        //            return;
        //        }

        SharePreferencesUtil.saveCurrentDevType(context, cardType);
        SharePreferencesUtil.saveDevCardID(context, cardNum);
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.setIsRefresh(false);
        }

        SharePreferencesUtil.saveActivityObjectName(context, object);

        RequestCache.getInstance().setObject(object);

        if (procudure.equals(Procedure.PHONE)) {

            // 手机号发证流程

            if (BuildConfig.isAAR || BaseActivity.DEBUG_AAR) {

                Intent intent = new Intent(context, PhoneApplyActivity.class);
                intent.putExtra(ActivityParam.CARD_TYPE,
                        CryptoDevTypeUtil.formatType(cardType));
                intent.putExtra(ActivityParam.CARD_NUM, cardNum);
                intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
                intent.putExtra(ActivityParam.CERT_TYPE, certType);
                context.startActivity(intent);

            } else {
                ARouter.getInstance()
                        .build(ActivityPath.ACTIVITY_PHONE_APPLY_CERT)
                        .withSerializable(ActivityParam.CARD_TYPE,
                                CryptoDevTypeUtil.formatType(cardType))
                        .withString(ActivityParam.CARD_NUM, cardNum)
                        .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                        .withString(ActivityParam.CERT_TYPE, certType)
                        .navigation(context);
            }

        } else {

            // 持证拍照流程

            // 注意applyCert方法中用的都是cardType，不是type

            if (BuildConfig.isAAR || BaseActivity.DEBUG_AAR) {

                Intent intent = new Intent(context, PhoneInputActivity.class);
                intent.putExtra(ActivityParam.CARD_TYPE,
                        CryptoDevTypeUtil.formatType(cardType));
                intent.putExtra(ActivityParam.CARD_NUM, cardNum);
                intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
                intent.putExtra(ActivityParam.CERT_TYPE, certType);
                context.startActivity(intent);

            } else {

                ARouter.getInstance()
                        .build(ActivityPath.ACTIVITY_PHONE_INFO)
                        .withSerializable(ActivityParam.CARD_TYPE,
                                CryptoDevTypeUtil.formatType(cardType))
                        .withString(ActivityParam.CARD_NUM, cardNum)
                        .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                        .withString(ActivityParam.CERT_TYPE, certType)
                        .navigation(context);
            }

        }


    }

    /**
     * 展示无配置时的界面
     * <p>
     * 此场景仅出现在融合版，安全接入空包没有配置，在点击证书查看时进入
     * <p>
     * 因为数据库是空，不能获取到服务端IP，所以直接展示网络异常
     */
    private void showNoCertDatabaseErrorLayout() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);

        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);

        //处理网络问题，没网/请求超时
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected(context)) {
            netRes = R.string.net_disconnected_text;
        } else {
            netRes = R.string.net_timeout;
        }

        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);

        showView(view);


    }

    /**
     * 展示申请失败view
     */
    private void showOtherFailLayout(final int requestType, final String p10) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);

        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);

        //处理网络问题，没网/请求超时
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected(context)) {
            netRes = R.string.net_disconnected_text;
            chipBean.setState(CertState.NET_ERROR);
        } else {
            netRes = R.string.net_timeout;
            chipBean.setState(CertState.NET_TIMEOUT);
        }
        switch (requestType) {
            case QUERY_CERT_INFO_FROM_SERVER:
                if (chipBean.getCertBean() != null) {
                    showCertDetail(netRes, chipBean);

                    view.setVisibility(GONE);
                    return;
                } else {
                    if (netRes == -1) {
                        netRes = R.string.cert_creation_cert_state_query_fail;
                    }
                }
                break;
            case APPLY_CERT_REQUEST:
                netRes = R.string.cert_creation_register_fail_reapply;
                break;
            case QUERY_AUTHENTICATION_RESULT:
                netRes = R.string.cert_creation_authentiation_result_fail;
                break;
            case IMPORT_CERT_FAIL:
                netRes = R.string.cert_creation_write_authentiation_fail;

                if (importCertErrorCode == CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                    chipBean.setState(CertState.NO_CERT);
                    netRes = R.string.cert_creation_client_sercer_certrule_different;
                }

                break;
        }
        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);
        reApply.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean isNetOK = CommonUtil.isNetworkConnected(context);
                switch (requestType) {
                    case QUERY_CERT_INFO_FROM_SERVER:
                        if (isNetOK) {
                            queryCertInfo(true);
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case APPLY_CERT_REQUEST:
                        if (isNetOK) {
                            showChecking();
                            applyCertRequest(p10);
                            ModuleLog.e("申请证书 CertItemView showOtherFailLayout line 409");
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case QUERY_AUTHENTICATION_RESULT:
                        if (isNetOK) {
                            showChecking();
                            queryAuthenticationResult();
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case IMPORT_CERT_FAIL://
                        if (importCertErrorCode ==
                                CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                            queryCertStateFromServer(true);
                        } else {
                            requestPhonePermission();
                        }
                        break;
                }

            }
        });
        showView(view);
    }

    /**
     * 展示申请失败view
     */
    private void showRegisterFail() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_no_cert, null);
        TextView cert_item_top_one_content = (TextView) view.findViewById(R.id.cert_item_top_one_content);
        View reApply = view.findViewById(R.id.apply_cert_layout);
        //TextView tv_apply = (TextView) view.findViewById(R.id.tv_apply);

        cert_item_top_one_content.setText(R.string.cert_creation_register_fail_reapply);
        //tv_apply.setText(R.string.reapply);

        reApply.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ModuleLog.d("0showRegisterFail, 请求权限");
                requestPhonePermission();
            }
        });
        showView(view);
    }


    /**
     * 信息已提交，请等待审核
     */
    private void showWaiteVerity() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_wait, null);

        view.findViewById(R.id.refresh).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                showChecking(R.string.cert_creation_identity_result_checking);
                queryAuthenticationResult();
            }
        });

        showView(view);
    }


    /**
     * 芯片详情  by gyx 2018.6.27
     *
     * @param chipBean
     */
    private void showCertDetail(@StringRes final int strRes, final ChipBean chipBean) {
        this.chipBean = chipBean;
        this.isCertOK = true;

        final View view =
                LayoutInflater.from(context).inflate(R.layout.cert_item_layout_detail_new, null);

        myHandler.postDelayed(new Runnable() {
            @Override
            public void run() {

                // TODO: 2019/9/2 0002 箭头展示以后再做

                // 只查看证书列表，没有发证功能时，隐藏跳转到下一级的箭头
            /*    View forward = view.findViewById(R.id.cert_status);
                if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
                    forward.setVisibility(GONE);
                } else {
                    forward.setVisibility(VISIBLE);
                }*/


                TextView tvCertState = (TextView) view.findViewById(R.id.tv_cert_state);
                TextView tvCertType = view.findViewById(R.id.tv_cert_type);
                TextView tvSN = (TextView) view.findViewById(R.id.tv_sn);
                TextView tvUser = (TextView) view.findViewById(R.id.tv_user);
                TextView tvPeroid = (TextView) view.findViewById(R.id.tv_peroid);


                if (strRes == R.string.cert_creation_normal_state_item) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_normal_success));
                } else if (strRes == R.string.cert_creation_be_frozen ||
                        strRes == R.string.cert_creation_thaw_reject ||
                        strRes == R.string.cert_creation_update_reject ||
                        strRes == R.string.cert_creation_server_nocert ||
                        strRes == R.string.cert_creation_cert_out_of_date ||
                        strRes == R.string.cert_creation_revoke_success ||
                        strRes == R.string.cert_creation_revoke_reject ||
                        strRes == R.string.cert_creation_cert_not_in_system ||
                        strRes == R.string.net_disconnected_text ||
                        strRes == R.string.net_timeout ||
                        strRes == R.string.cert_creation_detail_revoke_success
                        ) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_fail_error));
                } else if (
                        strRes == R.string.cert_creation_revoke_ing ||
                                strRes == R.string.cert_creation_thaw_ing ||
                                strRes == R.string.cert_creation_update_ing) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_ing));
                }

                tvCertState.setText(strRes);

                CertDetailInfo certDetailInfo = chipBean.getCertBean();

                // TODO: 2019/4/4 0004 这个地方是有可能为空崩溃的
                if (certDetailInfo == null) {
                    return;
                }

                tvCertType.setText(certType);

                String sn = certDetailInfo.sn;
                tvSN.setText(sn);

                String owner = getCertHolder(certDetailInfo.subjectCn);
                tvUser.setText(owner);

                String peroid = certDetailInfo.indate;
                tvPeroid.setText(peroid);

                showView(view);
                marginView.setVisibility(View.VISIBLE);
            }
        }, 10);

    }

    private void showView(View view) {
        marginView.setVisibility(View.GONE);
        container_child.removeAllViews();
        container_child.addView(view);
    }


    /**
     * 获取证书持有人字符串
     *
     * @param sn
     * @return
     */
    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; i++) {
            String cnStr = split[i];

            if (cnStr.contains("CN=")) {
                int beginIndex = 3;
                int length = cnStr.length();
                //int endIndex = length < 20 ? length : 20;
                return split[i].substring(beginIndex, length);
            }
        }
        return "";
    }

    private CertStateRequest buildRequest() {
        final CertStateRequest certStateRequest = new CertStateRequest();
        if (chipBean.getCertBean() != null) {
            String sn;
            //本地有证书，用本地证书的sn查询证书状态
            //双证并且显示证书配置成交换证书，那么查询证书状态用签名证书的sn去查询，
            // 是因为pams和空中发证服务端之前约定双证情况下查询证书状态时通过签名证书的sn查询的，
            // 故这里用签名证书sn去查询，单证情况不影响  2019.6.14  jff
            if (certType.equals(CertType.ENCRYPT)
                    && this.certRule.equals(CertRule.DOUBLE_CERT)) {
                CertDetailInfo info =
                        DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType,
                                containerNum,
                                CertType.SIGNING);
                if (info != null) {
                    sn = info.sn;
                } else {
                    sn = "";
                }
            } else {
                sn = chipBean.getCertBean().sn;
            }

            certStateRequest.setSn(sn);
        } else {
            certStateRequest.setSn("");
        }

        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));

        return certStateRequest;
    }

    private void queryCertStateFromServer(boolean poolAddress) {
        queryCertStateFromServer(poolAddress, false);
    }

    /**
     * 2.6【I-airIssue-api-007】查询证书状态
     * 查询证书状态
     *
     * @param pollAddress 是否轮询地址
     * @param isReFresh   是否是多运营商无可用地址状态下点击刷新
     */
    private void queryCertStateFromServer(boolean pollAddress, final boolean isReFresh) {

        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            OttoUtil.postQueryFishied();
            return;
        }

        int ipState = getIPState();

        if (ipState == IP_POLL_FAIL) {
            if (pollAddress) {

                showChecking(R.string.cert_creation_choose_address);

                ChooseTask task = new ChooseTask(
                        AppConfig.getInstance().getServerSettingConfig().getServerAddressList()
                        , 2000
                        , new ChooseTask.ChooseResult() {
                    @Override
                    public void success(ServerAddress address) {

                        AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                        AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());

                        if (isReFresh) {

                            CertDetailInfo info =
                                    DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType,
                                            containerNum,
                                            certType);

                            if (info == null) {
                                chipBean.setState(CertState.NO_CERT);
                            } else {
                                chipBean.setCertDetailInfo(info);
                                if (!Util.certIsValid(chipBean.getCertBean())) {
                                    // 证书已过期
                                    chipBean.setState(CertState.CERT_OUT_OF_DATE);
                                } else {
                                    chipBean.setState(CertState.SUCCESS);
                                }

                                if (!BuildConfig.isAAR || !FeatureConfig.getInstance().isDisableMakeNewCert()) {
                                    boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(
                                            context, chipBeanType, containerNum);
                                    chipBean.setIsVerify(isVerify);
                                }

                            }
                            chipBean.setCertDetailInfo(info);

                            if (info == null) {
                                showNoCert();
                            } else {
                                showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                            }

                        } else {
                            CertStateRequest certStateRequest = buildRequest();
                            query(certStateRequest);
                        }
                    }

                    @Override
                    public void fail(long time) {

                        OttoUtil.postCancelChooseAddressLoading();

                        // TODO: 2020/3/10 0010 这个是把上面网络异常的 处理给搬过来用了
                        showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                        OttoUtil.postQueryFishied();
                    }


                });

                task.execute();

                return;
            } else {
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                OttoUtil.postQueryFishied();
                return;
            }
        } else if (ipState == IP_NULL) {
            showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            OttoUtil.postQueryFishied();
            return;
        } else {
            CertStateRequest certStateRequest = buildRequest();
            query(certStateRequest);
        }

    }

    private void query(RequestBody certStateRequest) {

        showChecking();

        CertDetailInfo info =
                DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType,
                        containerNum,
                        certType);

        if (info == null) {
            chipBean.setState(CertState.NO_CERT);
        } else {
            chipBean.setCertDetailInfo(info);
            if (!Util.certIsValid(chipBean.getCertBean())) {
                // 证书已过期
                chipBean.setState(CertState.CERT_OUT_OF_DATE);
            } else {
                chipBean.setState(CertState.SUCCESS);
            }

            if (!BuildConfig.isAAR || !FeatureConfig.getInstance().isDisableMakeNewCert()) {
                boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(
                        context, chipBeanType, containerNum);
                chipBean.setIsVerify(isVerify);
            }

        }

        CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            }


            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
                ModuleLog.d("CertItemView", "查询结果" + result + "\n");
                if (result.equals("0")) {
                    //0表示等待撤销审核，显示撤销信息已提交，等待审核
                    showCertDetail(R.string.cert_creation_revoke_ing, chipBean);
                    chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                    isCertOK = true;
                } else if (result.equals("1")) {
                    //1-证书已经被注销
                    showCertDetail(R.string.cert_creation_revoke_success, chipBean);
                    chipBean.setState(CertState.AGREE_REVOKE);
                    isCertOK = true;
                } else if (result.equals("2")) {
                    //2，证书注销申请被拒绝，正常显示
                    showCertDetail(R.string.cert_creation_revoke_reject, chipBean);
                    chipBean.setState(CertState.REJECT_REVOKE);
                    chipBean.setReason(commonResponse.getMessage());
                    isCertOK = true;
                } else if (result.equals("3")) {
                    //3-证书状态正常,本地没有找到证书，则提示联系管理员废弃
                    if (isChipBeanSizeIsZero()) {
                        // TODO: 2018/6/27
                        ModuleLog.e("1051 CertItemView onSuccessfulResponse : 本地无证书");
                        showErrorResponseLayout(context.getString(R.string.cert_creation_cert_query_fail), context.getString(R.string.cert_creation_cert_not_incard), false);
                    } else {
                        isCertOK = true;

                        if (chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            if (chipBean.getState() == CertState.SUCCESS && !chipBean.getIsVerify()) {
                                showCertDetail(R.string.cert_creation_cert_not_in_system, chipBean);
                            } else {
                                showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                            }
                        }

                    }

                } else if (result.equals("4")) {

                    //4-服务端证书不存在，若本地有证书，此时展示证书；若本地无证书，则查询身份认证结果
                    if (isChipBeanSizeIsZero()) {
                        queryAuthenticationResult();
                    } else {
                        showCertDetail(R.string.cert_creation_detail_revoke_success, CertItemView.this.chipBean);
                        chipBean.setState(CertState.SERVER_NOCERT);
                    }

                } else if (result.equals("5")) {
                    //5-证书被冻结
                    showCertDetail(R.string.cert_creation_be_frozen, chipBean);
                } else if (result.equals("6")) {
                    //6-证书处于解冻申请中
                    showCertDetail(R.string.cert_creation_thaw_ing, chipBean);
                } else if (result.equals("7")) {
                    //7-证书解冻申请被拒绝
                    showCertDetail(R.string.cert_creation_thaw_reject, chipBean);
                } else if (result.equals("8")) {
                    //8-证书处于延期申请中
                    showCertDetail(R.string.cert_creation_delay_ing, chipBean);
                } else if (result.equals("9")) {
                    //9-证书延期申请成功
                    showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                } else if (result.equals("10")) {
                    //10-证书延期申请被拒绝
                    showCertDetail(R.string.cert_creation_delay_reject, chipBean);
                } else if (result.equals("11")) {
                    // 11-证书处于更新申请中
                    showCertDetail(R.string.cert_creation_update_ing, chipBean);
                } else if (result.equals("12")) {
                    //12-证书更新成功
                    chipBean.setState(CertState.AGREE_UPDATE);
                    showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                } else if (result.equals("13")) {
                    //13 –证书更新申请被拒绝
                    showCertDetail(R.string.cert_creation_update_reject, chipBean);
                } else if (result.equals("14")) {
                    //14-证书已过期
                    chipBean.setState(CertState.CERT_OUT_OF_DATE);
                    showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //404	0x10a4	cert_status_other 	证书状态异常
                //400	0x10a3	cert_revoke_fail	证书注销失败
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });

    }

    @Subscribe
    public void updateCertState(CertOperate event) {

        ChipBean localBean = event.getChipBean();

        if (localBean.getType() != chipBeanType.getType()) {
            return;
        }

        if (event.getContainerNum() != containerNum) {
            return;
        }

        CertState state = localBean.getState();
        if (state == CertState.AGREE_UPDATE) {
            //证书信息更新成功
            isCertOK = true;
            localBean.setState(CertState.SUCCESS);
            showCertDetail(R.string.cert_creation_normal_state_item, localBean);
        } else if (state == CertState.WAITING_AGREE_REVOKE) {
            //等待撤销申请
            showCertDetail(R.string.cert_creation_revoke_ing, localBean);
            localBean.setState(CertState.WAITING_AGREE_REVOKE);
            isCertOK = true;
        } else if (state == CertState.AGREE_REVOKE) {
            //撤销申请成功
            showCertDetail(R.string.cert_creation_revoke_success, localBean);
            localBean.setState(CertState.AGREE_REVOKE);
            isCertOK = true;
        } else if (state == CertState.RECOVERY_PROGRESS) {
            //解冻申请受理中
            showCertDetail(R.string.cert_creation_recovery_progress, localBean);
            localBean.setState(CertState.RECOVERY_PROGRESS);
            isCertOK = true;
        } else if (state == CertState.RECOVERY_SUCCESS) {
            //解冻成功 显示正常使用
            isCertOK = true;
            localBean.setState(CertState.SUCCESS);
            showCertDetail(R.string.cert_creation_normal_state_item, localBean);
        } else if (state == CertState.REJECT_REVOKE) {

            showCertDetail(R.string.cert_creation_revoke_reject, localBean);
            localBean.setState(CertState.REJECT_REVOKE);
            isCertOK = true;

        } else {
            //本地证书删除成功
            isCertOK = false;
            showNoCert();
        }


    }


    /**
     * 拿到服务器返回的cert，开始写卡，并展示
     *
     * @param cert
     */
    private void writeCert(final String cert) {
        if (TextUtils.isEmpty(cert)) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return;
        }

        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                final int result = DeviceWrapper.getInstance().importCert(chipBeanType, containerNum, cert);

                myHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (result == 0) {

                            //CertItemView.this.recyclerViewAdapter.setIsRefresh(false);
                            showCertDetail();


                        } else {
                            if (result == -4) {
                                importCertErrorCode = CLIENT_SERVER_CERT_RULE_DIFFERENT;
                            }
                            writeCertToServer(cert, "1");

                        }
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        OttoUtil.postSwipPullResult(true);
                    }
                }, 10);

            }
        };
        chipExecutorService.exe(runnable);
    }

    /**
     * 发证成功后广播通知安全（接入）客户端
     */
    private void notifySafeAccess(Context context) {
        Intent intent = new Intent("com.xdja.aircert.write.success");
        context.sendBroadcast(intent);
    }

    private void showCertDetail() {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                final CertDetailInfo certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(chipBeanType, containerNum,
                        certType);

                //读取证书后，切换到主线程展示证书详情
                myHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        ChipBean chipBean = new ChipBean();
                        chipBean.setType(CertItemView.this.chipBean.getType());
                        chipBean.setCertDetailInfo(certDetailInfo);
                        if (!BuildConfig.isAAR) {
                            //TODO JFF 在融合版签发证书功能未启用前不校验根证书，当启用时还需要继续验证
                            boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(context, chipBeanType, containerNum);
                            chipBean.setIsVerify(isVerify);
                        }

                        // 证书已过期
                        if (!Util.certIsValid(chipBean.getCertBean())) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            if (chipBean.getState() == CertState.SUCCESS && !chipBean.getIsVerify()) {
                                showCertDetail(R.string.cert_creation_cert_not_in_system, chipBean);
                            } else {
                                showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                            }
                        }
                        chipBean.setName(getBeanName(chipBeanType));
                        //写卡成功后，将适配器中的申请流程设为false，这样其他状态再次进入证书列表页时可以刷新最新状态
                        notifySafeAccess(context);

                    }
                }, 10);
            }
        };

        chipExecutorService.exe(runnable);

    }

    //写卡状态上报
    private void writeCertToServer(final String cert, final String status) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                String sn = DeviceWrapper.getInstance().getSn(chipBeanType, containerNum, cert);
                //ModuleLog.e("待上报sn： " + sn);
                //                Looper.prepare();
                //                ModuleToast.show(context, R.string.cert_creation_import_cert_fail);
                final WriteFailRequest request = new WriteFailRequest();

                WriteFailInfo info = new WriteFailInfo();

                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                request.setInfo(info);
                //ModuleLog.e("上报发送的request： " + request.toString());
                final String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, info.toString());


                myHandler.post(new Runnable() {
                    @Override
                    public void run() {

                        // TODO: 2019/10/21 jff 此处判断条件需要做进一步分析，为什么之前用展示证书的类型做判断
                        if (certType.equals(CertType.ENCRYPT) && importCertErrorCode == CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                            showOtherFailLayout(IMPORT_CERT_FAIL, "");
                        } else {
                            if (sign != null && sign.length() > 0) {
                                if (sign.startsWith("errorCode")) {
                                    showErrorResponseLayout(sign.substring(9));
                                } else {
                                    request.setSign(sign);
                                    request.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
                                    uploadWriteCertResult(request);
                                }
                            }
                        }
                    }
                });
            }
        };

        chipExecutorService.exe(runnable);
    }


    private void uploadWriteCertResult(RequestBody request) {
        certService.uploadWriteCertResult(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        //网络异常，请重试
                        showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                        ModuleLog.e("上报写卡失败成功： ");
                        //写卡失败
                        showOtherFailLayout(IMPORT_CERT_FAIL, "");
                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                        //404	0x10a4	cert_status_other 	证书状态异常
                        //400	0x10a3	cert_revoke_fail	证书注销失败
                        String errorCode = baseErrorResponse.getErrCode();
                        handleErrorResponse(errorCode);
                    }

                    @Override
                    public void dismissDialog() {

                    }
                }
        );
    }


    /**
     * 目前只支持者四种芯片
     *
     * @param type
     * @return
     */
    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard:
                return R.string.cert_creation_tf_cert;
            case DEV_TYPE_Chip:
                return R.string.cert_creation_chip_cert;
            case DEV_TYPE_SimKey:
                return R.string.cert_creation_tiemo_cert;
            case DEV_TYPE_Soft:
                return R.string.cert_creation_soft_cert;
        }
        return R.string.cert_creation_chip_cert;

    }


    /**
     * 判断本地是否查找到证书
     *
     * @return
     */
    private boolean isChipBeanSizeIsZero() {
        return chipBean.getState() == CertState.NO_CERT

                ;
    }

    /**
     * 2.3.【I-airIssue-api-003】实体认证结果查询
     */
    private void queryAuthenticationResult() {

        String company = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();
        if (procudure.equals(Procedure.PHONE)) {
            showNoCert();
            return;
        }


        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            showOtherFailLayout(QUERY_AUTHENTICATION_RESULT, null);
            return;
        }

        // 如果实体认证结果不是等待中，则不继续执行
        int checkResult = SharePreferencesUtil.getCheckResult(context, chipBeanType.getType());
        if (checkResult != 0) {
            showNoCert();
            return;
        }


        String identityNum = SharePreferencesUtil.getIDCardNo(context, chipBean.getType());
        if (TextUtils.isEmpty(identityNum)) {
            // TODO: 2019/1/24 0024
            // 这个地方一定要判断身份证号是否为空，否则网络请求处理会崩溃
            // 理想状态下此处读到的身份证不可能为空
            // 但是，如果真的为空了，我们改怎么处理？
            return;
        }
        certService.queryAuthenticationResult(identityNum, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
                    // ModuleToast.show(CertDetailInfoActivity.this, R.string.device_not_exist);
                    // 上面提示卡设备不存在
                    showErrorResponseLayout("设备不存在", "请重新申请", true);
                    // 下面显示申请证书

                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                showOtherFailLayout(QUERY_AUTHENTICATION_RESULT, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                handleAuthResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {
        if (errorCode.equals(OkNetError.NOT_FOUND_CHECK_INFO_CODE)) {
            showNoCert();
        } else if (errorCode.equals(OkNetError.NOT_EXIST_INFO_CODE)) {
            //证书信息不存在，若本地有证书，则直接展示；若不存在，则查询实体认证结果
            if (isChipBeanSizeIsZero()) {
                queryAuthenticationResult();

            } else {
                CertItemView.this.chipBean.setState(CertState.SERVER_NOCERT);
                showCertDetail(R.string.cert_creation_detail_revoke_success, CertItemView.this.chipBean);
            }
        } else if (errorCode.equals(OkNetError.DEVICE_NO_ACTIVATION_CODE)) {
            showDevNOActivation();
        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this.context, errorCode);
            showErrorResponseLayout(msg);
        }
    }

    /**
     * 2.4.【I-airIssue-api-004】证书申请
     *
     * @param p10
     */
    private void applyCertRequest(final String p10) {
        if (!CommonUtil.isNetworkConnected(context)) {
            ModuleToast.show(context, R.string.net_disconnected_text);
            return;
        }
        //如果申请p10失败，则直接展示申请证书失败页面。
        if (p10.startsWith("errorCode")) {

            if (p10.contains("^[0-6]*$")) {
                // TODO: jff 2018-12-15 该出需要分析具体该怎么处理 第六迭代
                // dialog.show();
            }
            handleErrorResponse(p10.substring(9));
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return;
        } else if (p10.isEmpty()) {
            //TODO JFF 18.7.24展示错误信息
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }

        CertApplyRequest certApplyRequest = new CertApplyRequest();

        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBean.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        //        if (imsi == null || imsi.equals("")) {
        //            showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply), context.getString(R.string.cert_creation_get_imsi_failed), true);
        //            OttoUtil.postSwipPullResult(true);
        //            return;
        //        }
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(context));
        certApplyRequest.setChipInfo(chipInfo);

        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);

        String liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();

        if (!procudure.equals(Procedure.PHONE)) {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getIDCardNo(context, chipBean.getType()));
        } else {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getPhoneNum(context));
        }
        certApplyRequest.setP10(p10);

        ModuleLog.e("1538 CertItemView applyCertRequest : [p10]");
        certService.applyCert(certApplyRequest, cardNum, new HttpResponseCallBack<CertApplyResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                //TODO jff 2018-6-2 证书申请失败为什么要继续申请证书
                showOtherFailLayout(APPLY_CERT_REQUEST, p10);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String cert = certApplyResponse.getCert();
                writeCert(cert);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    /**
     * 处理实体认证的结果，并申请发证
     * <p>
     * 或处理注册成功后的结果，并申请发证
     *
     * @param result
     */
    @Subscribe
    public void onPhoneResult(PhoneAuthResult result) {
        if (result != null) {
            handlePhoneResult(result);
        }
    }

    private void handlePhoneResult(PhoneAuthResult phoneAuthResult) {

        PhoneResult auth = phoneAuthResult.getPhoneResult();


        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        //因为我们是在Item中注册的Otto，所以一条结果所有的Item都能收到
        //为了避免因此导致的界面更新混乱，现采用卡类型作为标志位（现假设一个手机上同一种卡设备只可能有一个）
        if (chipBeanType == null || type == null) {
            return;
        }

        if (type.getType() != chipBeanType.getType()) {
            return;
        }

        if (phoneAuthResult.getContainerNum() != containerNum) {
            return;
        }

        //        ModuleLog.e("手机号校验结果= " + result.toString());
        if (result.isSuccess()) {
            String ret = result.getResult();
            SharePreferencesUtil.saveCheckResult(context, chipBeanType.getType(), Integer.parseInt(ret));
            switch (ret) {
                case "0"://手机号格式正确
                    break;
                case "1"://手机号格式不正确
                case "2"://手机号长度不正确
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply),
                            context.getString(R.string.cert_creation_phone_number_wrong), true);
                    break;
            }
        }

    }


    /**
     * 处理实体认证的结果，并申请发证
     * <p>
     * 或处理注册成功后的结果，并申请发证
     *
     * @param result
     */
    @Subscribe
    public void onAuthResult(AuthResult result) {
        //ModuleLog.e(result);

        if (result == null) {
            return;
        }

        if (result.getObject() == null) {
            return;
        }

        if (!result.getObject().equals(object)) {
            return;
        }

        ModuleLog.e("请求：" + result.getObject() + "\n"

                + "当前：" + this.object
        );

        handleAuthResult(result);

    }

    private void handleAuthResult(AuthResult auth) {
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        //因为我们是在Item中注册的Otto，所以一条结果所有的Item都能收到
        //为了避免因此导致的界面更新混乱，现采用卡类型作为标志位（现假设一个手机上同一种卡设备只可能有一个）
        if (chipBeanType == null || type == null) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            ModuleLog.e("1649 CertItemView");
            return;
        }

        if (type.getType() != chipBeanType.getType()) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            ModuleLog.e("1659 CertItemView");
            return;
        }

        if (auth.getContainerNum() != containerNum) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            ModuleLog.e("1664 CertItemView");
            return;
        }

        if (result.isSuccess()) {
            //            synchronized (this) {
            ModuleLog.e("1669 CertItemView");
            handleAuthResult(result);
            //            }
        } else {
            ModuleLog.e("1672 CertItemView");
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            String message = result.getMessage();
            if (TextUtils.isEmpty(message)) {
                showRegisterFail();
            } else {
                showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply), handleErrorCodeToMsg(context, result.getErrCode()), true);
            }
        }
    }


    /**
     * 处理实体认证结果
     *
     * @param result
     */
    private void handleAuthResult(CommonResponse result) {
        showChecking();
        String ret = result.getResult();
        SharePreferencesUtil.saveCheckResult(context, chipBeanType.getType(), Integer.parseInt(ret));
        switch (ret) {
            case "0"://等待审核
                showWaiteVerity();
                break;
            case "1"://审核通过
                //实体认证成功将dn值存储下来
                authResultMsg = result.getMessage();

                ModuleLog.e("1700 CertItemView handleAuthResult : [result]");
                //如果目前展示的是netVHSM且VHSM没有进行初始化，需要对NetVHSM进行初始化
                if (isOnlineVHSM
                        && certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && !NetVHSMHandle.isNetVHSMCanUse()
                        ) {
                    //                    String ipStr[] = getVhsmUrl();
                    //                    if (ipStr == null) {
                    //                        return;
                    //                    }
                    showChecking(R.string.cert_creation_vhsm_init);
                    NetVHSMHandle.initVHSM(context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(),
                            Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                    //初始化结果在handleNetVhsmInitResult里处理
                } else {
                    //组装p10，获取证书
                    showChecking(R.string.cert_creation_is_applying_cert);
                    synchronized (this) {
                        ModuleLog.e("1717 CertItemView handleAuthResult : [result]");
                        OttoUtil.postSwipPullResult(false);
                        getP10ReqestBCAndApplyCert(authResultMsg);
                    }
                }
                break;
            case "2"://审核拒绝
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                authResultMsg = result.getMessage();
                if (TextUtils.isEmpty(authResultMsg)) {
                    showRegisterFail();
                } else {
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply), authResultMsg, true);
                }
                break;
        }

    }


    /**
     * 读取本地存储的vhsm的服务端地址并对数据进行处理
     *
     * @return
     */
    //    private String[] getVhsmUrl() {
    //        String ipStr[] = new String[4];
    //        String initIP = SharePreferencesUtil.getVHSMUrl(context);
    //        if (initIP == null || initIP.length() == 0) {
    ////            CommonService.getVhsmServerURL(context);
    ////            initIP = SharePreferencesUtil.getVHSMUrl(context);
    //            if (initIP == null || initIP.length() == 0) {
    //                marginView.setVisibility(View.GONE);
    //                showErrorResponseLayout(getResources().getString(R.string.cert_creation_vhsm_url_fail));
    //                return null;
    //            }
    //        }
    //        String ipArr[] = initIP.split(",");
    //
    //        if (ipArr.length > 0) {
    //            for (int i = 0; i < ipArr.length; i++) {
    //                ipStr = ipArr[i].split(":");
    //            }
    //        }
    //        return ipStr;
    //    }
    private void revokeOwnOldCert() {
        RevokeOwnOldCertRequest revokeOwnOldCertRequest = new RevokeOwnOldCertRequest();
        revokeOwnOldCertRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBean.getType()));
        certService.revokeOwnOldCert(revokeOwnOldCertRequest, deviceID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {

            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                if (commonResponse.getResult().equals("1")) {//撤销非当前设备的证书成功
                    //后台已经进行实体认证，可直接进行对实体认证结果进行处理，commonResponse包含dn信息
                    handleAuthResult(commonResponse);
                } else if (commonResponse.getResult().equals("0")) {//实体认证等待审核
                    showWaiteVerity();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    /**
     * 获取p10，然后申请证书
     */
    private void getP10ReqestBCAndApplyCert(final String dn) {
        Log.e("jff", "1812 CertItemView getP10ReqestBCAndApplyCert : ");
        final String p10ReqestBC = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, dn, true);

        if (TextUtils.isEmpty(p10ReqestBC)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                            , context.getString(R.string.cert_creation_device_not_exist), true);
                }
            }, 10);
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return;
        }

        //切换到主线程，申请证书
        myHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                Log.e("jff", "1831 CertItemView run : ");
                applyCertRequest(p10ReqestBC);
            }
        }, 10);

    }


    public void onDestory() {
        BusProvider.unRegister(this);
    }

    public int getContainerNum() {
        return containerNum;
    }

    public String getCertType() {
        return certType;
    }

    public boolean getAllowApplyCert() {
        return allowApplyCert;
    }


}
