package ocr.activity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.IOException;

import ocr.bean.IDCardInfo;
import ocr.view.CanvasView;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;


/**
 * 身份证界面展示Activity
 * 至于每种方式的不同可以继承此界面并重写
 * Created by yangpeng on 2018/3/22.
 */
@Route(name = ActivityPath.NAME_XDJA_ID_RESULT, path = ActivityPath.ACTIVITY_XDJA_ID_RESULT)
public abstract class IDCardActivity extends BaseActivity {

    @Autowired(name = "identify_info")
    public IDCardInfo info;
    /**
     * 活体识别人脸的照片
     */
    @Autowired(name = "faceImg")
    public String faceImg;

    @Autowired(name = CONTAINER_NUM)
    public int containerNum;

    @Override
    protected int getToolbarType() {
        return super.getToolbarType();
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_result);
        initView();
        getData();
        initIDFace();
        setData();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        info = getIntent().getParcelableExtra(IDENTIFY_INFO);
        faceImg = getIntent().getStringExtra(FACE_IMG);
        containerNum = getIntent().getIntExtra(CONTAINER_NUM, containerNum);

    }

    @Override
    protected int setLoadingText() {
        return R.string.cert_creation_face_comparing;
    }

    private static final String IDENTIFY_INFO = "identify_info"; //传过来身份信息key

    public Bitmap faceBitmap;

    private ImageView id_front;
    private ImageView id_back;


    /**
     * 初始化身份证照片
     */
    public void initIDFace() {

    }

    public void getData() {
        Bundle others = getIntent().getExtras();

        //底下几行代码测试使用，请勿删 gyx
//        String frontPath = "/storage/emulated/0/best.jpg";
//        byte[] imgData = ImgUtil.bitmapToByte(ImgUtil.getBitmapByPath(frontPath), Bitmap.CompressFormat.JPEG,  Contants.JPG_QUALITY);
//        faceImg =  Base64Util.encode(imgData);

        if (others != null && others.containsKey(IDENTIFY_INFO)) {
            info = others.getParcelable(IDENTIFY_INFO);
        }

        if (others != null && others.containsKey(FACE_IMG)) {
            faceImg = others.getString(FACE_IMG);
        }

        if (others != null) {
            containerNum = others.getInt(ActivityParam.CONTAINER_NUM);
        }


    }

    protected void setData() {
        if (info != null) {
            showIdentifyInfo(info);
        }
    }


    /**
     * 身份证信息不对
     * 重新扫描
     */
    public void rescan() {

    }

    /**
     * 下一步，实体认证
     */
    public void next() {

        if (info != null) {
            request();
        }

    }

    private void initView() {
        id_front = (ImageView) findViewById(R.id.id_front);
        id_back = (ImageView) findViewById(R.id.id_back);
        Button btn_next = (Button) findViewById(R.id.btn_next);
        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                next();
            }
        });

        Button btn_again = (Button) findViewById(R.id.btn_again);
        btn_again.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                rescan();
            }
        });

        id_front.setImageBitmap(BitmapFactory.decodeResource(getResources(), R.drawable.id_z));
        id_back.setImageBitmap(BitmapFactory.decodeResource(getResources(), R.drawable.id_f));
    }


    private void showIdentifyInfo(IDCardInfo info) {
        setData(info);
    }

    private void setData(IDCardInfo cardInfo) {
        if (cardInfo.getName() == null) {
            return;
        }
        String gender = "男";
        if (cardInfo.getSex() == 2) {
            gender = "女";
        }

        String[] info = {cardInfo.getName(),
                gender,
                cardInfo.getNation(),
                cardInfo.getBirthDate(),
                cardInfo.getAddr(),
                cardInfo.getIdNum()};

//        ModuleLog.d(info);
//        if (faceBitmap != null) {
        id_front.setImageBitmap(CanvasView.getPictureBitmap(info, 2, faceBitmap, getApplicationContext()));
//        }
        String[] info2 = {cardInfo.getIssueOffice(), cardInfo.getValidDate()};
//        ModuleLog.d(info2);
        id_back.setImageBitmap(CanvasView.getPictureBitmap(info2, 1, null, getApplicationContext()));
    }

    /**
     * 开始上传数据进行比对
     */
    private void request() {

        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }

        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = buildRequest();
        if (request == null) {
            ModuleToast.show(context, R.string.cert_creation_get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(getResources().getString(R.string.cert_creation_get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(info.getIdNum());
            verifyFailResultActivity(currentChipBeanType, compareResult);
            finish();
            OttoUtil.postFinishActivity();
            return;
        }

        showLoading();

        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
                compareResult.setResult("");
                compareResult.setMessage(context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(info.getIdNum());
//                AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
//                OttoUtil.postAuthResult(auth);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(info.getIdNum());
                verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
//                ModuleLog.e("认证返回结果code= " + commonResponse.getResult());

                SharePreferencesUtil.saveIDCardNo(context, devType, info.getIdNum());

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(info.getIdNum());
                compareResult.setSuccess(true);

                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有
                    verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }
                OttoUtil.postFinishActivity();
                OttoUtil.postFinishYishuNFC();
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                ModuleLog.e("认证失败");
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(info.getIdNum());
                compareResult.setSuccess(false);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra("result", result);
            intent.putExtra("devType", type);
            intent.putExtra("identify_info", info);
            intent.putExtra("faceImg", faceImg);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(ActivityPath.ACTIVITY_AUTH_FAIL)
                    .withSerializable("result", result)
                    .withSerializable("devType", type)
                    .withParcelable("identify_info", info)
                    .withString("faceImg", faceImg)
                    .withInt(CONTAINER_NUM, containerNum)
                    .navigation(this);
        }


    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
        //        ModuleLog.e("实体验证  卡类型 " + Util.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));


        String imsi = deviceWrapper.getIMSI();
        //        ModuleLog.e("imsi = " + imsi);
        //        if (TextUtils.isEmpty(imsi)) {
        ////            ModuleToast.show(this, "获取imsi失败，请确认SIM卡插入正常");
        ////            ModuleLog.e("请确认SIM卡插入正常");
        //
        //            return null;
        //        }
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this));

        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM)
                ) {
            chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
            chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId(context));
        }else{
            chipInfo.setImei(deviceWrapper.getIMEI());
        }


        request.setIdCardInfo(info);


        request.setChipInfo(chipInfo);
        request.setFaceImg(faceImg);

        final int type = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);

        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));
        //        Log.e("jff","实体认证： " + request.toString());

        ModuleLog.e(request.toString());

        return request;

    }

}
