package ocr.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;

import ocr.command.NetErrorCommand;

/**
 * Created by gyx on 2018/6/22.
 */

public class AbnormalPromptFragment extends Fragment {


    private Button retry;
    private TextView abnormal_prompt;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.abnormal_prompt, container, false);
        retry = (Button) view.findViewById(R.id.retry);
        abnormal_prompt = (TextView) view.findViewById(R.id.abnormal_prompt);
        return view;
    }


    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (getActivity() instanceof NetErrorCommand) {
            retry.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    ((NetErrorCommand) getActivity()).retry();
                }
            });

            abnormal_prompt.setText(((NetErrorCommand) getActivity()).getErrorMsg());
        }

    }


}
