package com.xdja.safeclient.certcreation.activity;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;

import java.util.ArrayList;

/**
 * Created by zjc on 2019/5/21 0021.
 */
@Route(path = ActivityPath.ACTIVITY_CONFIG_STEP2, name = ActivityPath.NAME_CONFIG_STEP2)
public class ConfigStep2Activity extends BaseActivity implements View.OnClickListener {

    View layoutStandard;

    RadioButton standard;

    View layoutStdNoOCR;

    RadioButton stdNoOCR;

    View layoutStdNoNFC;

    RadioButton stdNoNFC;

    View layoutSimplified;

    RadioButton simplified;

    View layoutPhone;

    RadioButton phone;

    Button next;

    @Autowired
    public String projectName;

    @Autowired
    public String serverIP;

    @Autowired
    public String serverPort;

    @Autowired()
    public ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

    @Autowired
    public ArrayList<ServerAddress> vhsmAddressList = new ArrayList<>();


    @Autowired
    public boolean enableVHSM;

    @Override
    protected void getIntentData() {
        super.getIntentData();

        projectName = getIntent().getStringExtra("projectName");

        serverAddressesList = getIntent().getParcelableArrayListExtra("serverAddressesList");

        vhsmAddressList = getIntent().getParcelableArrayListExtra("vhsmAddressList");


        enableVHSM = getIntent().getBooleanExtra("enableVHSM", false);

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_config_step2);

        // ARouter.getInstance().inject(this);

        initView();

        initViewByData();
    }

    private void initView() {

        layoutStandard = findViewById(R.id.layout_standard);
        layoutStandard.setOnClickListener(this);

        standard = findViewById(R.id.standard);
        standard.setClickable(false);

        layoutStdNoOCR = findViewById(R.id.layout_std_no_ocr);
        layoutStdNoOCR.setOnClickListener(this);

        stdNoOCR = findViewById(R.id.std_no_ocr);
        stdNoOCR.setClickable(false);

        layoutStdNoNFC = findViewById(R.id.layout_std_no_nfc);
        layoutStdNoNFC.setOnClickListener(this);

        stdNoNFC = findViewById(R.id.std_no_nfc);
        stdNoNFC.setClickable(false);

        layoutSimplified = findViewById(R.id.layout_simplified);
        layoutSimplified.setOnClickListener(this);

        simplified = findViewById(R.id.simplified);
        simplified.setClickable(false);

        layoutPhone = findViewById(R.id.layout_phone);
        layoutPhone.setOnClickListener(this);

        phone = findViewById(R.id.phone);
        phone.setClickable(false);

        next = findViewById(R.id.next);
        next.setOnClickListener(this);

        next.setClickable(false);

    }

    private void initViewByData() {

        ServerSettingConfig serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        if (serverSettingConfig == null) {
            next.setBackgroundResource(R.drawable.green_disable);
            return;
        }

        String procedure = serverSettingConfig.getProcedure();

        if (!TextUtils.isEmpty(procedure)) {

            if (procedure.equals(Procedure.STANDARD)) {
                standard.setChecked(true);
                next.setClickable(true);
            } else if (procedure.equals(Procedure.SIMPLIFIED)) {
                simplified.setChecked(true);
                next.setClickable(true);
            } else if (procedure.equals(Procedure.STD_NO_NFC)) {
                stdNoNFC.setChecked(true);
                next.setClickable(true);
            } else if (procedure.equals(Procedure.STD_NO_OCR)) {
                stdNoOCR.setChecked(true);
                next.setClickable(true);
            } else if (procedure.equals(Procedure.PHONE)) {
                phone.setChecked(true);
                next.setClickable(true);
            }

            next.setBackgroundResource(R.drawable.green);

        } else {
            next.setBackgroundResource(R.drawable.green_disable);
        }


    }

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id != R.id.next) {
            next.setBackgroundResource(R.drawable.green);
        }

        if (id == R.id.layout_standard) {

            standard.setChecked(true);

            stdNoOCR.setChecked(false);
            stdNoNFC.setChecked(false);
            simplified.setChecked(false);
            phone.setChecked(false);

            next.setClickable(true);
        } else if (id == R.id.layout_simplified) {
            standard.setChecked(false);
            stdNoOCR.setChecked(false);
            stdNoNFC.setChecked(false);

            simplified.setChecked(true);

            phone.setChecked(false);

            next.setClickable(true);
        } else if (id == R.id.layout_std_no_ocr) {
            standard.setChecked(false);

            stdNoOCR.setChecked(true);

            stdNoNFC.setChecked(false);
            simplified.setChecked(false);
            phone.setChecked(false);

            next.setClickable(true);
        } else if (id == R.id.layout_std_no_nfc) {
            standard.setChecked(false);
            stdNoOCR.setChecked(false);

            stdNoNFC.setChecked(true);

            simplified.setChecked(false);
            phone.setChecked(false);

            next.setClickable(true);
        } else if (id == R.id.layout_phone) {
            standard.setChecked(false);
            stdNoOCR.setChecked(false);
            stdNoNFC.setChecked(false);
            simplified.setChecked(false);

            phone.setChecked(true);

            next.setClickable(true);
        } else if (id == R.id.next) {
            next();
        }
    }

    @Override
    public boolean valid() {
        return standard.isChecked() || stdNoOCR.isChecked() || stdNoNFC.isChecked() || phone.isChecked() || simplified.isChecked();
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CONFIG_STEP3;
    }

    @Override
    public void route() {
        super.route();

        if (BuildConfig.isAAR || DEBUG_AAR) {

            Intent intent = new Intent(context, ConfigStep3Activity.class);

            intent.putExtra("projectName", projectName);
            intent.putExtra("serverAddressesList", serverAddressesList);
            intent.putExtra("vhsmAddressList", vhsmAddressList);
            intent.putExtra(ConfigParam.PROCEDURE, getProcedure());
            intent.putExtra("enableVHSM", enableVHSM);

            startActivity(intent);

        } else {

            ARouter.getInstance()
                    .build(nextActivity())
                    .withString("projectName", projectName)
                    .withParcelableArrayList("serverAddressesList", serverAddressesList)
                    .withParcelableArrayList("vhsmAddressList", vhsmAddressList)
                    .withString(ConfigParam.PROCEDURE, getProcedure())
                    .withBoolean("enableVHSM", enableVHSM)
                    .navigation(context);
        }

    }

    private String getProcedure() {

        if (standard.isChecked()) {
            return Procedure.STANDARD;
        } else if (simplified.isChecked()) {
            return Procedure.SIMPLIFIED;
        } else if (stdNoOCR.isChecked()) {
            return Procedure.STD_NO_OCR;
        } else if (phone.isChecked()) {
            return Procedure.PHONE;
        } else if (stdNoNFC.isChecked()) {
            return Procedure.STD_NO_NFC;
        } else {
//            不会走到这
            return "";
        }

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

}
