package com.xdja.safeclient.certcreation.activity;


import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.listener.IInitCallback;
import com.baidu.idl.face.platform.ui.utils.FaceInfoCache;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.bean.result.VerifyPhoneResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.config.FaceLicenseConfig;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.receiver.BaiduFaceEvent;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ocr.activity.CameraReadyActivity;
import ocr.activity.ChooseBindWayActivity;
import ocr.activity.LiveStartActivity;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_TYPE;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.PHOTO_TYPE;
import static com.xdja.safeclient.certcreation.activity.SelfieActivity.TYPE_SELFIE;

//import com.baidu.idl.face.example.MainActivity;

@Route(path = ActivityPath.ACTIVITY_PHONE_INFO, name = ActivityPath.NAME_PHONE_INFO)
public class PhoneInputActivity extends BaseActivity implements View.OnClickListener {

    private RadioGroup gender;

    private EditText etName;

    private EditText etId;

    private EditText etPhone;

    private EditText etSMSCode;

    private Button btn_submit;

    //简易流程需要显示的信息
    private LinearLayout standard;

    //标题，简易流程是“填写基本信息” 标准流程是“填写手机号码”
    private TextView title;

    private PinDialog pinDialog;

    @Autowired(name = CARD_TYPE)
    public CryptoDevType cardType;

    @Autowired(name = CONTAINER_NUM)
    public int containerNum;

    @Autowired(name = CARD_NUM)
    public String cardNum;

    // 这个字段不知道有没有用，想写在这儿
    @Autowired(name = ActivityParam.CERT_TYPE)
    public String certType;

    private static final String REGEX_NUMBER_IDCARD_FIRST = "[^0-9]";
    private static final String REGEX_NUMBER_IDCARD_SECOND = "[^[0-9Xx]$]";

    private String beforeStr;

    private String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.cert_creation_phone_input);

        // ARouter.getInstance().inject(this);

        getIntentData();

        initView();
        setHint();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        cardType = (CryptoDevType) getIntent().getSerializableExtra("cardType");
        cardNum = getIntent().getStringExtra("cardNum");
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
        initBaiduLive();
    }

    /**
     * 百度初始化有延迟，提起优先初始化百度
     */
    private void initBaiduLive() {
        String liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();
        if (liveCompany.equals(LiveCompany.BAIDU)) {
            FaceSDKManager.getInstance().initialize(this, FaceLicenseConfig.getLicenseKeyId(BuildConfig.isAAR),
                    "idl-license.face-android", new IInitCallback() {
                        @Override
                        public void initSuccess() {
                        }

                        @Override
                        public void initFailure(final int errCode, final String errMsg) {
                        }
                    });
        }
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CAMERA_READY;
    }


    /**
     * 根据配置设置是否显示验证码
     */
    private void setHint() {
        // 别的地方都是注册用的手机
        etPhone.setHint(R.string.cert_creation_valid_phone_hint_others);

        if ((!procedure.equals(Procedure.PHONE)) && !(procedure.equals(Procedure.SIMPLIFIED))) {
            etPhone.addTextChangedListener(textWatcher);
            btn_submit.setEnabled(false);
        }
    }


    @Override
    protected void onResume() {
        super.onResume();

        if (isNext) {  //如果跳转到别的页面然后返回，则清空电话号码
            if ((!procedure.equals(Procedure.PHONE)) && !(procedure.equals(Procedure.SIMPLIFIED))) {
                btn_submit.setEnabled(false);
            }


            if (!procedure.equals(Procedure.SIMPLIFIED)) {
                etPhone.setText("");
            }
            isNext = false;
        }
        ImageCache.getInstance().clear();
    }

    private TextWatcher textWatcher = new TextWatcher() {

        private CharSequence temp;

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            temp = charSequence;
        }

        @Override
        public void afterTextChanged(Editable editable) {

            if (temp.length() < 6 || temp.length() > 12) {
                btn_submit.setEnabled(false);
            } else {
                btn_submit.setEnabled(true);
            }

        }
    };

    private void initView() {


        if (cardType == CryptoDevType.DEV_TYPE_Soft && !NetVHSMHandle.isNetVHSMCanUse()) {
            //软卡证书未初始化不进行pin码校验

        } else {
            int pinResult = DeviceWrapper.getInstance().verifyPin(cardType, containerNum, AppConfig.getInstance().getDefaultConfig().getPin());

            if (pinResult != 0) {
                pinDialog = new PinDialog(context, cardType);
                pinDialog.show();
            }
        }

        title = (TextView) findViewById(R.id.info_title);

        etPhone = (EditText) findViewById(R.id.et_phone);
        etPhone.setFilters(EditTextUtil.getDisableEmojFilter(12));

        etSMSCode = (EditText) findViewById(R.id.et_sms_code);
        etSMSCode.setFilters(EditTextUtil.getDisableEmojFilter());

        btn_submit = (Button) findViewById(R.id.btn_submit);
        btn_submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                submit();
            }
        });

        if (procedure.equals(Procedure.PHONE)) {
            btn_submit.setText(R.string.cert_creation_submit);
        }
        initInfoView();

    }


    private void initInfoView() {

        if (!procedure.equals(Procedure.SIMPLIFIED)) {
            title.setText(R.string.cert_creation_apply_cert);
            return;
        }

        standard = (LinearLayout) findViewById(R.id.standard);

        // 简易流程和手机号流程只显示手机号
        if (procedure.equals(Procedure.SIMPLIFIED)
        ) {
            standard.setVisibility(View.VISIBLE);
        } else {
            standard.setVisibility(View.GONE);
        }

        etName = (EditText) findViewById(R.id.et_name);
        etName.setFilters(EditTextUtil.getHanziFilter(14));

        gender = (RadioGroup) findViewById(R.id.gender);

        etId = (EditText) findViewById(R.id.et_id);
        etId.setFilters(EditTextUtil.getDisableEmojFilter());
        etId.setFilters(new InputFilter[]{new InputFilter.LengthFilter(18)});

        etId.setRawInputType(Configuration.KEYBOARD_QWERTY);  //首先展示数字键盘。该属性只改变输入键盘的显示（数字、文本等），不改变输入类型的限制。gyx
        etId.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                beforeStr = s.toString();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String editable = etId.getText().toString();
                Pattern p;
                if (beforeStr.length() <= 16) {
                    p = Pattern.compile(REGEX_NUMBER_IDCARD_FIRST);
                } else {
                    p = Pattern.compile(REGEX_NUMBER_IDCARD_SECOND);
                }
                Matcher m = p.matcher(editable);
                String str = m.replaceAll("").trim();    //删掉不是字母或数字的字符
                if (!editable.equals(str)) {
                    etId.setText(str);  //设置EditText的字符
                    etId.setSelection(str.length()); //因为删除了字符，要重写设置新的光标所在位置
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
            }
        });


    }


    @Override
    protected int getTitleRes() {
        return -1;
    }

    /**
     * 点击下一步
     */
    public void submit() {

        KeyboardUtils.hideKeyboard(etPhone);

        ModuleLog.e("PhoneInputActivity submit");

        next();

    }

    private boolean isNext = false;  //是否跳转到下个界面

    @Override
    public void next() {
        super.next();
        ModuleLog.e("PhoneInput next");
        KeyboardUtils.hideKeyboard(etPhone);
    }

    @Override
    public void route() {
        super.route();

        KeyboardUtils.hideKeyboard(etPhone);

        switch (procedure) {

            case Procedure.STANDARD:
                startStandard();
                break;

            case Procedure.SIMPLIFIED:
                startSimplified();
                break;

            case Procedure.PHONE:
                request();
                break;

            case Procedure.STD_NO_OCR:
                startStandard();
                break;

            case Procedure.STD_NO_NFC:
                startStandard();
                break;

            default:

                break;
        }

        isNext = true;

    }

    private void startStandard() {

        String liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();

        switch (liveCompany) {

            case LiveCompany.YUNCONG:
                startLivePrepareActivity();
                break;

            case LiveCompany.BAIDU:
                startLivePrepareActivity();
                break;

            case LiveCompany.KUANGSHI:

                break;

            default:

                break;
        }

    }

    private void startSimplified() {
        startSelfieActivity();
    }


    /**
     * 跳转到拍照页面
     */
    private void startSelfieActivity() {

        //todo 手机号已经存过了

        //卡号
        SharePreferencesUtil.saveDevCardID(this, cardNum);

        //卡类型
        SharePreferencesUtil.saveCurrentDevType(this, cardType.getType());

        SharePreferencesUtil.saveSelfieStep(context, TYPE_SELFIE);

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, CameraReadyActivity.class);
            intent.putExtra(PHOTO_TYPE, TYPE_SELFIE);
            intent.putExtra(CARD_NUM, cardNum);
            intent.putExtra(CARD_TYPE, cardType);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(nextActivity())
                    .withInt(PHOTO_TYPE, TYPE_SELFIE)
                    .withString(CARD_NUM, cardNum)
                    .withSerializable(CARD_TYPE, cardType)
                    .withInt(CONTAINER_NUM, containerNum)
                    .navigation(this);
        }

        overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }


    /**
     * 跳转到活体检测准备界面
     */
    private void startLivePrepareActivity() {

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, LiveStartActivity.class);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(ActivityPath.ACTIVITY_YUNCONG_LIVE_START)
                    .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                    .navigation(context);
        }
        overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.request_sms_code) {
            request();
        }
    }


    /**
     * 获取验证码
     */
    private void request() {
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            final String phone = etPhone.getText().toString();
            if (TextUtils.isEmpty(phone)) {
                ModuleToast.showNoRepeat(context, R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }
            verifyPhoneNum(phone);
        }
    }

    /**
     * 验证手机号是否合法
     */
    private void verifyPhoneNum(final String phone) {

        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);

        service.verifyPhoneNum(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //                ModuleLog.e("手机号验证异常");
                showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String resultCode = commonResponse.getResult();
                if (resultCode.equals(VerifyPhoneResult.RESULT_OK)) {
                    //直接进行实体认证
                    startVerify();
                } else {

                    PhoneResult phoneResult
                            = buildPhoneResult(getCardType(), getCardNum(), commonResponse, null);

                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(containerNum);
                    authResult.setPhoneResult(phoneResult);

                    OttoUtil.postPhoneAuthResult(authResult);
                    finish();
                    //                    ModuleToast.show(context, "success " + getString(new VerifyPhoneResult().getErrText(resultCode)));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //                ModuleLog.d("手机号验证失败：" + baseErrorResponse.toString());
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {

        CompareResult result = new CompareResult();

        // TODO: 2018/11/8 0008 三种情况的处理需要重写

        //IO异常的处理
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            //错误的处理
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty(errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            //正确的处理
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            //注意，成功的时候是没有errCode的
            result.setSuccess(true);
        }

        result.setIdentity(cardNum);


        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }


    /**
     * 进行实体认证
     */
    private void startVerify() {
        CryptoDevType cryptoDevType = IntentUtil.getCardType(PhoneInputActivity.this.getIntent());

        if (cryptoDevType == null || TextUtils.isEmpty(cardNum)) {
            return;
        }

        String phoneNum = etPhone.getText().toString();
        SharePreferencesUtil.savePhone(context, phoneNum);

        //        VerifyInfoSelfieRequest request = ApplyCertUtil.buildRequest("", "", phoneNum, 1, getCardType(), containerNum);

        ModuleLog.e("PhoneInput 531");
        ApplyCertUtil.start(this, containerNum, new ApplyCertUtil.WhatHappen() {
            @Override
            public void showDialog() {
                showLoading();
            }

            @Override
            public void cancelDialog() {
                dismissLoading();
            }

            @Override
            public void IOError() {
                dismissLoading();
                showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                ApplyCertUtil.handleSuccessResult(PhoneInputActivity.this, response);
                finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                PhoneInputActivity.this.handleError(baseErrorResponse);
                //                ModuleToast.show(context, OkNetError.userError(context, baseErrorResponse.getErrCode()));
            }
        });

    }


    private void handleError(BaseErrorResponse baseErrorResponse) {

        //        // TODO: 2018/6/25 0025  身份证号在警员库中不存在时会跳转注册
        //        // todo 但是此注册流程是广州的特殊需求，并非每个地方都有
        //        // TODO: 2018/6/25 0025 因此广州版本不再进行显示，之后考虑做成可配置项
        //        if (baseErrorResponse.getMessage().equals(OkNetError.IDENTIFY_NOT_POLICE) && CertCommonModule.getInstance().getProject() == ProjectName.GUANGDONG) {
        //
        //            gotoProfessionActivity();
        //
        //        } else {
        //            ApplyCertUtil.handleErrorMessage(context);
        DeviceWrapper.getInstance().setApplyCertEnd(false);
        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(getCardType(), containerNum, getCardNum(), null, baseErrorResponse));
        OttoUtil.postFinishActivity();
        finish();
        //        }

    }

    @Override
    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    public boolean valid() {

        // 持证流程是需要校验填写的信息的
        if (procedure.equals(Procedure.SIMPLIFIED)) {

            // 错误定义参考BUG【50195】

            if (!ValidUtil.name(etName.getText().toString())) {
                ModuleToast.show(context, R.string.cert_creation_invalid_name_length);
                KeyboardUtils.hideKeyboard(PhoneInputActivity.this);
                return false;
            } else if (!ValidUtil.idNum(etId.getText().toString())) {
                ModuleToast.show(context, R.string.cert_creation_error_id_size);
                KeyboardUtils.hideKeyboard(PhoneInputActivity.this);
                return false;
            } else if (!ValidUtil.phone(etPhone.getText().toString())) {
                //            因为现在手机号有TextChangeListener的校验，所以不用Toast提示
                ModuleToast.show(context, R.string.cert_creation_err_length);
                KeyboardUtils.hideKeyboard(PhoneInputActivity.this);
                return false;
            } else {
                return true;
            }
        } else {
            //            其它流程不需要校验
            return true;
        }


    }

    @Override
    public void saveValue() {

        if (procedure.equals(Procedure.SIMPLIFIED)) {
            SharePreferencesUtil.saveIDCardNo(this, cardType.getType(), etId.getText().toString().toUpperCase());
            SharePreferencesUtil.saveSex(this, cardType.getType(), gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
            SharePreferencesUtil.saveName(this, etName.getText().toString());
        }

        SharePreferencesUtil.savePhone(context, etPhone.getText().toString());

    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    @Subscribe
    public void handleFaceEvent(BaiduFaceEvent event) {
        if (event.isSuccess()) {
            String faceInfo = FaceInfoCache.getInStance().getFaceInfoStr();
            ImageCache.getInstance().setSelfie(Selfie.BAIDU, faceInfo, false);
            FaceInfoCache.getInStance().clearFaceInfo();
            Intent intent = new Intent(this, ChooseBindWayActivity.class);
            intent.putExtra(FACE_IMG, event.getPhoto());
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            startActivity(intent);

        }
    }


}
