package com.xdja.safeclient.certcreation.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.util.Base64;

import com.aircert.util.ModuleLog;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callback.FileWithBitmapCallback;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;

import cn.cloudwalk.libproject.util.Util;

/**
 * Created by zjc on 2018/11/14 0014.
 */

public class ImageCache {

    public static final int PHOTO_REQUEST_TAKEPHOTO = 1;// 拍照

    private static String path;

    /**
     * 自拍照存储的本地地址
     */
    public static Uri PATH_SELFIE = null;

    /**
     * 身份证拍摄照的本地地址
     */
    public static Uri PATH_ID_IMG = null;


    private String idType;

    private String id;

    private String selfie;

    private String selfieType;

    public String getSelfie() {
        return selfie;
    }

    public static Uri getSelfieURI() {
        return PATH_SELFIE;
    }

    public static Uri getIDImageURI() {
        return PATH_ID_IMG;
    }

    public static void init(Context context) {

        // Android7.0以上
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {

            File selfie = new File(context.getExternalCacheDir(), "img.jpg");

            String authority = !BuildConfig.isAAR ? "com.xdja.aircert.standalone.fileprovider" : "com.xdja.aircert.fileprovider";

            PATH_SELFIE = FileProvider.getUriForFile(context, authority, selfie);

            File id = new File(context.getExternalCacheDir(), "id.jpg");
            PATH_ID_IMG = FileProvider.getUriForFile(context, authority, id);

        } else {

            boolean success;

            // https://bbs.csdn.net/topics/392167982
            // 别的路径可能导致ACE手机上拍照之后，点击对勾无法返回到展示照片的界面
            path = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM).getAbsolutePath() + File.separator;


            File file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    success = file.mkdir();
                    if (success) {
                        ModuleLog.e("selfie path has been created successfully");
                    } else {
                        ModuleLog.e("selfie path has not been created");
                    }
                }
            }

            PATH_SELFIE = Uri.fromFile(new File(path, "img.jpg"));

            PATH_ID_IMG = Uri.fromFile(new File(path, "id.img"));

        }

    }

    /**
     * 压缩自拍照
     */
    public static void compressSelfie(int type, Bitmap bitmap) {
        compressFile(type, bitmap);

    }

    /**
     * 压缩拍摄的身份证照片
     */
    public static void compressIDImage(int type, Bitmap bitmap) {
        compressFile(type, bitmap);
//        ImageCache.getInstance().setId(Selfie.CAMERA, URLEncoder.encode(Base64Util.fromFile(context, ImageCache.PATH_ID_IMG)));
    }

    /**
     * 压缩图片
     * 关于Tiny用法
     * https://www.cnblogs.com/lucktian/p/7009411.html
     *
     * @param uri
     */
    private static void compressFile(final int type, final Bitmap originBitmap) {

        ModuleLog.e("压缩前大小" + originBitmap.getByteCount());

        Tiny.FileCompressOptions options = new Tiny.FileCompressOptions();
        options.isKeepSampling = false;
        // 压缩后的尺寸，该尺寸下，Mate10拍照前置和后置大小均为500k左右
        options.width = 480;
        options.height = 720;

//        options.outfile = uri.getPath();

        Tiny.getInstance().source(originBitmap).asFile().withOptions(options).compress(new FileWithBitmapCallback() {

            @Override
            public void callback(boolean b, Bitmap bitmap, String s) {
                ModuleLog.e("压缩后大小" + bitmap.getByteCount());

                // 压缩后的bitmap转byte数组

                byte[] bitmapBytes = getBytesByBitmap(bitmap);

                // byte数组转base64字符串
                String base64 = Base64.encodeToString(bitmapBytes, 0);

                // base64进行UrlEncode处理
                String encodeBase64 = URLEncoder.encode(base64);

                // TODO: 2019/3/5 0005 重构把这个if-else从改方法移出去
                if (type == SelfieActivity.TYPE_SELFIE) {
                    // setSelfie方法中对根据参数决定是否进行base64处理，所以我们此处用处理前的字符串
                    ImageCache.getInstance().setSelfie(Selfie.CAMERA, base64, true);
                } else {
                    ImageCache.getInstance().setId(Selfie.CAMERA, encodeBase64);
                }

            }
        });
    }


    /**
     * 压缩图片
     * @param file
     * @return bitmap
     * @auth jff
     */
    public static Bitmap compressFile(File file) {

        try{
            FileInputStream inputStream = new FileInputStream(file);

            //对 要加载的图片进行缩放
            //1.得到图片的宽度和高度.
            //由于我们只想得到图片的宽度和高度,这个时候 只需要解析图片的头信息
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;//让 bitmapfactory假的解析这个位图,只获取位图的边框信息
            BitmapFactory.decodeStream(inputStream, null, opts);

            int bitmapHeight = opts.outHeight;
            int bitmapWidth = opts.outWidth;


            int windowHeight = 480;
            int windowWidth = 720;
            //获取水平和垂直方向的缩放比
            int scaley = bitmapHeight / windowHeight;
            int scalex = bitmapWidth / windowWidth;
            if (scalex > scaley && scaley > 1) {
                opts.inSampleSize = scalex;
            }
            if (scaley > scalex && scalex > 1) {
                opts.inSampleSize = scaley;
            }
            opts.inJustDecodeBounds = false;// 由于已经得到了缩放比例 ,让位图工厂真正的解析这个位图
            Bitmap bitmap = BitmapFactory.decodeStream(new FileInputStream(file),null, opts);
            return bitmap;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }



    public static byte[] getBytesByBitmap(Bitmap bitmap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bitmap.getByteCount());
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, outputStream);
        return outputStream.toByteArray();
    }

    /**
     * 设置人脸照片
     *
     * @param selfieType 人脸照片类型；
     *                   可能是自拍，也可能是人脸识别获取的照片
     *                   {@link com.xdja.safeclient.certcreation.Selfie}
     * @param selfie
     */
    public void setSelfie(String selfieType, String selfie, boolean encode) {
        if (encode) {
            this.selfie = URLEncoder.encode(selfie);
        } else {
            this.selfie = selfie;
        }
        this.selfieType = selfieType;

        // TODO: 2018/11/29 0029 为了复现和追踪图片传到服务器后显示异常的调试代码
//        String value = URLDecoder.decode(this.selfie);
//        Base64Util.CopyBase64ToFile(value, new File(Environment.getExternalStorageDirectory()
//                .getPath() + File.separator + "decode.jpg"));

    }

    public String getId() {
        return id;
    }

    /**
     * 设置身份证头像照片
     *
     * @param idType 身份证识别类型；
     *               现在的身份证头像都是通过NFC扫描的，部分OCR无法获得身份证的头像
     *               所以这个地方填写NFC的类型{@link NFCCompany}
     *               或者OCR类型{@link OCRCompany}
     *               todo OCR和NFC的值上可能会有冲突
     * @param id     照片的Base64字符串
     *               todo URLEncoder.encode建议在网络请求时自行处理
     */
    public void setId(String idType, String id) {
        this.id = id;
        this.idType = idType;
    }

    private ImageCache() {

    }

    private static ImageCache cache;

    public static ImageCache getInstance() {
        if (cache == null) {
            cache = new ImageCache();
        }
        return cache;
    }

    public void clear() {
        cache = null;
    }

    /**
     * 清空身份证的缓存照片
     */
    public void clearID(Context context) {
        //NFC亿数 /storage/emulated/0/yishu/1.jpg
        File yishu = new File(Environment.getExternalStorageDirectory() + File.separator + "yishu");
        deleteDir(yishu);
        //NFC信大捷安 没有缓存

        //OCR云从 身份证正反面缓存
        deleteYuncongCache(context);

        //OCR安荣

        //storage/emulated/0/alpha/SIDCard/xxx.jpg 目录存疑
        File delete = new File(Environment.getExternalStorageDirectory() + File.separator + "alpha" +
                File.separator + "SIDCard"
        );
        deleteDir(delete);

        File ID_IMG = new File(PATH_ID_IMG.getPath());
        ID_IMG.delete();

    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            //递归删除目录中的子目录下
            for (int i = 0; i < children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
        }
        // 目录此时为空，可以删除
        return dir.delete();
    }

    /**
     * 删除云从身份证正反面缓存的图片
     * 此方法由云从提供
     *
     * @param context
     */
    private static void deleteYuncongCache(Context context) {
        try {
            String frontPath = Util.getDiskCacheDir(context) + "/frontphoto.jpg";
            String backPath = Util.getDiskCacheDir(context) + "/backphoto.jpg";
            File frontFile = new File(frontPath);
            File backFile = new File(backPath);
            if (frontFile.exists()) {
                frontFile.delete();
            }

            if (backFile.exists()) {
                backFile.delete();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 将Base64转成图片保存在本地
     *
     * @param base64
     * @param dstFile
     */
    public static void copyBase64ToFile(String base64, File dstFile) {
        OutputStream out = null;
        try {
            out = new FileOutputStream(dstFile);
            out.write(Base64.decode(base64, Base64.DEFAULT));
            out.flush();
        } catch (FileNotFoundException e) {
//            logger.error("图片存储到目的地址不存在");
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }


}
