package ocr.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.*;

/**
 * 拍照准备界面
 * 标题-持证拍照准备
 * Created by Administrator on 2019/3/23 0023.
 */

@Route(name = ActivityPath.NAME_CAMERA_READY, path = ActivityPath.ACTIVITY_CAMERA_READY)
public class CameraReadyActivity extends BaseActivity {

    @Autowired(name = PHOTO_TYPE)
    public int photoType;

    @Autowired(name = CARD_NUM)
    String cardNum;

    @Autowired(name = CARD_TYPE)
    CryptoDevType cardType;

    @Autowired(name = PHONE)
    String phone;

    @Autowired(name = CONTAINER_NUM)
    public int containerNum;

    TextView tv_tips1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_camera_ready);

        hideBG();

        cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(this));
        cardNum = DeviceWrapper.getInstance().getCardID(cardType);

        phone = SharePreferencesUtil.getPhoneNum(this);


        if (TextUtils.isEmpty(cardNum)) {
            ModuleToast.show(context, R.string.cert_creation_card_device_error);
            return;
        }

        Button bt_startdect = (Button) findViewById(R.id.start);

        bt_startdect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                next();
            }
        });

        tv_tips1 = findViewById(R.id.hint1);

        if (ScreenUtil.isFullScreen(this)) {

            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

            layoutParams.setMargins(0, ScreenUtil.dip2px(context, 50), 0, 0);
            layoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
            tv_tips1.setLayoutParams(layoutParams);


        }


    }


    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission(CameraReadyActivity.this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED;
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_SELFIE;
    }

    @Override
    public void route() {
        super.route();

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(context, SelfieActivity.class);
            intent.putExtra(PHOTO_TYPE, photoType);
            intent.putExtra(CARD_NUM, cardNum);
            intent.putExtra(CARD_TYPE, cardType);
            intent.putExtra(ActivityParam.PHONE, phone);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            startActivity(intent);

        } else {

            ARouter.getInstance()
                    .build(nextActivity())
                    .withInt(PHOTO_TYPE, photoType)
                    .withString(CARD_NUM, cardNum)
                    .withSerializable(CARD_TYPE, cardType)
                    .withString(ActivityParam.PHONE, phone)
                    .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                    .navigation(this);
        }


    }

    @XdjaPermission(permissions = {
            Manifest.permission.CAMERA,
    })
    private void requestCamera() {

    }

    @Override
    protected void onResume() {
        super.onResume();
        left_title_tv.setText(R.string.cert_creation_selfie_photo_ready_title);
    }

    @Override
    protected void onPause() {
        super.onPause();
        left_title_tv.setText("");
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (permissions[0].equals(Manifest.permission.CAMERA) && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            next();
        }

    }

    @Override
    protected int getTitleRes() {

        return R.string.cert_creation_selfie_photo_ready_title;

    }

    @Subscribe

    public void handleFinishActivity(FinishActivity activity) {
        finish();
    }

}
