package ocr.fragment;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;

import ocr.command.NFCCommand;
import ocr.view.MyClickText;

/**
 * Created by gyx on 2018/6/22.
 */

public class NFCLoadingFragment extends Fragment {


    public static final int STATE_NORMAL = 0;  //nfc正常使用
    public static final int STATE_UNOPEN = -1;  //nfc未开启
    public static final int STATE_UNSUPPORT = -2; //不支持nfc


    private TextView nfc_upen;

    private MyClickText clickText;

    private ImageView phoneImg;

    private ImageView cardImg;


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.nfc_loading, container, false);
        initView(view);
        initAction();
        return view;
    }


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        registerNFCReceiver();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (getActivity() != null && getActivity() instanceof NFCCommand) {
            int state = ((NFCCommand) getActivity()).getNFCState();
            if (state == STATE_NORMAL) {
                showLoading();
            } else if (state == STATE_UNOPEN) {
                showUnopen();
            } else {
                showUnsopport();
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        unregisterNFCReceiver();
    }


    private void initView(View view) {
        phoneImg = (ImageView) view.findViewById(R.id.ivPhone);
        cardImg = (ImageView) view.findViewById(R.id.ivIdCard);
        clickText = new MyClickText(getActivity(), R.color.green_29CFAB) {
            @Override
            public void updateDrawState(TextPaint ds) {
                super.updateDrawState(ds);
                //设置文本的颜色
                ds.setColor(getActivity().getResources().getColor(R.color.green_29CFAB));
                //超链接形式的下划线，false 表示不显示下划线，true表示显示下划线
                ds.setUnderlineText(false);
            }

            @Override
            public void doClick() {
                if (getActivity() instanceof NFCCommand) {
                    ((NFCCommand) getActivity()).openNFC();
                }
            }
        };
        nfc_upen = (TextView) view.findViewById(R.id.nfc_upen);
    }


    private void initAction() {
        Animator animator1 = AnimatorInflater.loadAnimator(getActivity(), R.animator.phone);
        animator1.setTarget(phoneImg);
        animator1.start();
        Animator animator2   = AnimatorInflater.loadAnimator(getActivity(), R.animator.idcard);
        animator2.setTarget(cardImg);
        animator2.start();
    }


    private void showUnsopport() {
        nfc_upen.setVisibility(View.VISIBLE);
        nfc_upen.setText(R.string.cert_creation_nfc_unsupport);
    }


    private void showUnopen() {
        nfc_upen.setVisibility(View.VISIBLE);
        SpannableString str = new SpannableString(getActivity().getResources().getString(R.string.cert_creation_nfc_to_setting));
        str.setSpan(clickText, str.length() - 5, str.length() - 3, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);//当然这里也可以通过setSpan来设置哪些位置的文本哪些颜色
        nfc_upen.setText(str);
        nfc_upen.setMovementMethod(LinkMovementMethod.getInstance());//不设置 没有点击事件
    }


    private void showLoading() {
        nfc_upen.setVisibility(View.GONE);
    }


    private BroadcastReceiver mStatusReceive = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case NfcAdapter.ACTION_ADAPTER_STATE_CHANGED:
                    int blueState = intent.getIntExtra(NfcAdapter.EXTRA_ADAPTER_STATE, 0);
                    switch (blueState) {
                        case NfcAdapter.STATE_ON:
                            //开始扫描
                            showLoading();
                            break;
                        case NfcAdapter.STATE_OFF:
                            showUnopen();
                            break;
                    }
                    break;
            }
        }
    };


    private void registerNFCReceiver() {
        IntentFilter statusFilter = new IntentFilter(NfcAdapter.ACTION_ADAPTER_STATE_CHANGED);
        getActivity().registerReceiver(mStatusReceive, statusFilter);
    }


    private void unregisterNFCReceiver() {
        getActivity().unregisterReceiver(mStatusReceive);
    }

}
