/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.listener.IInitCallback;
import com.baidu.idl.face.platform.ui.utils.FaceInfoCache;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.config.FaceLicenseConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.receiver.BaiduFaceEvent;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ocr.activity.CameraReadyActivity;
import ocr.activity.ChooseBindWayActivity;
import ocr.activity.LiveStartActivity;
import okhttp3.Call;

@Route(path="/cert/phone_info", name="\u8f93\u5165\u624b\u673a\u53f7")
public class PhoneInputActivity
extends BaseActivity
implements View.OnClickListener {
    private RadioGroup gender;
    private EditText etName;
    private EditText etId;
    private EditText etPhone;
    private EditText etSMSCode;
    private Button btn_submit;
    private LinearLayout standard;
    private TextView title;
    private PinDialog pinDialog;
    @Autowired(name="cardType")
    public CryptoDevType cardType;
    @Autowired(name="containerNum")
    public int containerNum;
    @Autowired(name="cardNum")
    public String cardNum;
    @Autowired(name="certType")
    public String certType;
    private static final String REGEX_NUMBER_IDCARD_FIRST = "[^0-9]";
    private static final String REGEX_NUMBER_IDCARD_SECOND = "[^[0-9Xx]$]";
    private String beforeStr;
    private String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            this.temp = charSequence;
        }

        public void afterTextChanged(Editable editable) {
            if (this.temp.length() < 6 || this.temp.length() > 12) {
                PhoneInputActivity.this.btn_submit.setEnabled(false);
            } else {
                PhoneInputActivity.this.btn_submit.setEnabled(true);
            }
        }
    };
    private boolean isNext = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cert_creation_phone_input);
        this.getIntentData();
        this.initView();
        this.setHint();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
        this.certType = this.getIntent().getStringExtra("certType");
        this.initBaiduLive();
    }

    private void initBaiduLive() {
        String liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();
        if (liveCompany.equals("\u767e\u5ea6")) {
            FaceSDKManager.getInstance().initialize((Context)this, FaceLicenseConfig.getLicenseKeyId(true), "idl-license.face-android", new IInitCallback(){

                public void initSuccess() {
                }

                public void initFailure(int errCode, String errMsg) {
                }
            });
        }
    }

    @Override
    public String nextActivity() {
        return "/cert/camera_ready";
    }

    private void setHint() {
        this.etPhone.setHint(R.string.cert_creation_valid_phone_hint_others);
        if (!this.procedure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b") && !this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
            this.etPhone.addTextChangedListener(this.textWatcher);
            this.btn_submit.setEnabled(false);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isNext) {
            if (!this.procedure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b") && !this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
                this.btn_submit.setEnabled(false);
            }
            if (!this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
                this.etPhone.setText((CharSequence)"");
            }
            this.isNext = false;
        }
        ImageCache.getInstance().clear();
    }

    private void initView() {
        if (this.cardType != CryptoDevType.DEV_TYPE_Soft || NetVHSMHandle.isNetVHSMCanUse()) {
            DeviceWrapper.getInstance();
            int pinResult = DeviceWrapper.verifyPin(this.cardType, this.containerNum, AppConfig.getInstance().getDefaultConfig().getPin());
            if (pinResult != 0) {
                this.pinDialog = new PinDialog(this.context, this.cardType);
                this.pinDialog.show();
            }
        }
        this.title = (TextView)this.findViewById(R.id.info_title);
        this.etPhone = (EditText)this.findViewById(R.id.et_phone);
        this.etPhone.setFilters(EditTextUtil.getDisableEmojFilter(12));
        this.etSMSCode = (EditText)this.findViewById(R.id.et_sms_code);
        this.etSMSCode.setFilters(EditTextUtil.getDisableEmojFilter());
        this.btn_submit = (Button)this.findViewById(R.id.btn_submit);
        this.btn_submit.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                PhoneInputActivity.this.submit();
            }
        });
        if (this.procedure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
            this.btn_submit.setText(R.string.cert_creation_submit);
        }
        this.initInfoView();
    }

    private void initInfoView() {
        if (!this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
            this.title.setText(R.string.cert_creation_apply_cert);
            return;
        }
        this.standard = (LinearLayout)this.findViewById(R.id.standard);
        if (this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
            this.standard.setVisibility(0);
        } else {
            this.standard.setVisibility(8);
        }
        this.etName = (EditText)this.findViewById(R.id.et_name);
        this.etName.setFilters(EditTextUtil.getHanziFilter(14));
        this.gender = (RadioGroup)this.findViewById(R.id.gender);
        this.etId = (EditText)this.findViewById(R.id.et_id);
        this.etId.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etId.setFilters(new InputFilter[]{new InputFilter.LengthFilter(18)});
        this.etId.setRawInputType(2);
        this.etId.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                PhoneInputActivity.this.beforeStr = s.toString();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Pattern p;
                Matcher m;
                String str;
                String editable = PhoneInputActivity.this.etId.getText().toString();
                if (!editable.equals(str = (m = (p = PhoneInputActivity.this.beforeStr.length() <= 16 ? Pattern.compile(PhoneInputActivity.REGEX_NUMBER_IDCARD_FIRST) : Pattern.compile(PhoneInputActivity.REGEX_NUMBER_IDCARD_SECOND)).matcher(editable)).replaceAll("").trim())) {
                    PhoneInputActivity.this.etId.setText((CharSequence)str);
                    PhoneInputActivity.this.etId.setSelection(str.length());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    protected int getTitleRes() {
        return -1;
    }

    public void submit() {
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        ModuleLog.e((Object)"PhoneInputActivity submit");
        this.next();
    }

    @Override
    public void next() {
        super.next();
        ModuleLog.e((Object)"PhoneInput next");
        KeyboardUtils.hideKeyboard((View)this.etPhone);
    }

    @Override
    public void route() {
        super.route();
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        switch (this.procedure) {
            case "\u6807\u51c6\u6d41\u7a0b": {
                this.startStandard();
                break;
            }
            case "\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b": {
                this.startSimplified();
                break;
            }
            case "\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b": {
                this.request();
                break;
            }
            case "\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09": {
                this.startStandard();
                break;
            }
            case "\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09": {
                this.startStandard();
                break;
            }
        }
        this.isNext = true;
    }

    private void startStandard() {
        String liveCompany;
        switch (liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany()) {
            case "\u4e91\u4ece": {
                this.startLivePrepareActivity();
                break;
            }
            case "\u767e\u5ea6": {
                this.startLivePrepareActivity();
                break;
            }
            case "\u65f7\u4e16": {
                break;
            }
        }
    }

    private void startSimplified() {
        this.startSelfieActivity();
    }

    private void startSelfieActivity() {
        SharePreferencesUtil.saveDevCardID((Context)this, this.cardNum);
        SharePreferencesUtil.saveCurrentDevType((Context)this, this.cardType.getType());
        SharePreferencesUtil.saveSelfieStep(this.context, 0);
        Intent intent = new Intent((Context)this, CameraReadyActivity.class);
        intent.putExtra("photoType", 0);
        intent.putExtra("cardNum", this.cardNum);
        intent.putExtra("cardType", (Serializable)this.cardType);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    private void startLivePrepareActivity() {
        Intent intent = new Intent((Context)this, LiveStartActivity.class);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.request_sms_code) {
            this.request();
        }
    }

    private void request() {
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            String phone = this.etPhone.getText().toString();
            if (TextUtils.isEmpty((CharSequence)phone)) {
                ModuleToast.showNoRepeat(this.context, R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }
            this.verifyPhoneNum(phone);
        }
    }

    private void verifyPhoneNum(String phone) {
        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);
        this.service.verifyPhoneNum(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                PhoneInputActivity.this.showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String resultCode = commonResponse.getResult();
                if (resultCode.equals("0")) {
                    PhoneInputActivity.this.startVerify();
                } else {
                    PhoneResult phoneResult = PhoneInputActivity.this.buildPhoneResult(PhoneInputActivity.this.getCardType(), PhoneInputActivity.this.getCardNum(), commonResponse, null);
                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(PhoneInputActivity.this.containerNum);
                    authResult.setPhoneResult(phoneResult);
                    OttoUtil.postPhoneAuthResult(authResult);
                    PhoneInputActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void dismissDialog() {
                PhoneInputActivity.this.dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    private void startVerify() {
        CryptoDevType cryptoDevType = IntentUtil.getCardType(this.getIntent());
        if (cryptoDevType == null || TextUtils.isEmpty((CharSequence)this.cardNum)) {
            return;
        }
        String phoneNum = this.etPhone.getText().toString();
        SharePreferencesUtil.savePhone(this.context, phoneNum);
        ModuleLog.e((Object)"PhoneInput 531");
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
                PhoneInputActivity.this.showLoading();
            }

            @Override
            public void cancelDialog() {
                PhoneInputActivity.this.dismissLoading();
            }

            @Override
            public void IOError() {
                PhoneInputActivity.this.dismissLoading();
                PhoneInputActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                ApplyCertUtil.handleSuccessResult((Context)PhoneInputActivity.this, response);
                PhoneInputActivity.this.finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                PhoneInputActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        DeviceWrapper.getInstance().setApplyCertEnd(false);
        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(this.getCardType(), this.containerNum, this.getCardNum(), null, baseErrorResponse));
        OttoUtil.postFinishActivity();
        this.finish();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    public boolean valid() {
        if (this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
            if (!ValidUtil.name(this.etName.getText().toString())) {
                ModuleToast.show(this.context, R.string.cert_creation_invalid_name_length);
                KeyboardUtils.hideKeyboard((Activity)this);
                return false;
            }
            if (!ValidUtil.idNum(this.etId.getText().toString())) {
                ModuleToast.show(this.context, R.string.cert_creation_error_id_size);
                KeyboardUtils.hideKeyboard((Activity)this);
                return false;
            }
            if (!ValidUtil.phone(this.etPhone.getText().toString())) {
                ModuleToast.show(this.context, R.string.cert_creation_err_length);
                KeyboardUtils.hideKeyboard((Activity)this);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void saveValue() {
        if (this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
            SharePreferencesUtil.saveIDCardNo((Context)this, this.cardType.getType(), this.etId.getText().toString().toUpperCase());
            SharePreferencesUtil.saveSex((Context)this, this.cardType.getType(), this.gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
            SharePreferencesUtil.saveName((Context)this, this.etName.getText().toString());
        }
        SharePreferencesUtil.savePhone(this.context, this.etPhone.getText().toString());
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    @Subscribe
    public void handleFaceEvent(BaiduFaceEvent event) {
        if (event.isSuccess()) {
            String faceInfo = FaceInfoCache.getInStance().getFaceInfoStr();
            ImageCache.getInstance().setSelfie(Selfie.BAIDU, faceInfo, false);
            FaceInfoCache.getInStance().clearFaceInfo();
            Intent intent = new Intent((Context)this, ChooseBindWayActivity.class);
            intent.putExtra("containerNum", this.containerNum);
            this.startActivity(intent);
        }
    }
}

