/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.ConfigListAdapter;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import java.util.List;

public class CertConfigAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<TableCertConfig> list;
    private boolean enableVHSM;
    ConfigListAdapter.OnItemClickListener onItemClickListener;

    public CertConfigAdapter(Context context, List<TableCertConfig> list, boolean enableVHSM) {
        this.context = context;
        this.list = list;
        this.enableVHSM = enableVHSM;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_device_detail, null));
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        TableCertConfig certConfig = this.list.get(position);
        holder.cardType.setText((CharSequence)certConfig.getCardType());
        if (holder.cardType.getText().toString().equals("\u8bf7\u9009\u62e9")) {
            holder.cardType.setTextColor(this.context.getResources().getColor(R.color.cert_creation_config_please_choose));
        } else {
            holder.cardType.setTextColor(this.context.getResources().getColor(R.color.black_333333));
        }
        holder.layoutCardType.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                if (CertConfigAdapter.this.enableVHSM) {
                    ConfigDialog.show(CertConfigAdapter.this.context, position, CardType.list);
                } else {
                    ConfigDialog.show(CertConfigAdapter.this.context, position, CardType.noVHSMList);
                }
            }
        });
        holder.containerNum.setText((CharSequence)String.valueOf(certConfig.getContainerNum()));
        holder.layoutContainerNum.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(CertConfigAdapter.this.context, position, ContainerNum.list);
            }
        });
        holder.algType.setText((CharSequence)certConfig.getAlgType());
        holder.layoutAlgType.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(CertConfigAdapter.this.context, position, AlgType.list);
            }
        });
        holder.certRule.setText((CharSequence)certConfig.getCertRule());
        holder.layoutCertRule.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(CertConfigAdapter.this.context, position, CertRule.list);
            }
        });
        holder.certType.setText((CharSequence)certConfig.getCertType());
        holder.layoutCertType.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(CertConfigAdapter.this.context, position, CertType.list);
            }
        });
        holder.certPermission.setText((CharSequence)certConfig.getCertPermission());
        holder.layoutCertPermission.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(CertConfigAdapter.this.context, position, CertPermission.list);
            }
        });
        if (position == 0) {
            holder.delete.setVisibility(4);
        } else {
            holder.delete.setVisibility(0);
        }
        holder.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                OttoUtil.postDeleteCertDetail(position);
            }
        });
    }

    public int getItemCount() {
        return this.list.size();
    }

    public void setOnItemClickListener(ConfigListAdapter.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemSelected(int var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView cardType;
        View layoutCardType;
        TextView containerNum;
        View layoutContainerNum;
        TextView algType;
        View layoutAlgType;
        TextView certRule;
        View layoutCertRule;
        TextView certType;
        View layoutCertType;
        TextView certPermission;
        View layoutCertPermission;
        View delete;

        public ViewHolder(View itemView) {
            super(itemView);
            this.cardType = (TextView)itemView.findViewById(R.id.card_type);
            this.layoutCardType = itemView.findViewById(R.id.layout_card_type);
            this.containerNum = (TextView)itemView.findViewById(R.id.container_num);
            this.layoutContainerNum = itemView.findViewById(R.id.layout_container_num);
            this.algType = (TextView)itemView.findViewById(R.id.alg_type);
            this.layoutAlgType = itemView.findViewById(R.id.layout_alg_type);
            this.certRule = (TextView)itemView.findViewById(R.id.cert_rule);
            this.layoutCertRule = itemView.findViewById(R.id.layout_cert_rule);
            this.certType = (TextView)itemView.findViewById(R.id.cert_type);
            this.layoutCertType = itemView.findViewById(R.id.layout_cert_type);
            this.certPermission = (TextView)itemView.findViewById(R.id.cert_permission);
            this.layoutCertPermission = itemView.findViewById(R.id.layout_cert_permission);
            this.delete = itemView.findViewById(R.id.delete);
        }
    }
}

