/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.IOException;
import java.io.Serializable;
import ocr.activity.AuthenticationFailActivity;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

@Route(name="\u4fe1\u5927\u6377\u5b89\u8eab\u4efd\u8bc1\u7ed3\u679c", path="/cert/xdja_id_result")
public abstract class IDCardActivity
extends BaseActivity {
    @Autowired(name="identify_info")
    public IDCardInfo info;
    @Autowired(name="faceImg")
    public String faceImg;
    @Autowired(name="containerNum")
    public int containerNum;
    private static final String IDENTIFY_INFO = "identify_info";
    public Bitmap faceBitmap;
    TextView nameTv;
    TextView genderTv;
    TextView nationTv;
    TextView dataTv;
    TextView adressTv;
    TextView bornIDTv;
    ImageView photoImg;
    TextView srcGovTv;
    TextView userTimeTv;

    protected int getToolbarType() {
        return super.getToolbarType();
    }

    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_result);
        this.initView();
        this.getData();
        this.initIDFace();
        this.setData();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.info = (IDCardInfo)this.getIntent().getParcelableExtra(IDENTIFY_INFO);
        this.faceImg = ImageCache.getInstance().getSelfie();
        this.containerNum = this.getIntent().getIntExtra("containerNum", this.containerNum);
    }

    @Override
    protected int setLoadingText() {
        return R.string.cert_creation_face_comparing;
    }

    public void initIDFace() {
    }

    @Override
    public void getData() {
        Bundle others = this.getIntent().getExtras();
        if (others != null && others.containsKey(IDENTIFY_INFO)) {
            this.info = (IDCardInfo)others.getParcelable(IDENTIFY_INFO);
        }
        if (others != null && others.containsKey("faceImg")) {
            this.faceImg = others.getString("faceImg");
        }
        if (others != null) {
            this.containerNum = others.getInt("containerNum");
        }
    }

    protected void setData() {
        if (this.info != null) {
            this.showIdentifyInfo(this.info);
        }
    }

    public void rescan() {
    }

    @Override
    public void next() {
        if (this.info != null) {
            this.request();
        }
    }

    private void initView() {
        this.nameTv = (TextView)this.findViewById(R.id.name);
        this.genderTv = (TextView)this.findViewById(R.id.gender);
        this.nationTv = (TextView)this.findViewById(R.id.nation);
        this.dataTv = (TextView)this.findViewById(R.id.data);
        this.adressTv = (TextView)this.findViewById(R.id.adress);
        this.bornIDTv = (TextView)this.findViewById(R.id.bornId);
        this.photoImg = (ImageView)this.findViewById(R.id.photo);
        this.srcGovTv = (TextView)this.findViewById(R.id.SrcGov);
        this.userTimeTv = (TextView)this.findViewById(R.id.UserTime);
        Button btn_next = (Button)this.findViewById(R.id.btn_next);
        btn_next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IDCardActivity.this.next();
            }
        });
        Button btn_again = (Button)this.findViewById(R.id.btn_again);
        btn_again.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IDCardActivity.this.rescan();
            }
        });
    }

    private void showIdentifyInfo(IDCardInfo info) {
        this.setData(info);
    }

    private void setData(IDCardInfo cardInfo) {
        if (cardInfo.getName() == null) {
            return;
        }
        String gender = "\u7537";
        if (cardInfo.getSex() == 2) {
            gender = "\u5973";
        }
        this.nameTv.setText((CharSequence)cardInfo.getName());
        this.genderTv.setText((CharSequence)gender);
        this.nationTv.setText((CharSequence)cardInfo.getNation());
        String year = "";
        String month = "";
        String day = "";
        String date = cardInfo.getBirthDate();
        if (date.length() == 8) {
            year = date.substring(0, 4);
            month = date.substring(4, 6);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            if ((day = date.substring(6, 8)).substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        } else {
            year = date.substring(0, 4);
            month = date.substring(5, 7);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            if ((day = date.substring(8, 10)).substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        }
        this.dataTv.setText((CharSequence)(year + "        " + month + "      " + day));
        this.adressTv.setText((CharSequence)cardInfo.getAddr());
        this.bornIDTv.setText((CharSequence)cardInfo.getIdNum());
        this.photoImg.setImageBitmap(this.changeBitmapSize(this.faceBitmap));
        String[] info2 = new String[]{cardInfo.getIssueOffice(), cardInfo.getValidDate()};
        this.srcGovTv.setText((CharSequence)info2[0]);
        this.userTimeTv.setText((CharSequence)info2[1]);
    }

    private Bitmap changeBitmapSize(Bitmap bitmap) {
        if (bitmap == null) {
            bitmap = ImageCache.getInstance().getNfcFaceImg();
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        float radioW = 148.0f / (float)w;
        float radioH = 182.0f / (float)h;
        Matrix matrix = new Matrix();
        matrix.postScale(radioW, radioH);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private void request() {
        final int devType = SharePreferencesUtil.getCurrentDevType((Context)this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show(this.context, R.string.cert_creation_card_device_error);
            return;
        }
        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        if (request == null) {
            ModuleToast.show(this.context, R.string.cert_creation_get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(this.getResources().getString(R.string.cert_creation_get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(this.info.getIdNum());
            this.verifyFailResultActivity(currentChipBeanType, compareResult);
            this.finish();
            OttoUtil.postFinishActivity();
            return;
        }
        this.showLoading();
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e((Object)"other exception");
                compareResult.setResult("");
                compareResult.setMessage(IDCardActivity.this.context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(IDCardActivity.this.info.getIdNum());
                IDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                IDCardActivity.this.finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e((Object)"io exception");
                compareResult.setResult("");
                compareResult.setMessage(IDCardActivity.this.context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(IDCardActivity.this.info.getIdNum());
                IDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                SharePreferencesUtil.saveIDCardNo(IDCardActivity.this.context, devType, IDCardActivity.this.info.getIdNum());
                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(IDCardActivity.this.info.getIdNum());
                compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    IDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, IDCardActivity.this.containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }
                OttoUtil.postFinishActivity();
                OttoUtil.postFinishYishuNFC();
                IDCardActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(IDCardActivity.this.info.getIdNum());
                compareResult.setSuccess(false);
                IDCardActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                IDCardActivity.this.finish();
            }

            @Override
            public void dismissDialog() {
                IDCardActivity.this.dismissLoading();
            }
        });
    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {
        Intent intent = new Intent((Context)this, AuthenticationFailActivity.class);
        intent.putExtra("result", (Serializable)result);
        intent.putExtra("devType", (Serializable)type);
        intent.putExtra(IDENTIFY_INFO, (Parcelable)this.info);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType((Context)this)));
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum((Context)this));
        if (AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM")) {
            chipInfo.setVhsmType("1");
            chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId((Context)this.context));
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }
        request.setIdCardInfo(this.info);
        request.setChipInfo(chipInfo);
        if (this.faceImg == null) {
            this.faceImg = ImageCache.getInstance().getSelfie();
        }
        request.setFaceImg(this.faceImg);
        int type = SharePreferencesUtil.getCurrentDevType((Context)this);
        CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);
        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, this.containerNum));
        ModuleLog.e((Object)request.toString());
        return request;
    }
}

