/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.aircert.dialog.BaseErrorDialog;
import com.aircert.dialog.BindIdentifyDialog;
import com.squareup.otto.Subscribe;
import com.xdja.R;
import com.xdja.aspectjmodule.advise.AdvisePermission;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.AboutActivity;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertViewActivity$AjcClosure1;
import com.xdja.safeclient.certcreation.activity.CertViewActivity$AjcClosure3;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CertViewActivity
extends BaseActivity
implements View.OnClickListener {
    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;
    private SwipeRefreshLayout swipe;
    private boolean isFirstStart = true;
    private String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    private int type = -1;
    private List<CertItemBean> certItemBeans = null;
    private boolean isResumeExe = true;
    private BaseErrorDialog baseErrorDialog;
    public static long lastClickTime;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_view);
        this.setToolbarRightBtn(R.drawable.settings, this);
        this.initView();
    }

    protected int getToolbarType() {
        return 1;
    }

    protected int getTitleRes() {
        return R.string.cert_view;
    }

    protected void onResume() {
        super.onResume();
        if (!this.isResumeExe) {
            return;
        }
        if (this.isFirstStart) {
            this.isFirstStart = false;
            if (this.checkValidPermission(this.permissions)) {
                this.getCertAndShow();
            } else {
                this.showInvalidPermissionDialog();
            }
        } else {
            this.getCertAndShow();
        }
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void getCertAndShow() {
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            return;
        }
        this.noChip = (LinearLayout)this.findViewById(R.id.no_chip);
        this.recyclerViewAdapter.clear();
        this.certItemBeans = this.getCertItemBeans();
        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            this.swipe.setVisibility(8);
            this.noChip.setVisibility(0);
        } else {
            this.swipe.setVisibility(0);
            this.noChip.setVisibility(8);
            this.recyclerViewAdapter.addAll(this.certItemBeans);
        }
    }

    @XdjaPermission(permissions={"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"})
    private void checkoutPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CertViewActivity$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = CertViewActivity.class.getDeclaredMethod("checkoutPermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void showInvalidPermissionDialog() {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append(this.getString(R.string.verify_permission_content));
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            sbContent.append(this.getString(R.string.verify_permission_content_item1));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            sbContent.append(this.getString(R.string.verify_permission_content_item2));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") != 0) {
            sbContent.append(this.getString(R.string.verify_permission_content_item3));
        }
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(sbContent.toString());
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        this.type = requestPhonePermission.type;
        this.requestPhonePermission();
    }

    @XdjaPermission(permissions={"android.permission.READ_PHONE_STATE"})
    private void requestPhonePermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        AdvisePermission advisePermission = AdvisePermission.aspectOf();
        Object[] objectArray = new Object[]{this, joinPoint};
        ProceedingJoinPoint proceedingJoinPoint = new CertViewActivity$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648);
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = CertViewActivity.class.getDeclaredMethod("requestPhonePermission", new Class[0]).getAnnotation(XdjaPermission.class);
        }
        advisePermission.weavePermission(proceedingJoinPoint, (XdjaPermission)annotation);
    }

    private void sendPhonePermissionResult() {
        OttoUtil.postPhonePermissionResult(this.type);
        this.type = -1;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.destroy();
        }
    }

    private List<CertItemBean> getCertItemBeans() {
        ArrayList<CertItemBean> certItemBeans = new ArrayList<CertItemBean>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();
        if (devInfoMap == null || devInfoMap.size() == 0) {
            return certItemBeans;
        }
        for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
            CertItemBean certItemBean = new CertItemBean();
            if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SdCard.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SdCard);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_SimKey.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_SimKey);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Soft.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Soft);
            } else if (cryptoDevInfoEntry.getKey().intValue() == CryptoDevType.DEV_TYPE_Chip.getType()) {
                certItemBean.setType(CryptoDevType.DEV_TYPE_Chip);
            }
            certItemBean.setCryptoDevInfo(cryptoDevInfoEntry.getValue());
            certItemBeans.add(certItemBean);
        }
        return certItemBeans;
    }

    private void initView() {
        this.swipe = (SwipeRefreshLayout)this.findViewById(R.id.swipe);
        this.swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                CertViewActivity.this.pullToRefresh();
            }
        });
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.recyclerViewAdapter = new RecyclerViewAdapter((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerViewAdapter);
        if (this.hideSettings()) {
            this.rightBtn.setVisibility(8);
        } else {
            this.rightBtn.setVisibility(0);
        }
    }

    private void pullToRefresh() {
        this.recyclerViewAdapter.refresh();
    }

    boolean hideSettings() {
        return true;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.title_right_btn && !this.hideSettings()) {
            Intent intent = new Intent();
            intent.setClass((Context)this, AboutActivity.class);
            this.startActivity(intent);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        this.onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        this.isResumeExe = false;
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                CertViewActivity.this.isResumeExe = true;
                if (CertViewActivity.this.type == -1) {
                    CertViewActivity.this.getCertAndShow();
                } else if (isGrant) {
                    CertViewActivity.this.sendPhonePermissionResult();
                } else {
                    CertViewActivity.this.showNoPhonePermissionDialog();
                }
            }
        }, 10L);
    }

    public void showNoPhonePermissionDialog() {
        if (this.baseErrorDialog == null) {
            this.initNoPermissionDialog();
        }
        this.baseErrorDialog.show();
    }

    private void initNoPermissionDialog() {
        this.baseErrorDialog = new BaseErrorDialog.BaseErrorBuilder((Context)this).setTitle(R.string.verify_permission_title).setContent(this.getString(R.string.permission_content, new Object[]{"\u7535\u8bdd"})).setPositiveButton(R.string.confirm, new View.OnClickListener(){

            public void onClick(View v) {
                CertViewActivity.this.baseErrorDialog.dismiss();
                CertViewActivity.this.gotoSetting();
            }
        }).create();
        this.baseErrorDialog.setCanceledOnTouchOutside(false);
        this.baseErrorDialog.setCancelable(false);
        this.baseErrorDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    return false;
                }
                return false;
            }
        });
    }

    private void gotoSetting() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivity(intent);
    }

    public void finish() {
        super.finish();
        new CertService().cancelAll();
    }

    public void onAuthResult(AuthResult result) {
        if (result != null) {
            this.recyclerViewAdapter.update(result);
        }
    }

    @Override
    public void onBackPressed() {
        if (lastClickTime == 0L) {
            lastClickTime = System.currentTimeMillis();
            ModuleToast.show((Context)this, R.string.click_one_more);
        } else {
            long current = System.currentTimeMillis();
            if (current - lastClickTime < 1000L) {
                super.onBackPressed();
            } else {
                ModuleToast.show((Context)this, R.string.click_one_more);
            }
            lastClickTime = current;
        }
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        this.swipe.setRefreshing(false);
    }

    static {
        CertViewActivity.ajc$preClinit();
    }

    static final /* synthetic */ void checkoutPermission_aroundBody0(CertViewActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.getCertAndShow();
        }
    }

    static final /* synthetic */ void requestPhonePermission_aroundBody2(CertViewActivity ajc$this, JoinPoint joinPoint) {
        if (Build.VERSION.SDK_INT < 23) {
            ajc$this.sendPhonePermissionResult();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CertViewActivity.java", CertViewActivity.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkoutPermission", "com.xdja.safeclient.certcreation.activity.CertViewActivity", "", "", "", "void"), 149);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestPhonePermission", "com.xdja.safeclient.certcreation.activity.CertViewActivity", "", "", "", "void"), 222);
    }
}

