package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 填写基本信息
 * Created by zjc on 2018/6/2 0002.
 */
@Route(path = ActivityPath.ACTIVITY_BASIC_INFO, name = ActivityPath.NAME_BASIC_INFO)
public class BasicInfoActivity extends BaseActivity {

    Button next;

    RadioGroup gender;

    EditText etName;

    EditText etId;

    String phone;

    Context context;

    CryptoDevType cardType;

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    private static final String REGEX_NUMBER_IDCARD_FIRST = "[^0-9]";
    private static final String REGEX_NUMBER_IDCARD_SECOND = "[^[0-9Xx]$]";

    private String beforeStr;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_basic_info);

        context = this;

        etName = (EditText) findViewById(R.id.et_name);
        etName.setFilters(EditTextUtil.getDisableEmojFilter());
        etName.setFilters(EditTextUtil.getHanziFilter(14));

        gender = (RadioGroup) findViewById(R.id.gender);

        etId = (EditText) findViewById(R.id.et_id);
        etId.setFilters(EditTextUtil.getDisableEmojFilter());
        etId.setFilters(new InputFilter[]{new InputFilter.LengthFilter(18)});

        etId.setRawInputType(Configuration.KEYBOARD_QWERTY);  //首先展示数字键盘。该属性只改变输入键盘的显示（数字、文本等），不改变输入类型的限制。gyx
        etId.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                beforeStr = s.toString();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String editable = etId.getText().toString();
                Pattern p;
                if (beforeStr.length() <= 16) {
                    p = Pattern.compile(REGEX_NUMBER_IDCARD_FIRST);
                } else {
                    p = Pattern.compile(REGEX_NUMBER_IDCARD_SECOND);
                }
                Matcher m = p.matcher(editable);
                String str = m.replaceAll("").trim();    //删掉不是字母或数字的字符
                if (!editable.equals(str)) {
                    etId.setText(str);  //设置EditText的字符
                    etId.setSelection(str.length()); //因为删除了字符，要重写设置新的光标所在位置
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
            }
        });
        phone = SharePreferencesUtil.getPhoneNum(this);


        //TODO JFF 第五迭代合并过来代码，需要处理界面调整问题  第七迭代
//        Bundle bundle = getIntent().getExtras();
//        if (bundle != null && bundle.containsKey(FACE_IMG)) {
//            faceImg = bundle.getString(FACE_IMG);
//        }
//
//        TextView ocr2nfc = (TextView) findViewById(R.id.ocr2nfc);
//        int ocrCompany = CertCommonModule.getInstance().getOcrCompany();
//        int nfcCompany = CertCommonModule.getInstance().getNfcCompany();
//
//        if(ocrCompany == OCRCompany.NO_OCR && nfcCompany == NFCCompany.YISHU){//西藏现场有NFC没有OCR
//            ocr2nfc.setVisibility(View.VISIBLE);
//        } else {
//            ocr2nfc.setVisibility(View.GONE);//宁夏监狱没有OCR没有NFC但是手输身份证号带库云从
//        }
//
//
//        ocr2nfc.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//
//                Bundle bundle = new Bundle();
//                bundle.putString(FACE_IMG, faceImg);
//                Intent intent = new Intent(BasicInfoActivity.
//                        this, ChooseBindWayActivity.class);
//                intent = IntentUtil.putInfo(intent, cardType, cardNo);
//                intent = IntentUtil.putPhone(intent, phone);
//                intent.putExtras(bundle);
//                startActivity(intent);
//                finish();
//                OttoUtil.postFinishChooseBindWay();
//                overridePendingTransition(com.xdja.R.anim.right_in, com.xdja.R.anim.right_out);
//            }
//        });


        next = (Button) findViewById(R.id.next);
        int city = AppConfig.getInstance().getProject();
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure()
                .equals(Procedure.STD_NO_OCR)) {//西藏
            next.setText(R.string.cert_creation_submit);
        }
        next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (!validContent()) {
                    return;
                }

                RequestCache.getInstance().setTime(System.currentTimeMillis());

                cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(BasicInfoActivity.this));
                String cardNum = SharePreferencesUtil.getDevCardID(BasicInfoActivity.this);

                if (
                        ValidUtil.cardType(cardType) &&
                                ValidUtil.cardNum(cardNum) &&
                                ValidUtil.name(etName.getText().toString()) &&
                                ValidUtil.idNum(etId.getText().toString())
                ) {

                    saveValues();

                    ApplyCertUtil.start(BasicInfoActivity.this, containerNum, new ApplyCertUtil.WhatHappen() {
                        @Override
                        public void showDialog() {
                            BasicInfoActivity.this.showLoading();
                        }

                        @Override
                        public void cancelDialog() {
                            BasicInfoActivity.this.dismissLoading();
                        }

                        @Override
                        public void IOError() {
                            BasicInfoActivity.this.dismissLoading();
                            showRequestError();
                        }

                        @Override
                        public void handleResult(CommonResponse response) {
                            ApplyCertUtil.handleSuccessResult(BasicInfoActivity.this, response);
                        }

                        @Override
                        public void handleError(BaseErrorResponse baseErrorResponse) {
                            BasicInfoActivity.this.handleError(baseErrorResponse);
                        }
                    });

                }
            }
        });
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
    }

    private boolean validContent() {
        String name = etName.getText().toString();

        KeyboardUtils.hideKeyboard(BasicInfoActivity.this);

        if (!ValidUtil.name(name)) {
            ModuleToast.show(context, getResources().getString(R.string.cert_creation_invalid_name_length));
            return false;
        }


        String idNo = etId.getText().toString().toUpperCase();
        if (idNo.isEmpty() || idNo.length() <= 0) {
            ModuleToast.show(context, getResources().getString(R.string.cert_creation_error_id_not_null));
            return false;
        }
        if (!idNo.isEmpty() && idNo.length() < 18) {
            ModuleToast.show(context, getResources().getString(R.string.cert_creation_error_id_size));
            return false;
        }

        return true;
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, containerNum, SharePreferencesUtil.getDevCardID(BasicInfoActivity.this), null, baseErrorResponse));
        OttoUtil.postFinishActivity();

    }

    private void saveValues() {
        SharePreferencesUtil.savePhone(context, phone);
        SharePreferencesUtil.saveIDCardNo(this, cardType.getType(), etId.getText().toString().toUpperCase());
        SharePreferencesUtil.saveSex(this, cardType.getType(), gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
        SharePreferencesUtil.saveName(this, etName.getText().toString());
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }


    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_activity_basic_info;
    }


    @Override
    protected boolean isOCRActivity() {
        return true;
    }
}
