package com.xdja.safeclient.certcreation.activity;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;

import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.EmbeddedCertAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_BACK;

/**
 * Created by Administrator on 2020/4/20 0020.
 */

public class EmbeddedCertViewActivity extends BaseActivity {

    private RecyclerView recyclerView;
    private EmbeddedCertAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;

    private LinearLayout noChip;

    private int navigateType;
    private int titleRes;


    private List<CertItemBean> certItemBeans = null;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {

        initConfigView();

        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_embedded_cert_view);

        getCertData();

        initView();

        // 必须单独加一行，不然不生效。未深究原因
        left_title_tv.setText(R.string.cert_creation_cert_view);


    }

    private void initConfigView() {
        // AAR显示左上角的返回列表
        navigateType = NAVIGATE_BACK;
        titleRes = R.string.cert_creation_cert_view;

        //是否屏蔽软卡 true屏蔽    false不屏蔽
        if (FeatureConfig.getInstance().isDisableVHSM() ||
                !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }

    }

    private void initView() {

        layoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        recyclerViewAdapter = new EmbeddedCertAdapter(this, certItemBeans);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerview);
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setAdapter(recyclerViewAdapter);

        if (BuildConfig.isAAR) {
            rightBtn.setVisibility(View.GONE);
        }

        noChip = (LinearLayout) findViewById(R.id.no_chip);

        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            noChip.setVisibility(View.VISIBLE);
        } else {
            noChip.setVisibility(View.GONE);
        }

    }

    private void getCertData() {

        this.certItemBeans = initList(getCurrentCardTypeList());



    }

    /**
     * 读取当前设备实际上存在的设备类型
     *
     * @return
     */
    private List<String> getCurrentCardTypeList() {

        List<String> cardTypeList = new ArrayList<>();

        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();

        if (devInfoMap != null) {
            for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {

                if (cryptoDevInfoEntry != null) {
                    cardTypeList.add(CardType.toString(cryptoDevInfoEntry.getValue().getType()));
                }

            }
        }

        return cardTypeList;
    }


    private List<CertItemBean> initList(List<String> currentCardTypeList) {


        // 已有设备
        Map<Integer, CryptoDevInfo> currentCardMaps = DeviceWrapper.getInstance().getDevInfo();

        List<CertItemBean> all = new ArrayList<>();

        // 先读配置好的数据库中所有的数据
        List<TableCertConfig> tableValue = new ArrayList<>();

        try {
            tableValue = SQLite.select().from(TableCertConfig.class).queryList();
        } catch (Exception e) {
            // 这个try-catch是融合版空包可能会走到异常里
        }

        HashSet<String> tableCardSet = new HashSet();

        // 如果当前设备列表中的设备在数据库中存在，则加入该条（配置）数据
        for (TableCertConfig config : tableValue) {

            String cardType = config.getCardType();

            tableCardSet.add(cardType);

            // 在线VHSM和离线VHSM，也就是软卡，不属于硬件设备（卡），都要展示的
            if (cardType.equals(CardType.OFFLINE_VHSM)
                    || cardType.equals(CardType.ONLINE_VHSM)
                    ) {

                CryptoDevInfo netVhsm = new CryptoDevInfo();
                netVhsm.setCardId(NetVHSMHandle.getNetVhsmCardId(this));
                netVhsm.setDriver(ChipManagerDriver.driverName);
                netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);

                XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
                netVhsm.setPrivateData((Object) extraInfo.setType(JniApiParam.TYPE_VHSM_NET));

                CertItemBean bean = new CertItemBean();
                bean.setCertConfig(config);
                bean.setCryptoDevInfo(netVhsm);
                all.add(bean);

            } else {
                if (currentCardTypeList.contains(cardType)) {

                    CertItemBean bean = new CertItemBean();
                    bean.setCertConfig(config);
                    bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(cardType).getType()));

                    all.add(bean);

                }
            }

        }

        // 如果当前已获取的设备未在数据库中配置，
        // 则用默认容器号、证书类型、算法类型、证书机制加入该条（配置）数据
        for (String currentCardType : currentCardTypeList) {
            if (!tableCardSet.contains(currentCardType)) {

                TableCertConfig tableCertConfig = TableCertConfig.initDefaultOne();

                tableCertConfig.cardType = currentCardType;


                CertItemBean bean = new CertItemBean();
                bean.setCryptoDevInfo(
                        currentCardMaps.get(CardType.toType(currentCardType).getType()));
                bean.setCertConfig(tableCertConfig);
                all.add(bean);

            }
        }

        ModuleLog.d(all);

        Collections.sort(all);


        return all;
    }


}
