package com.xdja.safeclient.certcreation.activity;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.request.VerifyInfoSelfieRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.bean.result.VerifyPhoneResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;

import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_TYPE;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;

/**
 * Created by Administrator on 2019/12/10 0010.
 */
@Route(path = ActivityPath.ACTIVITY_PHONE_APPLY_CERT, name = ActivityPath.NAME_PHONE_APPLY_CERT)
public class PhoneApplyActivity extends BaseActivity {

    private Button btn_submit;

    private EditText etPhone;

    private PinDialog pinDialog;

    @Autowired(name = CARD_TYPE)
    public CryptoDevType cardType;

    @Autowired(name = CONTAINER_NUM)
    public int containerNum;

    @Autowired(name = CARD_NUM)
    public String cardNum;

    // 这个字段不知道有没有用，想写在这儿
    @Autowired(name = ActivityParam.CERT_TYPE)
    public String certType;

    /**
     * 正在进行实体认证(在实体认证没结束之前不允许再次进入实体认证)
     */
    private boolean isVerifying = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.cert_creation_activity_phone_apply_cert);

        verifyPin();

        initView();

    }

    @Override
    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        cardType = (CryptoDevType) getIntent().getSerializableExtra("cardType");
        cardNum = getIntent().getStringExtra("cardNum");
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
    }

    private void initView() {

        etPhone = (EditText) findViewById(R.id.et_phone);
        etPhone.setFilters(EditTextUtil.getDisableEmojFilter());

        btn_submit = (Button) findViewById(R.id.btn_submit);
        btn_submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                submit();
            }
        });

    }

    private void verifyPin() {
        if (cardType == CryptoDevType.DEV_TYPE_Soft && !NetVHSMHandle.isNetVHSMCanUse()) {
            //软卡证书未初始化不进行pin码校验

        } else {
            int pinResult = DeviceWrapper.getInstance().verifyPin(cardType, containerNum,
                    AppConfig.getInstance().getDefaultConfig().getPin());

            if (pinResult != 0) {
                pinDialog = new PinDialog(this, cardType);
                pinDialog.show();
            }
        }
    }

    private void submit() {

        KeyboardUtils.hideKeyboard(etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            final String phone = etPhone.getText().toString();

            if (TextUtils.isEmpty(phone)) {
                ModuleToast.showNoRepeat(this, R.string.cert_creation_not_null_phone_num);
                return;
            }
            verifyPhoneNum(phone);

            isVerifying = true;
        }
    }

    /**
     * 验证手机号是否合法
     */
    private void verifyPhoneNum(final String phone) {

        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);

        showLoading();

        service.verifyPhoneNum(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                isVerifying = false;
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showRequestError();
                isVerifying = false;
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {

                isVerifying = false;

                String resultCode = commonResponse.getResult();
                if (resultCode.equals(VerifyPhoneResult.RESULT_OK)) {
                    //直接进行实体认证
                    startVerify();
                } else {

                    PhoneResult phoneResult
                            = buildPhoneResult(getCardType(), getCardNum(), commonResponse, null);

                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(containerNum);
                    authResult.setPhoneResult(phoneResult);

                    OttoUtil.postPhoneAuthResult(authResult);
                    finish();
                    //                    ModuleToast.show(context, "success " + getString(new VerifyPhoneResult().getErrText(resultCode)));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                isVerifying = false;
                //                ModuleLog.d("手机号验证失败：" + baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type,
                                         String cardNum,
                                         CommonResponse response,
                                         BaseErrorResponse errorResponse) {

        CompareResult result = new CompareResult();

        // TODO: 2018/11/8 0008 三种情况的处理需要重写

        //IO异常的处理
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            //错误的处理
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty(errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            //正确的处理
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            //注意，成功的时候是没有errCode的
            result.setSuccess(true);
        }

        result.setIdentity(cardNum);


        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    /**
     * 进行实体认证
     */
    private void startVerify() {

        if (cardType == null || TextUtils.isEmpty(cardNum)) {
            return;
        }

        String phoneNum = etPhone.getText().toString();
        SharePreferencesUtil.savePhone(this, phoneNum);

        ModuleLog.e("PhoneInput 531");
        ApplyCertUtil.start(this, containerNum, new ApplyCertUtil.WhatHappen() {
            @Override
            public void showDialog() {
                showLoading();
            }

            @Override
            public void cancelDialog() {
                dismissLoading();
            }

            @Override
            public void IOError() {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                dismissLoading();
                showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });

    }

    private void handleError(BaseErrorResponse baseErrorResponse) {

        OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(getCardType(), containerNum, getCardNum(), null, baseErrorResponse));
        OttoUtil.postFinishActivity();
        finish();

    }

}
