package com.xdja.safeclient.certcreation.activity;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;

import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.UpdateEventCode;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwd;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwdReq;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfo;
import com.xdja.safeclient.certcreation.bean.request.UpdateUserInfoReq;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.UpdateEvent;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import java.io.IOException;

import okhttp3.Call;

/**
 * 证书更新选择项界面
 * Created by jff on 2018/10/30.
 */
@Route(path = ActivityPath.ACTIVITY_UPDATE_CERT, name = ActivityPath.NAME_UPDATE_CERT)
public class UpdateCertActivity extends BaseActivity {

    private RadioGroup updateRadioGroup;
    private EditText updateReasonText;
    private Button updateSubmitBtn;

    @Autowired(name = "chipBean")
    public ChipBean chipBean;

    private int containerNum;

    private CertDetailInfo certDetailInfo;

    private CryptoDevType chipBeanType;

    @Autowired(name = "cardNum")
    public String cardNum;

    private String newDN;


    @Override
    protected void getIntentData() {
        super.getIntentData();

        cardNum = getIntent().getStringExtra("cardNum");
        chipBean = (ChipBean) getIntent().getSerializableExtra("chipBean");

//        certType 似乎是从chipBean中获取的

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_update_cert);
        // ARouter.getInstance().inject(this);

        init();

        certDetailInfo = chipBean.getCertBean();

        chipBeanType = CryptoDevTypeUtil.formatType(chipBean.getType());
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_updateCert_title;
    }

    private void init() {
        updateRadioGroup = (RadioGroup) findViewById(R.id.update_choose);
        updateReasonText = (EditText) findViewById(R.id.update_reason_text);
        updateReasonText.setFilters(EditTextUtil.getDisableEmojFilter());

        updateSubmitBtn = (Button) findViewById(R.id.update_submit_btn);


        updateSubmitBtn.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                int updateChoose = updateRadioGroup.getCheckedRadioButtonId();
                UpdateEvent updateEvent = new UpdateEvent();

                if (TextUtils.isEmpty(updateReasonText.getText().toString())) {
                    ModuleToast.show(getContext(), R.string.cert_creation_update_reason_input);
                    return;
                }

                if (updateChoose == R.id.delayRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.DELAY_CERT.getType());
                    updateEvent.setReasonStr(updateReasonText.getText().toString());
                    reasonIsTemp(updateEvent);
                    ModuleLog.e("延期更新");
                }

                if (updateChoose == R.id.updateUserInfoRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.USERINFO_UPDATE.getType());
                    updateEvent.setReasonStr(updateReasonText.getText().toString());
                    reasonIsTemp(updateEvent);
                    ModuleLog.e("用户信息更新");
                }

                if (updateChoose == R.id.updateCertPwdRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.UPDATE_PWD.getType());
                    updateEvent.setReasonStr(updateReasonText.getText().toString());
                    reasonIsTemp(updateEvent);
                    ModuleLog.e("密钥更新");
                }
            }
        });
    }

    private void update(UpdateEvent updateEvent) {

        CertInfoUpdateRequest certInfoUpdateRequest;
        int type = updateEvent.getUpdateType();

        String updateType = String.valueOf(type);
        String reason = updateEvent.getReasonStr();

        if (type == UpdateEventCode.USERINFO_UPDATE.getType()) {
            certInfoUpdateRequest = getCertInfoUpdateRequest(updateType, reason);
            updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.DELAY_CERT.getType()) {
            certInfoUpdateRequest = getCertInfoUpdateRequest(updateType, reason);
            updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.UPDATE_PWD.getType()) {
            updateCertPwd(reason);
        }

    }

    private String getUserInfo() {
        UpdateUserInfoReq userInfoReq = new UpdateUserInfoReq();

        UpdateUserInfo userInfo = new UpdateUserInfo();
        userInfo.setSn(certDetailInfo.getSn());
        userInfo.setTime(System.currentTimeMillis());


        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, userInfo.toString());
        userInfoReq.setInfo(userInfo);
        userInfoReq.setSign(sign);

        ModuleLog.e("获取用户信息： " + userInfoReq.toString());
        service.getUserInfo(userInfoReq, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                int netRes;
                if (!CommonUtil.isNetworkConnected(getContext())) {
                    netRes = R.string.net_disconnected_text;
                } else {
                    netRes = R.string.net_timeout;

                }
//                ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                showException(getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e("获取用户信息结果：" + result);
                if (result.equals("0")) {//获取用户信息成功
                    newDN = commonResponse.getMessage();//签名证书#交换证书
                    ModuleLog.e("新的用户信息：" + newDN);
                }

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                ModuleLog.e("获取用户信息结果errorCode：" + errorCode);
                //需要将状态otto到详情页
            }

            @Override
            public void dismissDialog() {

            }
        });

        return newDN;
    }

    private void updateUserInfoOrDelay(CertInfoUpdateRequest certUpdateRequest) {

        ModuleLog.e("更新用户信息 " + certUpdateRequest.toString());
        service.updateOrDelayCert(certUpdateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                int netRes;
                if (!CommonUtil.isNetworkConnected(getContext())) {
                    netRes = R.string.net_disconnected_text;
                } else {
                    netRes = R.string.net_timeout;

                }
//                            ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                showException(getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e("更新用户信息 result = " + result);
                if (result.equals("0")) {//正在审核
                    //需要将状态otto到详情页
                    ModuleToast.show(getContext(), "等待审核");
                } else if (result.equals("1")) {//更新成功
                    String certStr = commonResponse.getMessage();//签名证书#交换证书
                    //需要将状态otto到详情页
                    ModuleToast.show(getContext(), "证书更新成功");
                } else if (result.equals("2")) {//更新拒绝
                    String msg = commonResponse.getMessage();//拒绝理由
                    //需要将状态otto到详情页
                    ModuleToast.show(getContext(), msg);
                }
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
                //需要将状态otto到详情页
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    private void updateCertPwd(String reason) {
        //更新公私钥对
        UpdateCertPwd updateCertPwd = new UpdateCertPwd();
        updateCertPwd.setSn(certDetailInfo.getSn());
        updateCertPwd.setTime(System.currentTimeMillis());
        updateCertPwd.setReason(reason);
        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, updateCertPwd.toString());


        final UpdateCertPwdReq updateCertPwdReq = new UpdateCertPwdReq();
        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.getSubjectCn(), false);
        updateCertPwdReq.setP10(p10);
        updateCertPwdReq.setSign(sign);
        updateCertPwdReq.setInfo(updateCertPwd);

        ModuleLog.e("更新密钥对 " + updateCertPwdReq.toString());
        service.     updateCertPwd(updateCertPwdReq, cardNum, new HttpResponseCallBack<CertApplyResponse>() {


            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
//网络异常，请重试
                int netRes;
                if (!CommonUtil.isNetworkConnected(getContext())) {
                    netRes = R.string.net_disconnected_text;
                } else {
                    netRes = R.string.net_timeout;
                }
//                            ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                showException(getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String certStr = certApplyResponse.getCert();
                //写卡成功更新状态
                ModuleToast.show(getContext(), "证书更新成功");
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                //需要将状态otto到详情页
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });

    }

    private void showException(final String message) {
        ModuleToast.show(this, message);
    }

    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg(this, errorCode);
        showException(msg);

    }

    private CertInfoUpdateRequest getCertInfoUpdateRequest(String type, String reason) {

        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(certDetailInfo.getSn());
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType(type);//1 证书信息更新   3延期申请
        updateInfo.setReason(reason);
        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.getSubjectCn(), false);
        updateInfo.setP10(p10);

        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, updateInfo.toString());
        final CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        return certUpdateRequest;
    }

    public void reasonIsTemp(UpdateEvent updateEvent) {
        update(updateEvent);
    }

}
