package com.xdja.safeclient.certcreation.bean;

/**
 * Created by gyx on 2018/9/26.
 */

public enum CertState {
    /**
     * 检查中
     */
    CHECKING,
    /**
     * 无证书
     */
    NO_CERT,
    /**
     * 申请等待审核
     */
    WAITING_VERIFY,
    /**
     * 申请失败
     */
    REGISTER_FAIL,
    /**
     * 下载失败
     */
    GET_FAIL,
    /**
     * 证书状态正常
     */
    SUCCESS,
    /**
     * 撤销申请等待中
     */
    WAITING_AGREE_REVOKE,
    /**
     * 撤销成功
     */
    AGREE_REVOKE,
    /**
     * 撤销被拒绝
     */
    REJECT_REVOKE,
    /**
     * 本地有证书，但服务器没有
     */
    SERVER_NOCERT,
    /**
     * 网络异常
     */
    NET_ERROR,

    /**
     * 网络超时
     */
    NET_TIMEOUT,

    /**
     * 证书更新成功
     */
    AGREE_UPDATE,
    /**
     * 证书已删除
     */
    DELETE_SUCCESS,
    /**
     * 证书已过期
     */
    CERT_OUT_OF_DATE,
    /**
     * 解冻成功
      */
    RECOVERY_SUCCESS,
    /**
     * 解冻受理中
     */
    RECOVERY_PROGRESS

}
