package com.xdja.safeclient.certcreation.bean.device;

import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.cryptodev.CryptoDevType;

import java.util.ArrayList;
import java.util.List;

import static com.xdja.cryptodev.CryptoDevType.DEV_TYPE_Chip;
import static com.xdja.cryptodev.CryptoDevType.DEV_TYPE_SdCard;
import static com.xdja.cryptodev.CryptoDevType.DEV_TYPE_SimKey;
import static com.xdja.cryptodev.CryptoDevType.DEV_TYPE_Soft;

/**
 * Created by Administrator on 2019/8/30 0030.
 */

public class CardType {

    public static final String CHIP = "内置安全芯片";

    public static final String SIM_CARD = "智能薄膜卡";

    public static final String TF_CARD = "TF卡";

    public static final String ONLINE_VHSM = "VHSM";

    public static final String OFFLINE_VHSM = "离线VHSM";

    public static final String REQUEST_PARAM_ONLINE_VHSM = "1";


    private static final List<ConfigBean> list = new ArrayList<>();

    private static final List<ConfigBean> noVHSMList = new ArrayList<>();

    static {
        list.add(new ConfigBean(CHIP));
        list.add(new ConfigBean(SIM_CARD));
        list.add(new ConfigBean(TF_CARD));
        list.add(new ConfigBean(ONLINE_VHSM));

        noVHSMList.add(new ConfigBean(CHIP));
        noVHSMList.add(new ConfigBean(SIM_CARD));
        noVHSMList.add(new ConfigBean(TF_CARD));

    }

    public static String toString(CryptoDevType card) {

        switch (card) {

            case DEV_TYPE_Chip:

                return CHIP;

            case DEV_TYPE_SimKey:

                return SIM_CARD;

            case DEV_TYPE_SdCard:

                return TF_CARD;

            case DEV_TYPE_Soft:

                return CardType.ONLINE_VHSM;


            default:

                return "";
        }

    }

    public static CryptoDevType toType(String card) {
        switch (card) {

            case CHIP:

                return DEV_TYPE_Chip;

            case SIM_CARD:

                return DEV_TYPE_SimKey;

            case TF_CARD:

                return DEV_TYPE_SdCard;

            case ONLINE_VHSM:

                return DEV_TYPE_Soft;

            case OFFLINE_VHSM:


                return DEV_TYPE_Soft;

            default:

                return null;

        }
    }
    public static List<ConfigBean> getList() {
        return list;
    }

    public static List<ConfigBean> getNoVHSMList() {
        return noVHSMList;
    }
}
