package com.xdja.safeclient.certcreation.device;

import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.safeclient.certcreation.config.XDJAAlgParams;

/**
 * Created by jff on 2018/11/14.
 */

public class AlgSignUtils {

    private static AlgSignUtils algSignUtils;

    public AlgSignUtils() {

    }

    public static AlgSignUtils getAlgSignUtils() {
        if (algSignUtils == null) {
            algSignUtils = new AlgSignUtils();
        }
        return algSignUtils;
    }


    public int verifySM2Sign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return -1;
        }

        try {
            byte[] bs = sourceData.getBytes();


            byte[] pubFid = new byte[]{0x00, 0x2D};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            if (cryptoInstance != null) {
                return cryptoInstance.SM2SignVerify(pubFid, 1, null, bs, bs.length, signData);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return -1;
    }


    private void verifyRSASign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return;
        }

        try {
            byte[] bs = sourceData.getBytes();


            byte[] pubFid = new byte[]{0x00, 0x2D};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.RSASignVerify(XDJAAlgParams.RSA_KEY_LEN_1024, pubFid, null, 1, bs, bs.length, signData);

            }
            ModuleLog.d("验签结果： = " + ret);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
