package com.xdja.safeclient.certcreation.device;

import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.config.XDJAAlgParams;

/**
 * Created by jff on 2018/11/14.
 */

public class PKCS10Utils {

    private static PKCS10Utils pkcs10Utils = new PKCS10Utils();

    public static PKCS10Utils getInstance(CryptoDevType type, int containerNum) {
        String alg = AppConfig.getInstance().getCertConfig().getAlgType(type, containerNum);
        if (alg.equals(XDJAAlgParams.CA_ALG_RSA)) {
            pkcs10Utils = PKCS10ForRSAUtils.getInstance();
        } else {
            pkcs10Utils = PKCS10ForSM2Utils.getInstance();
        }
        return pkcs10Utils;
    }


    public String getP10RequestBC(CryptoDevType type, int containerNum, String dn, boolean isApplyCert) {
        return "";
    }

    public PKCS10Utils() {

    }

}
