package com.xdja.safeclient.certcreation.util;


import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Base64;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Created by zjc on 2018/6/7 0007.
 */

public class Base64Util {

    // 解决7.0以上读取文件有误的问题
//    https://blog.csdn.net/zengxianzi/article/details/73555698

    /**
     * 将文件转为Base64后的字符串
     *
     * @return
     */
    public static String fromFile(Context context, Uri uri) {
        return Base64.encodeToString(fileToBytes(context, uri), 0);
    }


    /**
     * 将文件专程byte数组
     *
     * @return
     */
    public static byte[] fileToBytes(Context context, Uri uri) {

        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (uri != null) {
            FileInputStream fis = null;
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {

                    //获取ParcelFileDescriptor对象，"rw"代表可读写，"r"代表只读
                    ParcelFileDescriptor pfd = context.getContentResolver().openFileDescriptor(uri, "rw");

                    //获取FileDescriptor对象
                    if (pfd != null) {
                        FileDescriptor fd = pfd.getFileDescriptor();
                        //获取文件输入输出流，这样我们就可操作共享文件了
                        fis = new FileInputStream(fd);

                    }

                } else {
                    fis = new FileInputStream(uri.getPath());
                }

                if (fis != null) {
                    byte[] buffer = new byte[1024 * 4];

                    int len;
                    while ((len = fis.read(buffer)) != -1) {
                        byteArrayOutputStream.write(buffer, 0, len);
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (fis != null) {
                    try {
                        fis.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

        }
        return byteArrayOutputStream.toByteArray();
    }

    /**
     * 将base64存储到本地
     *
     * @param base64
     * @param dstFile
     * @author sushi
     */
    public static void CopyBase64ToFile(String base64, File dstFile) {
        OutputStream out = null;
        try {
            out = new FileOutputStream(dstFile);
            out.write(Base64.decode(base64, Base64.NO_WRAP));
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }

    /*public static boolean GenerateImage(String imgStr) {
        if (imgStr == null) // 图像数据为空
            return false;
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            // Base64解码
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] < 0) {// 调整异常数据
                    b[i] += 256;
                }
            }
            // 生成jpeg图片
            String imgFilePath = "d://222.jpg";
            OutputStream out = new FileOutputStream(imgFilePath);
            out.write(b);
            out.flush();
            out.close();
            return true;
        } catch (Exception e) {
            return false;
        }
    }*/

}
