package com.xdja.safeclient.certcreation.util;

import android.app.AlertDialog;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Window;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.DepartmentListAdapter;
import com.xdja.safeclient.certcreation.adapter.ProfessionListAdapter;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.ProfessionJobTitle;
import com.xdja.safeclient.certcreation.event.ProfessionPerson;
import com.xdja.safeclient.certcreation.event.ProfessionRank;
import com.xdja.safeclient.certcreation.event.ProfessionType;

import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

/**
 * Created by zjc on 2018/6/13 0013.
 */
public class DialogUtil {

    public static final int PERSON = 0;
    public static final int RANK = PERSON + 1;
    public static final int TYPE = RANK + 1;
    public static final int JOB_TITLE = TYPE + 1;

    public interface DialogInterface {
        void onSuccess(Object... objects);
    }

    /**
     * 用于弹出选择人员类型、职务、警种和级别的列表框
     *
     * @param context
     * @param dataSource
     * @param TAG
     */
    public static void popSpinnerList(Context context, final List<? extends ProfessionBean> dataSource, final int TAG) {

        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView) window.findViewById(R.id.gateway_list);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager(layoutManager);

        final ProfessionListAdapter adapter = new ProfessionListAdapter(context);
        adapter.setOnItemClickListener(new ProfessionListAdapter.OnItemClickListener() {
            @Override
            public void onItemSelected(int position) {

                if (TAG == TYPE) {
                    OttoUtil.chooseProfession(new ProfessionType(position));
                } else if (TAG == JOB_TITLE) {
                    OttoUtil.chooseProfession(new ProfessionJobTitle(position));
                } else if (TAG == PERSON) {
                    OttoUtil.chooseProfession(new ProfessionPerson(position));
                } else if (TAG == RANK) {
                    OttoUtil.chooseProfession(new ProfessionRank(position));
                }

                dialog.cancel();
            }
        });
        adapter.setDataSource(dataSource);
        recyclerView.setAdapter(adapter);
        dialog.setCancelable(true);

    }

    /**
     * 用于弹出部门的列表框
     *
     * @param context
     * @param dataSource
     */
    public static void popSpinnerList(Context context, final List<ProfessionDepartment> all, final List<ProfessionDepartment> dataSource) {

        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.show();
        dialog.setContentView(R.layout.common_dialog_list);
        Window window = dialog.getWindow();
        RecyclerView recyclerView = (RecyclerView) window.findViewById(R.id.gateway_list);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager(layoutManager);

        final DepartmentListAdapter adapter = new DepartmentListAdapter(context);
        adapter.setOnItemClickListener(new DepartmentListAdapter.OnItemClickListener() {
            @Override
            public void onItemSelected(int position) {

                // TODO: 2018/6/13 0013 CollectionUtils是Apache包中的方法，为了操作集合引入一个包太浪费
                // FIXME: 2018/6/13 0013 下面的removeAll暂时有个Bug，选择完后再选择发现列表为空，之后优化和修复此处
                List<ProfessionDepartment> rest = (List<ProfessionDepartment>) CollectionUtils.subtract(all, dataSource);
//                all.removeAll(dataSource);

                OttoUtil.chooseDepartment(dataSource.get(position), rest);
                dialog.cancel();
            }
        });
        adapter.setDataSource(dataSource);
        recyclerView.setAdapter(adapter);
        dialog.setCancelable(true);

    }



    public static void install(Context context, String message, final DialogInterface result) {
        /*final AlertDialog dialog = new AlertDialog.Builder(new ContextThemeWrapper(context, R.style.DialogTheme)).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);

        View view = LayoutInflater.from(context).inflate(R.layout.gateway_delete_dialog, null, false);
        dialog.setView(view);


        TextView title = (TextView) view.findViewById(R.id.dg_delete_title);
        title.setText(message);

        Button positive = (Button) view.findViewById(R.id.dialog_positive);
        positive.setText(R.string.confirm);
        positive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
                result.onSuccess();
            }
        });

        Button negative = (Button) view.findViewById(R.id.dialog_negative);
        negative.setText(R.string.cancel);
        negative.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
            }
        });

        dialog.setCancelable(true);

        dialog.show();*/
    }






}
