package com.xdja.safeclient.certcreation.util;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;

import java.util.Date;

/**
 * Created by yangpeng on 2018/5/3.
 */

public class Util {

    /**
     * 数组转换成十六进制字符串
     *
     * @return
     */
    public static String bytesToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }

        return sb.toString();
    }


    /**
     * 判断证书是否在有效期内
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     * @return true 有效; false 过期
     */
    public static boolean certIsValid(CertDetailInfo info) {


        Date dataStart = info.getNotBeforeData();
        Date dataEnd = info.getNotAfterData();

        Date currentDate = new Date();

        return (currentDate.getTime() - dataStart.getTime() <= 5 * 60 * 1000 || dataStart.getTime() - currentDate.getTime() <= 5 * 60 * 1000) &&
                currentDate.before(dataEnd);

    }


    /**
     * 证书有效期将至（距离失效小于15天）
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     */
    public static boolean certValidIsExpire(CertDetailInfo info) {

        Date dataEnd = info.getNotAfterData();

        Date currentDate = new Date();

        ModuleLog.e("currentDate = " + currentDate.toString());
        ModuleLog.e("currentDate.getTime() = " + currentDate.getTime());
        ModuleLog.e("dataEnd.getTime() = " + dataEnd.getTime());

        return certIsValid(info) && (dataEnd.getTime() - currentDate.getTime() < 15 * 24 * 60 * 60 * 1000);
    }


}
