package ocr.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;

import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.fastjson.JSON;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.a3rdplugin.demo.event.IDCardTailResult;
import com.xdja.a3rdplugin.demo.ocr.XDJAOCR;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.BasicInfoActivity;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.event.InvokeXDJAOCREvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.DialogUtil;
import com.xdja.safeclient.certcreation.util.IntentUtil;

import ocr.bean.IDCardInfo;

import static com.xdja.a3rdplugin.demo.activity.ANRONGOCRActivity.AN_RONG_PACKAGE_NAME;
import static com.xdja.safeclient.certcreation.activity.ActivityPath.ACTIVITY_CHOOSE_IDENTIFY_TYPE;


/**
 * Created by yangpeng on 2018/3/21.
 */

@Route(name = ActivityPath.NAME_CHOOSE_IDENTIFY_TYPE, path = ACTIVITY_CHOOSE_IDENTIFY_TYPE)
public class ChooseBindWayActivity extends BaseActivity {

    public static final int REQUEST_XDJA_OCR = 11;

    private String name;
    private String sex;
    private String birthDay;
    private String nation;
    private String address;
    private String idNum;

    private String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

    private String ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany();

    @Autowired(name = ActivityParam.CONTAINER_NUM)
    public int containerNum;

    //@Autowired(name = FACE_IMG)
    private String faceImg = "";

    @Override
    protected boolean hasActionBar() {
        return true;
    }

    @Override
    protected int getToolbarType() {
        return ToolBarActivity.ToolBarDef.NAVIGATE_BACK;
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_choose_way;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.choose_idenfity_way);

        // ARouter.getInstance().inject(this);

        cardType = IntentUtil.getCardType(getIntent());
        cardNo = IntentUtil.getCardNum(getIntent());
        phone = IntentUtil.getPhone(getIntent());

        onBindView();

        if (AppConfig.getInstance().getServerSettingConfig().getProcedure()
                .equals(Procedure.STD_NO_NFC)) {
            gotoBasicInfoActivity();
        }

        init();

        if (ocrCompany.equals(OCRCompany.XDJA)) {
            if (!XDJAOCR.isInstall(this)) {
                XDJAOCR.copyFile(this);
            } else if (!XDJAOCR.isVersionOK(this)) {
                XDJAOCR.copyFile(this);
            }
        }


    }

    @Override
    protected void getData() {
        super.getData();
        faceImg = ImageCache.getInstance().getSelfie();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);

        /*faceImg = getIntent().getStringExtra(FACE_IMG);*/


    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (getClass().getName().equals(activity.getTag())) {
            finish();
        }
    }


    private CryptoDevType cardType;
    private String cardNo;
    private String phone;


    private void init() {
        final RelativeLayout iv_nfc = (RelativeLayout) findViewById(R.id.layout_nfc);
        final RelativeLayout iv_ocr = (RelativeLayout) findViewById(R.id.layout_ocr);
        final RelativeLayout iv_manual_input = (RelativeLayout) findViewById(R.id.layout_manual_input);

        iv_nfc.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoNFC();
            }
        });

        iv_ocr.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoOCR();
            }
        });


        iv_manual_input.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoBasicInfoActivity();
            }
        });


        iv_ocr.setVisibility(View.GONE);
        iv_nfc.setVisibility(View.GONE);
        iv_manual_input.setVisibility(View.GONE);


        if (!procedure.equals(Procedure.STD_NO_OCR)) {
            iv_ocr.setVisibility(View.VISIBLE);
        }

        if (!procedure.equals(Procedure.STD_NO_NFC)) {
            iv_nfc.setVisibility(View.VISIBLE);
        }


        if (AppConfig.getInstance().getServerSettingConfig().getProcedure()
                .equals(Procedure.STD_NO_OCR)) {
            iv_manual_input.setVisibility(View.VISIBLE);
        }

        if (ocrCompany.equals(OCRCompany.BAIDU)) {
            /**
             * 初始化百度配置
             */
        }


    }

    /**
     * 跳转至基本信息页面
     */
    private void gotoBasicInfoActivity() {
        Intent intent = new Intent(ChooseBindWayActivity.
                this, BasicInfoActivity.class);
        intent = IntentUtil.putInfo(intent, cardType, cardNo);
        intent = IntentUtil.putPhone(intent, phone);
        Bundle bundle = new Bundle();
//        bundle.putString(FACE_IMG, faceImg);
        bundle.putInt(ActivityParam.CONTAINER_NUM, containerNum);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }


    private void gotoOCR() {
        doIdentify(false);
    }

    private void onBindView() {
        Bundle bundle = getIntent().getExtras();
        if (bundle != null && bundle.containsKey(FACE_IMG)) {
            faceImg = bundle.getString(FACE_IMG);
        }
    }

    private void gotoNFC() {
        doIdentify(true);
    }

    @SuppressLint("StringFormatMatches")
    private void doIdentify(boolean isNFC) {

        //modify 2018年1月8日14:45:13 weizg 在线解锁新增nfc识别身份证功能
        if (isNFC) {

            String nfcCompany = AppConfig.getInstance().getServerSettingConfig().getNfcCompany();

            switch (nfcCompany) {
                case NFCCompany.XDJA:
                    //                    startActivity(new Intent(this, XDJANFCActivity.class));
                    Intent intentXdja = new Intent(this, XDJANFCActivity.class);
                    Bundle othersXdja = new Bundle();
//                    othersXdja.putString(FACE_IMG, faceImg);
                    othersXdja.putInt(ActivityParam.CONTAINER_NUM, containerNum);
                    intentXdja.putExtras(othersXdja);
                    startActivity(intentXdja);
                    break;

                case NFCCompany.YISHU:

                    //                    Intent intent = new Intent("com.xdja.yishunfc");
                    //                    Bundle bundle = new Bundle();
                    //                    bundle.putString(FACE_IMG, faceImg);
                    //                    intent.putExtras(bundle);
                    //                    sendBroadcast(intent);

                    // TODO: 2020/5/14 0014 因为变种的问题没有解决，所以现在不同地市
                    // 用不同的类名区分，jar和so的冲突问题暂时不解决

                    Intent intent = new Intent(this, XiZangYishuNFCActivity.class);
                    Bundle bundle = new Bundle();
                  /*  if (faceImg == null) {
                        faceImg = ImageCache.getInstance().getSelfie();
                    }
                    bundle.putString(FACE_IMG, faceImg);*/
                    bundle.putInt(ActivityParam.CONTAINER_NUM, containerNum);
                    intent.putExtras(bundle);
                    startActivity(intent);

                    break;
            }
        } else {

            String ocrCompany = AppConfig.getInstance().getServerSettingConfig().getOcrCompany();

            switch (ocrCompany) {
                case OCRCompany.ANRONG:

                    // OCR未安装
                    if (!ANRONGOCRActivity.isApplicationInstalled(this, AN_RONG_PACKAGE_NAME)) {
                        showAnrongDialog(getString(R.string.not_install_anrong_ocr));
                        return;
                    }

                    // 已安装的OCR版本不对
                    if (!ANRONGOCRActivity.isVersionOK(this)) {
                        String targetVersion = "1.8";
                        String currentVersion = ANRONGOCRActivity.getVersion(this, AN_RONG_PACKAGE_NAME);
                        showAnrongDialog(String.format(getString(R.string.wrong_ocr_version_1), targetVersion, currentVersion));
                        return;
                    }

                    OCRCompany.ANRONG(this, OCRCompany.HEAD);
                    break;

                case OCRCompany.XDJA:

                    startXDJAOCR();

                    break;

                case OCRCompany.YUNCONG:

                    if (BuildConfig.isAAR || DEBUG_AAR) {

                        Intent intent = new Intent(this, OcrActivity.class);
//                        intent.putExtra(FACE_IMG, faceImg);
                        intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
                        startActivity(intent);

                    } else {

                        ARouter.getInstance()
                                .build(ActivityPath.ACTIVITY_YUNCONG_OCR)
//                                .withString(FACE_IMG, faceImg)
                                .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                                .navigation(this);
                    }


                    break;
                default:
                    break;

            }

        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        ModuleLog.e("requestCode: " + requestCode);
        ModuleLog.e("resultCode: " + resultCode);

        if (resultCode == Activity.RESULT_OK) {

          /*  if (requestCode == REQUEST_CODE_CAMERA) {

                if (data != null) {
                    String contentType = data.getStringExtra(CameraActivity.KEY_CONTENT_TYPE);
                    String filePath = FileUtil.getSaveFile(getApplicationContext()).getAbsolutePath();
                    if (!TextUtils.isEmpty(contentType)) {
                        if (CameraActivity.CONTENT_TYPE_ID_CARD_FRONT.equals(contentType)) {
                            recIDCard(ID_CARD_SIDE_FRONT, filePath);
                        } else if (CameraActivity.CONTENT_TYPE_ID_CARD_BACK.equals(contentType)) {
                            recIDCard(IDCardParams.ID_CARD_SIDE_BACK, filePath);
                        }
                    }
                }

            } else */
            if (requestCode == REQUEST_XDJA_OCR) {

                // FIXME: 2019/12/24 0024 这个需要改成单面流程

                String json = data.getStringExtra("json");//json字符串，所有信息

                ModuleLog.e(json);

                if (json.contains("blzd")) {

                    // FIXME: 2019/12/25 0025 判断异常流程
                    IDCardHeadResult result = JSON.parseObject(json, IDCardHeadResult.class);

                    if ((result.getXb().equals("男"))
                            || result.getXb().equals("女")
                    ) {
                        testXDJAOCRForward(result);
                    } else {
                        // 扫描的是反面，跳转到错误界面
                        testXDJAErrorForward();
                    }
                }

            }

        }

    }

    private void testXDJAOCRForward(IDCardHeadResult result) {

        // 现在需要三个参数姓名、性别、身份证号

        if (BaseActivity.DEBUG_AAR) {
            Intent intent = new Intent(this, XDJAOCRIDCardActivity.class);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            intent.putExtra(ActivityParam.NAME, result.getMz());
            intent.putExtra(ActivityParam.GENDER, result.getXb());
            intent.putExtra(ActivityParam.ID_NUM, result.getSfzh());
            intent.putExtra(ActivityParam.FACE_IMG, faceImg);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(ActivityPath.ACTIVITY_XDJA_OCR_ID_CARD)
                    .withInt(ActivityParam.CONTAINER_NUM, containerNum)
                    .withString(ActivityParam.NAME, result.getXm())
                    .withString(ActivityParam.GENDER, result.getXb())
                    .withString(ActivityParam.ID_NUM, result.getSfzh())
                    .withString(ActivityParam.FACE_IMG, faceImg)
                    .navigation(this);
        }

    }

    private void testXDJAErrorForward() {
        Intent intent = new Intent(this, XDJAOCRFailActivity.class);
        startActivity(intent);
    }


    /**
     * 显示对话框，点确定跳转到应用商店
     */
    private void showAnrongDialog(String text) {

        DialogUtil.install(this, text, new DialogUtil.DialogInterface() {
            @Override
            public void onSuccess(Object... objects) {
                ANRONGOCRActivity.goToAppStore(getContext());
            }
        });


    }

    public static Intent buildIntent(Context context, int containerNum, String faceImg) {
        Intent intent = new Intent(context, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(FACE_IMG, faceImg);
        bundle.putInt(ActivityParam.CONTAINER_NUM, containerNum);
        intent.putExtras(bundle);
        return intent;
    }

    private IDCardInfo id = new IDCardInfo();

    @Override
    protected boolean setDialogCancelable() {
        // 读取身份证时的滚动条不允许按返回取消
        return false;
    }

    @Subscribe
    public void handleIDCardHeadResult(IDCardHeadResult result) {

        if (id == null) {
            id

                    = new IDCardInfo();
        }

        id.setName(result.getXm());
        id.setSex(result.getXb().equals("男") ? 1 : 2);
        id.setBirthDate(result.getCsrq());
        id.setNation(result.getMz());
        id.setAddr(result.getCsdz());
        id.setIdNum(result.getSfzh());
        // 天津现场的测试数据
        //        id.setIdNum("120101198403070018");
        //目前安荣和XDJA的OCR都是没有照片的，安荣传空串，服务器通过空串来区分是OCR还是NFC
//        id.setPhoto("");

        //        ModuleLog.d(result);

        next();

    }

    @Subscribe
    public void handleIDCardTailResult(IDCardTailResult result) {

        id.setIssueOffice(result.getDepartment());
        id.setValidDate(result.getValidDate());

        next();

    }

    @Subscribe
    public void handleFinishChooseEvent(FinishChooseEvent event) {
        finish();
    }

    /**
     * 扫描身份证
     * todo 这个仅适用于安荣，调用的地方需要判断下分支
     *
     * @param side 正反面
     */
    private void scan(final int side) {
        // 识别完正面之后是需要识别反面的，因为安荣每次调用时都需要初始化图像识别库
        // 两次调用间隔果断会导致上一次资源未释放（此时会出现识别失败，并且一直失败）
        // 所以在这个地方加上一个等待时间
        showLoading();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                dismissLoading();
                OCRCompany.ANRONG(getContext(), side);
            }
        }, 2000);
    }

    /**
     * 两面都读的情况下跳转到下个界面
     * 否则读取另一面
     */
    @Override
    public void next() {
        if (!TextUtils.isEmpty(faceImg) && id != null) {

            if (TextUtils.isEmpty(id.getName())) {

                // 除了安荣外似乎不会出现
                if (ocrCompany.equals(OCRCompany.ANRONG)) {
                    // 姓名为空意味着正面没拍
                    scan(OCRCompany.HEAD);
                    return;
                }
            }

            if (TextUtils.isEmpty(id.getIssueOffice())) {
                // 签发机关为空意味着反面没拍

                if (ocrCompany.equals(OCRCompany.ANRONG)) {
                    scan(OCRCompany.TAIL);
                }

                return;
            }

            if (ocrCompany.equals(OCRCompany.ANRONG)) {
                Bundle others = new Bundle();
                others.putString(FACE_IMG, faceImg);
                others.putParcelable(IDENTIFY_INFO, id);
                Intent intent = new Intent(this, AnrongOCRIDActivity.class);
                intent.putExtras(others);
                startActivity(intent);
            } else if (ocrCompany.equals(OCRCompany.XDJA)) {

                // FIXME: 2019/12/24 0024

                Bundle others = new Bundle();
                others.putString(FACE_IMG, faceImg);

                others.putParcelable(IDENTIFY_INFO, id);


                Intent intent = new Intent(this, XDJAOCRIDCardActivity.class);
                others.putInt(ActivityParam.CONTAINER_NUM, containerNum);
                intent.putExtras(others);
                startActivity(intent);

            }


        }
    }

    @Subscribe
    public void handleClearID(ClearIDEvent event) {
        // 清空已经读到的身份证信息
        id = null;
        id = new IDCardInfo();
    }


    @Override
    protected boolean isOCRActivity() {
        return true;
    }

    @Subscribe
    public void handleChooseBindway(ChooseBindwayEvent event) {
        finish();
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    @Subscribe
    public void handleInvokeXDJAOCREvent(InvokeXDJAOCREvent event) {
        startXDJAOCR();
    }

    private void startXDJAOCR() {

        if (XDJAOCR.isInstall(this)) {

            if (XDJAOCR.isVersionOK(this)) {

                try {

                    Intent intent = new Intent(XDJAOCR.ACTION);
                    intent.putExtra(XDJAOCR.PARAM_PACKAGE_NAME, getPackageName());
                    intent.putExtra(XDJAOCR.PARAM_ID_CARD, XDJAOCR.HEAD);
                    startActivityForResult(intent, REQUEST_XDJA_OCR);

                } catch (Exception e) {
                    com.xdja.a3rdplugin.demo.ModuleToast.show(this, com.xdja.a3rdplugin.R.string.not_install_xdja_ocr);
                }

            } else {
                showInstallOCRDialog();
            }


        } else {
            showInstallOCRDialog();
        }

    }

    private void showInstallOCRDialog() {

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this);

        bindIdentifyDialog.setTitle(R.string.cert_creation_install_confirm_notice);
        bindIdentifyDialog.setMessage(R.string.cert_creation_install_message);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                if (XDJAOCR.apkFileExist()) {
                    XDJAOCR.install(getContext(), BuildConfig.isAAR);
                    bindIdentifyDialog.dismiss();
                } else {
                    XDJAOCR.copyFileTellMe(getContext());
                    bindIdentifyDialog.dismiss();
                }


            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
            }
        });

    }

    @Subscribe
    public void handleOCREvent(XDJAOCR event) {
        // 信大捷安OCR安装成功 且需要安装
        XDJAOCR.install(this, BuildConfig.isAAR);
    }

}
