package ocr.activity;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.IOException;

import ocr.bean.IDCardInfo;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;


/**
 * 身份证界面展示Activity
 * 至于每种方式的不同可以继承此界面并重写
 * Created by yangpeng on 2018/3/22.
 */
@Route(name = ActivityPath.NAME_XDJA_ID_RESULT, path = ActivityPath.ACTIVITY_XDJA_ID_RESULT)
public abstract class IDCardActivity extends BaseActivity {

    @Autowired(name = "identify_info")
    public IDCardInfo info;
    /**
     * 活体识别人脸的照片
     */
    @Autowired(name = "faceImg")
    public String faceImg;

    @Autowired(name = CONTAINER_NUM)
    public int containerNum;

    @Override
    protected int getToolbarType() {
        return super.getToolbarType();
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    private static final String IDENTIFY_INFO = "identify_info"; //传过来身份信息key

    protected Bitmap faceBitmap;

    private TextView nameTv;
    private TextView genderTv;
    private TextView nationTv;
    private TextView dataTv;
    private TextView adressTv;
    private TextView bornIDTv;
    private ImageView photoImg;
    private TextView srcGovTv;
    private TextView userTimeTv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_result);
        initView();
        getData();
        initIDFace();
        setData();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        info = getIntent().getParcelableExtra(IDENTIFY_INFO);
//        faceImg = getIntent().getStringExtra(FACE_IMG);
        faceImg = ImageCache.getInstance().getSelfie();
        containerNum = getIntent().getIntExtra(CONTAINER_NUM, containerNum);

    }

    @Override
    protected int setLoadingText() {
        return R.string.cert_creation_face_comparing;
    }


    /**
     * 初始化身份证照片
     */
    public void initIDFace() {

    }

    public void getData() {
        Bundle others = getIntent().getExtras();

        //底下几行代码测试使用，请勿删 gyx
        //        String frontPath = "/storage/emulated/0/best.jpg";
        //        byte[] imgData = ImgUtil.bitmapToByte(ImgUtil.getBitmapByPath(frontPath), Bitmap.CompressFormat.JPEG,  Contants.JPG_QUALITY);
        //        faceImg =  Base64Util.encode(imgData);

        if (others != null && others.containsKey(IDENTIFY_INFO)) {
            info = others.getParcelable(IDENTIFY_INFO);
        }

        if (others != null && others.containsKey(FACE_IMG)) {
            faceImg = others.getString(FACE_IMG);
        }

        if (others != null) {
            containerNum = others.getInt(ActivityParam.CONTAINER_NUM);
        }


    }

    protected void setData() {
        if (info != null) {
            showIdentifyInfo(info);
        }
    }


    /**
     * 身份证信息不对
     * 重新扫描
     */
    public void rescan() {

    }

    /**
     * 下一步，实体认证
     */
    public void next() {

        if (info != null) {
            request();
        }

    }

    private void initView() {
        nameTv = findViewById(R.id.name);
        genderTv = findViewById(R.id.gender);
        nationTv = findViewById(R.id.nation);
        dataTv = findViewById(R.id.data);
        adressTv = findViewById(R.id.adress);
        bornIDTv = findViewById(R.id.bornId);
        photoImg = findViewById(R.id.photo);


        srcGovTv = findViewById(R.id.SrcGov);
        userTimeTv = findViewById(R.id.UserTime);


        Button btn_next = (Button) findViewById(R.id.btn_next);
        btn_next.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                next();
            }
        });

        Button btn_again = (Button) findViewById(R.id.btn_again);
        btn_again.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                rescan();
            }
        });

    }


    private void showIdentifyInfo(IDCardInfo info) {
        setData(info);
    }

    private void setData(IDCardInfo cardInfo) {
        if (cardInfo.getName() == null) {
            return;
        }
        String gender = "男";
        if (cardInfo.getSex() == 2) {
            gender = "女";
        }


        nameTv.setText(cardInfo.getName());
        genderTv.setText(gender);
        nationTv.setText(cardInfo.getNation());
        //出生年
        String year = "";
        //出生月
        String month = "";
        //出生日
        String day = "";
        String date = cardInfo.getBirthDate();
        if (date.length() == 8) {
            //亿数的格式是19990802共八位
            year = date.substring(0, 4);
            month = date.substring(4, 6);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            day = date.substring(6, 8);
            if (day.substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        } else {
            year = date.substring(0, 4);
            month = date.substring(5, 7);
            if (month.substring(0, 1).equals("0")) {
                month = month.substring(1, month.length());
            }
            day = date.substring(8, 10);
            if (day.substring(0, 1).equals("0")) {
                day = day.substring(1, day.length());
            }
        }
        dataTv.setText(year + "        " + month + "      " + day);
        adressTv.setText(cardInfo.getAddr());
        bornIDTv.setText(cardInfo.getIdNum());
        photoImg.setImageBitmap(changeBitmapSize(faceBitmap));


        String[] info2 = {cardInfo.getIssueOffice(), cardInfo.getValidDate()};
        srcGovTv.setText(info2[0]);
        userTimeTv.setText(info2[1]);


    }

    /**
     * 修改图片尺寸
     *
     * @param bitmap
     * @return
     */

    private Bitmap changeBitmapSize(Bitmap bitmap) {
        if(bitmap == null){
            bitmap = ImageCache.getInstance().getNfcFaceImg();
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();

        //原图尺寸为102*126,现放大为148*182

        //所以长和宽比例分别为1.45  1.44

        float radioW = 148.0f / w;
        float radioH = 182.0f / h;

        Matrix matrix = new Matrix();
        matrix.postScale(radioW, radioH);  //长和宽放大缩小的比例
        return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
    }


    /**
     * 开始上传数据进行比对
     */
    private void request() {

        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(this, R.string.cert_creation_card_device_error);
            return;
        }

        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = buildRequest();

        showLoading();

        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
                compareResult.setResult("");
                compareResult.setMessage(getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(info.getIdNum());
                //                AuthResult auth = new AuthResult(currentChipBeanType, compareResult);
                //                OttoUtil.postAuthResult(auth);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(info.getIdNum());
                verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //                ModuleLog.e("认证返回结果code= " + commonResponse.getResult());

                SharePreferencesUtil.saveIDCardNo(getContext(), devType, info.getIdNum());

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(info.getIdNum());
                compareResult.setSuccess(true);

                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有
                    verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }
                OttoUtil.postFinishActivity();
                OttoUtil.postFinishYishuNFC();
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //                ModuleLog.e("认证失败");
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(info.getIdNum());
                compareResult.setSuccess(false);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra("result", result);
            intent.putExtra("devType", type);
            intent.putExtra("identify_info", info);
//            intent.putExtra("faceImg", faceImg);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);
        } else {
            ARouter.getInstance()
                    .build(ActivityPath.ACTIVITY_AUTH_FAIL)
                    .withSerializable("result", result)
                    .withSerializable("devType", type)
                    .withParcelable("identify_info", info)
//                    .withString("faceImg", faceImg)
                    .withInt(CONTAINER_NUM, containerNum)
                    .navigation(this);
        }


    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
        //        ModuleLog.e("实体验证  卡类型 " + Util.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));


        String imsi = deviceWrapper.getIMSI();
        //        ModuleLog.e("imsi = " + imsi);
        //        if (TextUtils.isEmpty(imsi)) {
        ////            ModuleToast.show(this, "获取imsi失败，请确认SIM卡插入正常");
        ////            ModuleLog.e("请确认SIM卡插入正常");
        //
        //            return null;
        //        }
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this));

        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM)
        ) {
            chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
            chipInfo.setImei(NetVhsmDeviceIdUtils.getDevId(this));
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }

       info.setPhoto(ImageCache.getInstance().getNfcFaceImgStr());
        request.setIdCardInfo(info);


        request.setChipInfo(chipInfo);
        if(faceImg == null){
            faceImg = ImageCache.getInstance().getSelfie();
        }
        request.setFaceImg(faceImg);

        final int type = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);

        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));
        //        Log.e("jff","实体认证： " + request.toString());

        ModuleLog.e(request.toString());

        return request;

    }

}
