package ocr.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.xdja.safeclient.certcreation.bean.response.CommonResponse;

/**
 * 解析身份证信息响应bean
 * <br>author: wzg@xdja.com <br/>
 * date:   2017/11/9 14:22 <br/>
 */

public class IDCardInfo extends CommonResponse implements Parcelable {
    /*
    {
"name":"张三", //姓名
"sex": 1, //性别，1-男，2-女
"birthDate": "1990-02-16", //出生年月
"nation":"汉", //民族
"addr": "河南省周口市川汇区泛区新建五路100号", //住址
"idNum": "412722199202168759", //身份证号
"issueOffice": "周口市公安局泛区分局", //签发机关
"validDate": "2009.09.04-2019.09.04",//有效日期
"photo": "LKSJDFKLJKLJADF=="//照片Base64字符串
}
     */

    private String name = "";
    /**
     * 男是1，女是2
     */
    private int sex;
    private String birthDate = "";
    private String nation = "";
    private String addr = "";
    private String idNum = "";

    private String issueOffice = "";
    private String validDate = "";

    private String photo = "";


    protected IDCardInfo(Parcel in) {
        name = in.readString();
        sex = in.readInt();
        birthDate = in.readString();
        nation = in.readString();
        addr = in.readString();
        idNum = in.readString().toUpperCase();
        issueOffice = in.readString();
        validDate = in.readString();
        photo = in.readString();
    }

    public IDCardInfo() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(name);
        dest.writeInt(sex);
        dest.writeString(birthDate);
        dest.writeString(nation);
        dest.writeString(addr);
        dest.writeString(idNum);
        dest.writeString(issueOffice);
        dest.writeString(validDate);
        dest.writeString(photo);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<IDCardInfo> CREATOR = new Creator<IDCardInfo>() {
        @Override
        public IDCardInfo createFromParcel(Parcel in) {
            return new IDCardInfo(in);
        }

        @Override
        public IDCardInfo[] newArray(int size) {
            return new IDCardInfo[size];
        }
    };

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSex() {
        return sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum.toUpperCase();
    }

    public String getIssueOffice() {
        return issueOffice;
    }

    public void setIssueOffice(String issueOffice) {
        this.issueOffice = issueOffice;
    }

    public String getValidDate() {
        return validDate;
    }

    public void setValidDate(String validDate) {
        this.validDate = validDate;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    @Override
    public String toString() {
        return "IDCardInfo{" +
                "name='" + name + '\'' +
                ", sex=" + sex +
                ", birthDate='" + birthDate + '\'' +
                ", nation='" + nation + '\'' +
                ", addr='" + addr + '\'' +
                ", idNum='" + idNum + '\'' +
                ", issueOffice='" + issueOffice + '\'' +
                ", validDate='" + validDate + '\'' +
                ", photo='" + photo + '\'' +
                '}';
    }
}
