package ocr.util;


import android.graphics.Bitmap;
import android.text.TextUtils;

import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.nfcoperate.bean.CardInfo;
import com.xdja.safeclient.certcreation.cache.ImageCache;

import cn.cloudwalk.libproject.Contants;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import ocr.bean.IDCardInfo;

/**
 * Created by guoyaxin on 2017/11/17.
 */

public class Convert {

    public static IDCardInfo cardInfoToIdentifyInfo(CardInfo cardInfo) {
        IDCardInfo info = new IDCardInfo();
        info.setAddr(cardInfo.getAddress());

        //modify 通过nfc解析出来的出生日志字符串中不包含年月日
        info.setBirthDate(convertBirthday(cardInfo.getBirthday()));

        info.setIdNum(cardInfo.getCardNum());
        if (cardInfo.getGender().equals("男")) {
            info.setSex(1);
        } else {
            info.setSex(2);
        }
        info.setName(cardInfo.getName());
        info.setNation(cardInfo.getNation());
        byte[] imgBData = ImgUtil.bitmapToByte(cardInfo.getPhoto(), Bitmap.CompressFormat.JPEG, Contants.JPG_QUALITY);
//        info.setPhoto(Base64Util.encode(imgBData));
        ImageCache.getInstance().setId(NFCCompany.XDJA, Base64Util.encode(imgBData));
        info.setIssueOffice(cardInfo.getEnrollInstitution());
//        info.setValidDate(cardInfo.getValidStartDate() + "-" + cardInfo.getValidEndDate());
        info.setValidDate(IDUtil.formatValidDate(cardInfo.getValidStartDate() + cardInfo.getValidEndDate()));
        return info;
    }

    private static String convertBirthday(String dataFromNFC) {
        if (TextUtils.isEmpty(dataFromNFC) || dataFromNFC.length() < 8) {
            return dataFromNFC;
        }
        String BornYear = dataFromNFC.substring(0, 4);
        String BornMouth = dataFromNFC.substring(4, 6);
        String BornDate = dataFromNFC.substring(6, 8);


        return BornYear + "年" + BornMouth + "月" + BornDate + "日";

    }

}
