/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.adapter.CertConfigAdapter;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;

public class ConfigStep3Activity
extends BaseActivity
implements View.OnClickListener {
    public static final String DEFAULT_CARD_TYPE_TEXT = "\u8bf7\u9009\u62e9";
    public String projectName;
    public String serverIP;
    public String serverPort;
    public String procedure;
    public ArrayList<ServerAddress> serverAddressesList = new ArrayList();
    public ArrayList<ServerAddress> vhsmAddressList = new ArrayList();
    public boolean enableVHSM;
    public String enableHHY;
    public String enableRevoke;
    RecyclerView recyclerView;
    List<TableCertConfig> list;
    CertConfigAdapter adapter;
    Button addNewCard;
    Button export;
    private View liveCompanyView;
    private TextView liveCompanyResult;
    private View ocrView;
    private TextView ocrResult;
    private View nfcView;
    private TextView nfcResult;
    private View nfcIPView;
    private EditText nfcIPResult;
    private View nfcPortView;
    private EditText nfcPortResult;
    private TextView exportHint;
    private CheckBox sAllowUpdate;
    private Button connect;
    private View layout3rdNServer;
    private View dividerLive;
    private LinearLayout cardLayout;
    ConfigHandler handler = new ConfigHandler();
    private ServerSettingConfig serverSettingConfig;
    public static final String path = Environment.getExternalStorageDirectory() + "/" + "certDataBase" + ".db";
    private boolean exportSuccess;
    public String certPath;
    public String certContent;
    public static final int CONNECT_SUCCESS = 0;
    public static final int CONNECT_FAILED = 1;
    public static final int SET_CONNECT_TEST = 2;
    public static final int SET_CONNECTING = 3;
    public static final int DISABLE_PIN = 4;
    public static final int ENABLE_PIN = 5;
    public static final int SERVER_SUCCESS = 6;
    public static final int SERVER_FAILED = 7;
    public static final int PERMISSION_CODE = 23;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.projectName = this.getIntent().getStringExtra("projectName");
        this.serverAddressesList = this.getIntent().getParcelableArrayListExtra("serverAddressesList");
        this.vhsmAddressList = this.getIntent().getParcelableArrayListExtra("vhsmAddressList");
        this.procedure = this.getIntent().getStringExtra("procedure");
        this.enableVHSM = this.getIntent().getBooleanExtra("enableVHSM", false);
        this.enableHHY = this.getIntent().getStringExtra("enableHHY");
        this.enableRevoke = this.getIntent().getStringExtra("enableRevoke");
        this.certPath = this.getIntent().getStringExtra("certPath");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_config_step3);
        this.initData();
        this.modifyList();
        this.initView();
        this.initViewByData();
        if (this.list.size() == 0 || this.list == null) {
            this.list = new ArrayList<TableCertConfig>();
            this.list.add(this.defaultCertConfig());
        }
        this.recyclerView = (RecyclerView)this.findViewById(R.id.list_device_detail);
        this.adapter = new CertConfigAdapter((Context)this, this.list, this.enableVHSM);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setNestedScrollingEnabled(false);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.resize();
        this.readCert();
    }

    private void readCert() {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)ConfigStep3Activity.this.certPath)) {
                    return;
                }
                try {
                    FileInputStream is = new FileInputStream(new File(ConfigStep3Activity.this.certPath));
                    ConfigStep3Activity.this.certContent = ApplicationInit.IS2String(is);
                    ModuleLog.e((Object)ConfigStep3Activity.this.certContent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (OutOfMemoryError e) {
                    ModuleToast.show(ConfigStep3Activity.this.getContext(), "\u6587\u4ef6\u592a\u5927\u4e86\uff01");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void modifyList() {
        if (this.enableVHSM) {
            return;
        }
        for (int position = 0; position < this.list.size(); ++position) {
            TableCertConfig config = this.list.get(position);
            if (!config.cardType.equals("VHSM")) continue;
            config.setCardType(DEFAULT_CARD_TYPE_TEXT);
        }
    }

    private void initData() {
        this.serverSettingConfig = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
        this.list = SQLite.select((IProperty[])new IProperty[0]).from(TableCertConfig.class).queryList();
        ModuleLog.d((Object)this.serverSettingConfig);
        ModuleLog.d(this.list);
        Log.e((String)"jff", (String)("194 ConfigStep3Activity initData : " + this.list));
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.connect) {
            this.ping();
        } else if (id2 == R.id.add_new_card) {
            this.list.add(this.defaultCertConfig());
            this.adapter.notifyDataSetChanged();
            this.resize();
        } else if (id2 == R.id.export) {
            boolean success = this.validBeforeExport();
            if (!success) {
                return;
            }
            this.showExportDialog();
        }
    }

    private void ping() {
        this.setConnecting();
        this.disablePing();
        this.pingServer();
    }

    private void setConnecting() {
        this.handler.sendEmptyMessage(3);
    }

    private void disablePing() {
        this.handler.sendEmptyMessage(4);
    }

    private void pingServer() {
        this.ping(this.nfcIPResult.getText().toString(), this.nfcPortResult.getText().toString());
    }

    private void ping(final String ip, final String port) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TelnetClient telnet = new TelnetClient();
                try {
                    telnet.setConnectTimeout(2000);
                    telnet.connect(ip, Integer.parseInt(port));
                    ConfigStep3Activity.this.handler.sendEmptyMessage(6);
                }
                catch (Exception e) {
                    ConfigStep3Activity.this.handler.sendEmptyMessage(7);
                    e.printStackTrace();
                }
                finally {
                    try {
                        telnet.disconnect();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void showResult(boolean success) {
        this.handler.sendEmptyMessage(success ? 0 : 1);
        this.setConnectText();
        this.enablePing();
    }

    private void setConnectText() {
        this.handler.sendEmptyMessage(2);
    }

    private void enablePing() {
        this.handler.sendEmptyMessage(5);
    }

    private void resize() {
        this.recyclerView.setMinimumHeight(ScreenUtil.dip2px(this.getContext(), 324.0f) * this.list.size());
        ModuleLog.e((Object)this.recyclerView.getHeight());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Subscribe
    public void handleConfig(ChooseConfigEvent event) {
        ConfigBean value = event.getConfig();
        String text = value.getContent();
        int position = event.getPosition();
        if (position == 111) {
            this.liveCompanyResult.setText((CharSequence)text);
        } else if (position == 333) {
            this.nfcResult.setText((CharSequence)text);
        } else if (position == 222) {
            this.ocrResult.setText((CharSequence)text);
        } else {
            TableCertConfig item = this.list.get(position);
            if (CardType.getList().contains(value)) {
                item.setCardType(text);
            } else if (ContainerNum.getList().contains(value)) {
                item.setContainerNum(Integer.parseInt(text));
            } else if (AlgType.getList().contains(value)) {
                item.setAlgType(text);
            } else if (CertRule.getList().contains(value)) {
                item.setCertRule(text);
            } else if (CertType.getList().contains(value)) {
                item.setCertType(text);
            } else if (CertPermission.getList().contains(value)) {
                item.setCertPermission(text);
            }
            this.list.set(position, item);
            this.adapter.notifyDataSetChanged();
        }
    }

    public TableCertConfig defaultCertConfig() {
        TableCertConfig certConfig = new TableCertConfig();
        certConfig.setPosition(this.list.size());
        certConfig.setCardType(DEFAULT_CARD_TYPE_TEXT);
        certConfig.setContainerNum(ContainerNum.getDefault());
        certConfig.setAlgType(AlgType.getDefaule());
        certConfig.setCertType(CertType.getDefault());
        certConfig.setCertRule(CertRule.getDefault());
        certConfig.setCertPermission(CertPermission.getDefault());
        return certConfig;
    }

    @Subscribe
    public void handleDeleteConfigDetail(DeleteCertConfigEvent event) {
        this.list.remove(event.getPosition());
        this.adapter.notifyDataSetChanged();
        this.resize();
    }

    private void initView() {
        this.dividerLive = this.findViewById(R.id.divider_live);
        this.connect = (Button)this.findViewById(R.id.connect);
        this.connect.setOnClickListener((View.OnClickListener)this);
        this.sAllowUpdate = (CheckBox)this.findViewById(R.id.switch_allow_update);
        this.exportHint = (TextView)this.findViewById(R.id.export_hint);
        this.exportSuccess = SharePreferencesUtil.getExportState((Context)this);
        if (this.exportSuccess) {
            this.exportHint.setVisibility(0);
            this.exportHint.setText(R.string.cert_creation_save_success);
        }
        this.addNewCard = (Button)this.findViewById(R.id.add_new_card);
        this.addNewCard.setOnClickListener((View.OnClickListener)this);
        this.export = (Button)this.findViewById(R.id.export);
        this.export.setOnClickListener((View.OnClickListener)this);
        this.liveCompanyView = this.findViewById(R.id.live_company);
        this.liveCompanyView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.getContext(), 111, LiveCompany.getList());
            }
        });
        this.liveCompanyResult = (TextView)this.findViewById(R.id.live_company_result);
        this.ocrView = this.findViewById(R.id.ocr);
        this.ocrView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.getContext(), 222, OCRCompany.getList());
            }
        });
        this.ocrResult = (TextView)this.findViewById(R.id.ocr_result);
        this.nfcView = this.findViewById(R.id.nfc);
        this.nfcView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(ConfigStep3Activity.this.getContext(), 333, NFCCompany.getList());
            }
        });
        this.nfcResult = (TextView)this.findViewById(R.id.nfc_result);
        this.nfcPortView = this.findViewById(R.id.nfc_port_view);
        this.nfcPortResult = (EditText)this.findViewById(R.id.nfc_port);
        this.nfcIPView = this.findViewById(R.id.nfc_ip_view);
        this.nfcIPResult = (EditText)this.findViewById(R.id.nfc_ip_result);
        this.layout3rdNServer = this.findViewById(R.id.layout_3rd_n_server);
        this.initDefault3rdConfig();
        this.cardLayout = (LinearLayout)this.findViewById(R.id.card_layout);
    }

    private void initViewByData() {
        if (this.serverSettingConfig == null) {
            return;
        }
        this.liveCompanyResult.setText((CharSequence)this.serverSettingConfig.getLiveCompany());
        this.ocrResult.setText((CharSequence)this.serverSettingConfig.getOcrCompany());
        this.nfcResult.setText((CharSequence)this.serverSettingConfig.getNfcCompany());
        this.nfcIPResult.setText((CharSequence)this.serverSettingConfig.getNfcServerIP());
        this.nfcPortResult.setText((CharSequence)this.serverSettingConfig.getNfcServerPort());
        this.sAllowUpdate.setChecked(this.serverSettingConfig.getAllowUpdate().equals("\u662f"));
    }

    private void initDefault3rdConfig() {
        if (!this.procedure.equals("\u6807\u51c6\u6d41\u7a0b")) {
            if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
                this.ocrView.setVisibility(8);
            } else if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0NFC\uff09")) {
                this.connect.setVisibility(8);
                this.ocrView.setVisibility(8);
                this.nfcView.setVisibility(8);
                this.nfcIPView.setVisibility(8);
                this.nfcPortView.setVisibility(8);
                this.dividerLive.setVisibility(8);
            } else if (this.procedure.equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
                this.layout3rdNServer.setVisibility(8);
            } else if (this.procedure.equals("\u6301\u8bc1\u62cd\u7167\u6d41\u7a0b")) {
                this.layout3rdNServer.setVisibility(8);
            }
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.liveCompanyView.getVisibility() == 0) {
            this.liveCompanyResult.setText((CharSequence)"\u4e91\u4ece");
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.ocrView.getVisibility() == 0) {
            this.ocrResult.setText((CharSequence)"\u4e91\u4ece");
        }
        if (this.layout3rdNServer.getVisibility() == 0 && this.nfcView.getVisibility() == 0) {
            this.nfcResult.setText((CharSequence)"\u4fe1\u5927\u6377\u5b89");
        }
    }

    private boolean validBeforeExport() {
        if (this.procedure.equals("\u6807\u51c6\u6d41\u7a0b") || this.procedure.equals("\u6807\u51c6\u6d41\u7a0b\uff08\u65e0OCR\uff09")) {
            String ip = this.nfcIPResult.getText().toString();
            if (TextUtils.isEmpty((CharSequence)ip)) {
                ModuleToast.show((Context)this, R.string.cert_creation_config_empty_server_address);
                return false;
            }
            boolean success = AddressUtil.validIP(ip);
            if (!success) {
                ModuleToast.show((Context)this, R.string.cert_creation_config_error_server_address);
                return false;
            }
            String port = this.nfcPortResult.getText().toString();
            if (TextUtils.isEmpty((CharSequence)port)) {
                ModuleToast.show((Context)this, R.string.cert_creation_config_please_input_server_port);
                return false;
            }
            success = AddressUtil.validPort(port);
            if (!success) {
                ModuleToast.show((Context)this, R.string.cert_creation_config_error_server_port);
                return false;
            }
        }
        boolean success = this.validCertConfig();
        return success;
    }

    private boolean validCertConfig() {
        boolean success = true;
        for (TableCertConfig config : this.list) {
            int last;
            if (config.cardType.equals(DEFAULT_CARD_TYPE_TEXT)) {
                success = false;
                ModuleToast.show((Context)this, R.string.cert_creation_config_please_choose_card_type);
                break;
            }
            int first = this.list.indexOf(config);
            if (first == (last = this.list.lastIndexOf(config))) continue;
            success = false;
            TableCertConfig config1 = this.list.get(first);
            TableCertConfig config2 = this.list.get(last);
            String cardType1 = config1.getCardType();
            String cardType2 = config2.getCardType();
            if (cardType1.equals("VHSM") && cardType2.equals("\u79bb\u7ebfVHSM")) {
                ModuleToast.show((Context)this, "\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u79bb\u7ebfVHSM\u548c\u8054\u7f51VHSM");
                break;
            }
            if (cardType1.equals("\u79bb\u7ebfVHSM") && cardType2.equals("VHSM")) {
                ModuleToast.show((Context)this, "\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\u79bb\u7ebfVHSM\u548c\u8054\u7f51VHSM");
                break;
            }
            if (!config1.cardType.equals(config2.cardType)) break;
            if (config1.containerNum == config2.containerNum) {
                ModuleToast.show((Context)this, R.string.cert_creation_repeat_container_num);
                break;
            }
            if (!config1.certPermission.equals("\u7533\u8bf7\u8bc1\u4e66") || !config2.certPermission.equals("\u7533\u8bf7\u8bc1\u4e66")) break;
            ModuleToast.show((Context)this, R.string.cert_creation_repeat_cert_permission);
            break;
        }
        return success;
    }

    private void showExportDialog() {
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog((Context)this);
        bindIdentifyDialog.setTitle(R.string.cert_creation_export_config_title);
        bindIdentifyDialog.setMessage(R.string.cert_creation_export_config_message);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_export_config_positive);
        bindIdentifyDialog.setCancelable(true);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                boolean hasPermission = ConfigStep3Activity.this.checkValidPermission(ConfigStep3Activity.this.permissions);
                if (!hasPermission) {
                    ConfigStep3Activity.this.showInvalidPermissionDialog();
                    return;
                }
                ConfigStep3Activity.this.deleteDatabase();
                ConfigStep3Activity.this.exportToSDCard();
                bindIdentifyDialog.cancel();
            }

            public void doCancel() {
                bindIdentifyDialog.cancel();
            }
        });
    }

    private void clearTableValue() {
        Delete.table(ServerSettingConfig.class, (SQLCondition[])new SQLCondition[0]);
        Delete.table(TableCertConfig.class, (SQLCondition[])new SQLCondition[0]);
    }

    private void exportToSDCard() {
        this.clearTableValue();
        ServerSettingConfig table = new ServerSettingConfig();
        table.liveCompany = this.liveCompanyResult.getText().toString();
        table.ocrCompany = this.ocrResult.getText().toString();
        table.nfcCompany = this.nfcResult.getText().toString();
        this.saveServerAddress(table);
        this.saveVHSMAddress(table);
        table.nfcServerIP = this.nfcIPResult.getText().toString();
        table.nfcServerPort = this.nfcPortResult.getText().toString();
        table.allowUpdate = this.sAllowUpdate.isChecked() ? "\u662f" : "\u5426";
        table.procedure = this.procedure;
        table.projectName = this.projectName;
        table.enableVHSM = this.enableVHSM;
        table.certContent = this.certContent;
        table.certPath = this.certPath;
        table.hhy = this.enableHHY;
        table.revoke = this.enableRevoke;
        table.save();
        for (TableCertConfig config : this.list) {
            config.save();
        }
        this.exportHint.setTextColor(this.getResources().getColor(R.color.config_hint));
        this.exportHint.setVisibility(0);
        this.exportHint.setText(R.string.cert_creation_save_success);
        SharePreferencesUtil.saveExportState((Context)this, true);
    }

    private void saveServerAddress(ServerSettingConfig table) {
        StringBuilder ip = new StringBuilder();
        StringBuilder port = new StringBuilder();
        for (int position = 0; position < this.serverAddressesList.size(); ++position) {
            ServerAddress address = this.serverAddressesList.get(position);
            ip.append(address.getIp());
            port.append(address.getPort());
            if (position == this.serverAddressesList.size() - 1) continue;
            ip.append("|");
            port.append("|");
        }
        table.ip = ip.toString();
        table.port = port.toString();
    }

    private void saveVHSMAddress(ServerSettingConfig table) {
        if (!this.enableVHSM) {
            return;
        }
        StringBuilder ip = new StringBuilder();
        StringBuilder port = new StringBuilder();
        for (int position = 0; position < this.vhsmAddressList.size(); ++position) {
            ServerAddress address = this.vhsmAddressList.get(position);
            ip.append(address.getIp());
            port.append(address.getPort());
            if (position == this.vhsmAddressList.size() - 1) continue;
            ip.append("|");
            port.append("|");
        }
        table.vhsm_ip = ip.toString();
        table.vhsm_port = port.toString();
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog((Context)this);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                ConfigStep3Activity.this.checkoutPermission();
            }

            public void doCancel() {
                ConfigStep3Activity.this.finish();
            }
        });
    }

    private void checkoutPermission() {
        ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)23);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (grantResults[0] != 0) {
            this.showNoPermissionDialog();
        }
    }

    private void showNoPermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build((Context)this, 3);
        dialog.show();
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void deleteDatabase() {
        File file = new File(path);
        if (file.exists()) {
            ModuleLog.e((Object)"db\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5c1d\u8bd5\u5220\u9664");
            boolean success = file.delete();
            ModuleLog.e((Object)(success ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u662f\u6ca1\u6709\u6388\u4e88\u5b58\u50a8\u6743\u9650"));
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    class ConfigHandler
    extends Handler {
        ConfigHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 0) {
                ModuleToast.showNoRepeat(ConfigStep3Activity.this.getContext(), R.string.cert_creation_connect_success);
            } else if (msg.what == 1) {
                ModuleToast.showNoRepeat(ConfigStep3Activity.this.getContext(), R.string.cert_creation_connect_failed);
            } else if (msg.what == 2) {
                ConfigStep3Activity.this.connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == 3) {
                ConfigStep3Activity.this.connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == 4) {
                ConfigStep3Activity.this.connect.setClickable(false);
            } else if (msg.what == 5) {
                ConfigStep3Activity.this.connect.setClickable(true);
            } else if (msg.what == 6) {
                ConfigStep3Activity.this.showResult(true);
            } else if (msg.what == 7) {
                ConfigStep3Activity.this.showResult(false);
            }
        }
    }
}

