/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.LinearLayout;
import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.adapter.EmbeddedCertAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EmbeddedCertViewActivity
extends BaseActivity {
    private RecyclerView recyclerView;
    private EmbeddedCertAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;
    private int navigateType;
    private int titleRes;
    private List<CertItemBean> certItemBeans = null;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.initConfigView();
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_embedded_cert_view);
        this.getCertData();
        this.initView();
        this.left_title_tv.setText(R.string.cert_creation_cert_view);
    }

    private void initConfigView() {
        this.navigateType = 0;
        this.titleRes = R.string.cert_creation_cert_view;
        if (FeatureConfig.getInstance().isDisableVHSM() || !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }
    }

    private void initView() {
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.recyclerViewAdapter = new EmbeddedCertAdapter((Context)this, this.certItemBeans);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerViewAdapter);
        this.rightBtn.setVisibility(8);
        this.noChip = (LinearLayout)this.findViewById(R.id.no_chip);
        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            this.noChip.setVisibility(0);
        } else {
            this.noChip.setVisibility(8);
        }
    }

    private void getCertData() {
        this.certItemBeans = this.initList(this.getCurrentCardTypeList());
    }

    private List<String> getCurrentCardTypeList() {
        ArrayList<String> cardTypeList = new ArrayList<String>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();
        if (devInfoMap != null) {
            for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
                if (cryptoDevInfoEntry == null) continue;
                cardTypeList.add(CardType.toString(cryptoDevInfoEntry.getValue().getType()));
            }
        }
        return cardTypeList;
    }

    private List<CertItemBean> initList(List<String> currentCardTypeList) {
        CertItemBean bean;
        Map<Integer, CryptoDevInfo> currentCardMaps = DeviceWrapper.getInstance().getDevInfo();
        ArrayList<CertItemBean> all = new ArrayList<CertItemBean>();
        List tableValue = new ArrayList();
        try {
            tableValue = SQLite.select((IProperty[])new IProperty[0]).from(TableCertConfig.class).queryList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> tableCardSet = new HashSet<String>();
        for (TableCertConfig config : tableValue) {
            String cardType = config.getCardType();
            tableCardSet.add(cardType);
            if (cardType.equals("\u79bb\u7ebfVHSM") || cardType.equals("VHSM")) {
                CryptoDevInfo netVhsm = new CryptoDevInfo();
                netVhsm.setCardId(NetVHSMHandle.getNetVhsmCardId((Context)this));
                netVhsm.setDriver("ChipManagerDriver");
                netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);
                XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
                netVhsm.setPrivateData((Object)extraInfo.setType(32));
                CertItemBean bean2 = new CertItemBean();
                bean2.setCertConfig(config);
                bean2.setCryptoDevInfo(netVhsm);
                all.add(bean2);
                continue;
            }
            if (!currentCardTypeList.contains(cardType)) continue;
            bean = new CertItemBean();
            bean.setCertConfig(config);
            bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(cardType).getType()));
            all.add(bean);
        }
        for (String currentCardType : currentCardTypeList) {
            if (tableCardSet.contains(currentCardType)) continue;
            TableCertConfig tableCertConfig = TableCertConfig.initDefaultOne();
            tableCertConfig.cardType = currentCardType;
            bean = new CertItemBean();
            bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(currentCardType).getType()));
            bean.setCertConfig(tableCertConfig);
            all.add(bean);
        }
        ModuleLog.d(all);
        Collections.sort(all);
        return all;
    }
}

