/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import okhttp3.Call;

public class ReasonActivity
extends BaseActivity {
    public static final String TAG = "ReasonActivity";
    public static final int REVOKE = 2;
    public static final int RECOVERY = 1;
    private EditText reasonET;
    private Button submit;
    private CertDetailInfo certDetailInfo;
    public ChipBean chipBean;
    CryptoDevType cardType;
    public int containerNum;
    private String certRule;
    public String certType;
    public String cardID;
    private boolean block;
    private PinDialog pinDialog = null;
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            String str;
            this.temp = charSequence;
            String editable = ReasonActivity.this.reasonET.getText().toString();
            if (!editable.equals(str = EditTextUtil.stringFilter(editable))) {
                ModuleToast.show((Context)ReasonActivity.this, R.string.cert_creation_reason_text_correct);
                ReasonActivity.this.reasonET.setText((CharSequence)str);
                ReasonActivity.this.reasonET.setSelection(str.length());
            }
        }

        public void afterTextChanged(Editable editable) {
            this.selectionStart = ReasonActivity.this.reasonET.getSelectionStart();
            this.selectionEnd = ReasonActivity.this.reasonET.getSelectionEnd();
            if (this.temp.length() > 40) {
                ModuleToast.show((Context)ReasonActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(this.selectionStart - 1, this.selectionEnd);
                int tempSelection = this.selectionEnd;
                ReasonActivity.this.reasonET.setText((CharSequence)editable);
                ReasonActivity.this.reasonET.setSelection(tempSelection);
            }
        }
    };

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.chipBean = (ChipBean)this.getIntent().getSerializableExtra("chipBean");
        this.cardID = this.getIntent().getStringExtra("cardId");
        this.certType = this.getIntent().getStringExtra("certType");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_reason);
        this.certDetailInfo = this.chipBean.getCertBean();
        this.cardType = CryptoDevTypeUtil.formatType(this.chipBean.getType());
        this.certRule = AppConfig.getInstance().getCertConfig().getCertRule(this.cardType, this.containerNum);
        this.reasonET = (EditText)this.findViewById(R.id.reason);
        this.reasonET.addTextChangedListener(this.textWatcher);
        this.reasonET.setFilters(EditTextUtil.getDisableEmojFilter());
        this.submit = (Button)this.findViewById(R.id.submit);
        ReasonActivity context = this;
        this.submit.setOnClickListener((View.OnClickListener)new NoDoubleClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            @Override
            public void onNoDoubleClick(View v) {
                if (!ReasonActivity.this.block) {
                    if (ReasonActivity.this.reasonET.getText().length() > 0) {
                        ReasonActivity.this.hideSoft();
                        ReasonActivity.this.revokeCert();
                    } else {
                        ModuleToast.show(this.val$context, R.string.cert_creation_reason_input);
                    }
                } else {
                    ModuleLog.e((Object)"\u7981\u6b62\u591a\u6b21\u64a4\u9500");
                }
                ReasonActivity.this.block = true;
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ReasonActivity.this.block = false;
                    }
                }, 2000L);
            }
        });
    }

    private void revokeCert() {
        this.showLoading();
        RevokedCertRequest request = this.buildRequest();
        if (request == null) {
            return;
        }
        this.service.revokedCert(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                ReasonActivity.this.dismissLoading();
                if (e instanceof CardNotExistException) {
                    ModuleToast.show((Context)ReasonActivity.this, R.string.cert_creation_device_not_exist);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ReasonActivity.this.dismissLoading();
                ModuleToast.show((Context)ReasonActivity.this, R.string.net_disconnected_text);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    ReasonActivity.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {
                    ReasonActivity.this.chipBean.setState(CertState.AGREE_REVOKE);
                } else if (result.equals("2")) {
                    ReasonActivity.this.chipBean.setState(CertState.REJECT_REVOKE);
                } else if (!result.equals("5") && !result.equals("6") && result.equals("45")) {
                    ReasonActivity.this.chipBean.setState(CertState.RA_REVOKE_WAIT_45);
                }
                BusProvider.getMainProvider().post((Object)ReasonActivity.this.chipBean);
                OttoUtil.postRevokeResult(ReasonActivity.this.containerNum, ReasonActivity.this.chipBean, ReasonActivity.this.reasonET.getText().toString());
                ReasonActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e((Object)("\u6ce8\u9500\u5931\u8d25\uff1a " + baseErrorResponse.getErrCode()));
                ModuleToast.show((Context)ReasonActivity.this, OkNetError.userError(ReasonActivity.this.getContext(), baseErrorResponse.getErrCode()));
                this.dismissDialog();
            }

            @Override
            public void dismissDialog() {
                ReasonActivity.this.dismissLoading();
            }
        });
    }

    private RevokedCertRequest buildRequest() {
        String sn;
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.certDetailInfo != null) {
            sn = this.certType.equals("\u7b7e\u540d\u8bc1\u4e66") || this.certRule.equals("\u5355\u8bc1") ? this.certDetailInfo.getSn() : DeviceWrapper.getInstance().readCertFromContainer(this.cardType, this.containerNum, "\u7b7e\u540d\u8bc1\u4e66").getSn();
        } else {
            ModuleLog.e((Object)"sn\u4e3a\u7a7a");
            return null;
        }
        info.setSn(sn);
        info.setReason(this.reasonET.getText().toString());
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.cardType, this.containerNum, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {
                this.showPinDialog();
                return null;
            }
            revokeRequest.setSign(sign);
            ModuleLog.e((Object)("revoke sign " + sign + " \u539f\u6587\uff1a " + info.toString()));
        } else {
            ModuleToast.show(this.getContext(), R.string.cert_creation_signFail);
        }
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.cardType.getType()));
        return revokeRequest;
    }

    private void showPinDialog() {
        this.pinDialog = new PinDialog(this.getContext(), this.cardType);
        this.pinDialog.show();
    }

    private void hideSoft() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_revoke_cert;
    }
}

