/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import com.aircert.util.ModuleLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.vhsm.base.VHSMBase;
import com.xdja.vhsm.base.VHSM_INIT_PARAM;
import com.xdja.vhsm.base.VHSM_SERVER_INFO;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class NetVHSMHandle {
    private static Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            int initFile = (Integer)msg.getData().get("value");
            OttoUtil.postNet_VHSMinitResult(initFile);
        }
    };

    public static void initVHSM(final Context context, final String ip, final int port) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NetRespository netRespository = NetRespository.create((Context)context, (String)ip, (int)port);
                int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId((Context)context));
                ModuleLog.e((Object)("vhsm initResult =  " + initResult));
                if (initResult == 0) {
                    ModuleLog.e((Object)"VHSM\u521d\u59cb\u5316\u6210\u529f");
                    int initFile = NetRespository.initVhsmlibFile((Context)context, (String)ip, (int)port);
                    Message msg = new Message();
                    msg.obj = "success";
                    Bundle data = new Bundle();
                    data.putInt("value", initFile);
                    msg.setData(data);
                    handler.sendMessage(msg);
                } else {
                    Message msg = new Message();
                    msg.obj = "fail";
                    Bundle data = new Bundle();
                    data.putInt("value", initResult);
                    msg.setData(data);
                    handler.sendMessage(msg);
                }
            }
        }).start();
    }

    private static String getNetVhsmCardId_1(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId((String)NetVhsmDeviceIdUtils.getDevId((Context)context));
        ModuleLog.i((Object)("NetVhsmCardId : " + netVhsmCardId));
        return netVhsmCardId;
    }

    public static void initVHSM(Context context, String ip, int port, String phoneStr, byte[] sig) {
        int ret = 0;
        ModuleLog.i((Object)"start initVHSM : ");
        VHSM_SERVER_INFO serverInfo = new VHSM_SERVER_INFO();
        VHSMBase vhsm = new VHSMBase();
        if ("com.xdja.safeclient".equals(ApplicationInit.getPackageName(context))) {
            vhsm.SetDevPath(ApplicationInit.privatePath().getBytes());
        }
        byte[] buf = new byte[1024];
        int[] len = new int[1];
        vhsm.GetVersion(buf, len);
        vhsm.GetDateTime(buf, len);
        ret = vhsm.InitVHSM(30, null);
        ModuleLog.e((Object)("initVHSM ret : " + ret));
        if (ret != 0) {
            serverInfo.addrType = 1;
            System.arraycopy(ip.getBytes(StandardCharsets.UTF_8), 0, serverInfo.ip, 0, ip.length());
            serverInfo.port = port;
            serverInfo.serverType = 3;
            ret = vhsm.SetServerInfo(serverInfo);
            ModuleLog.e((Object)("initVHSM ret: " + ret));
            if (ret != 0) {
                ModuleLog.e((Object)"initVHSM : ");
                return;
            }
            byte[] nameB = new byte[]{};
            String name = SharePreferencesUtil.getName(context);
            if (name != null && name.length() > 0) {
                nameB = name.getBytes(StandardCharsets.UTF_8);
            }
            byte[] phone = phoneStr.getBytes(StandardCharsets.UTF_8);
            String deptStr = "\u6682\u65e0";
            byte[] deptB = deptStr.getBytes(StandardCharsets.UTF_8);
            byte[] signature = sig;
            VHSM_INIT_PARAM param = new VHSM_INIT_PARAM();
            System.arraycopy(nameB, 0, param.name, 0, nameB.length);
            System.arraycopy(phone, 0, param.phone, 0, phone.length);
            System.arraycopy(deptB, 0, param.dept, 0, deptB.length);
            System.arraycopy(signature, 0, param.signature, 0, signature.length);
            param.initType = 2;
            ret = vhsm.InitVHSM(11, param);
            ModuleLog.e((Object)("initVHSM ret : " + ret));
            if (ret != 0) {
                Message msg = new Message();
                msg.obj = "fail";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            } else {
                ModuleLog.e((Object)"VHSM\u521d\u59cb\u5316\u6210\u529f");
                Message msg = new Message();
                msg.obj = "success";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            }
            ret = vhsm.InitVHSM(1, param);
            System.out.println("VHSM_InitVHSM\uff08VHSM_OP_QUERY\uff09 return " + ret);
            if (ret != 0) {
                return;
            }
        }
    }

    private static String getNetVhsmCardId() {
        byte[] buf = new byte[1024];
        int[] len = new int[1];
        VHSMBase vhsmBase = new VHSMBase();
        vhsmBase.GetSerialNumber(buf, len);
        vhsmBase.GetCardIdBySerialNumber(buf, len[0], buf, len);
        String netVhsmCardId = new String(Arrays.copyOf(buf, len[0]));
        return netVhsmCardId;
    }

    public static String getNetVhsmCardId(Context context) {
        if ("3".equals("1")) {
            return NetVHSMHandle.getNetVhsmCardId_1(context);
        }
        return NetVHSMHandle.getNetVhsmCardId();
    }

    public static int isNetVHSMCanUse() {
        String rootPath = ApplicationInit.rootPath();
        File storageDir = Environment.getExternalStorageDirectory();
        String privatePath = ApplicationInit.privatePath();
        if (!NetVHSMHandle.isFileExist(rootPath, storageDir)) {
            if (NetVHSMHandle.isFileExist(privatePath, null)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private static File getFile(File storageDir, String childPath) {
        File file = null == storageDir ? new File("", childPath) : new File(storageDir, childPath);
        return file;
    }

    private static boolean isFileExist(String file_Dir, File storageDir) {
        String randFilePath = file_Dir + "/rand.bin";
        String kdatFilePath = file_Dir + "/vhsm.dat";
        String wboxFilePath = file_Dir + "/wbox.lib";
        String vhsmLibFilePath = file_Dir + "/vhsm.lib";
        File randFile = NetVHSMHandle.getFile(storageDir, randFilePath);
        ModuleLog.e((Object)("randFilePath : " + randFilePath));
        if (!randFile.exists()) {
            ModuleLog.e((Object)"null ");
            return false;
        }
        File kdatFile = NetVHSMHandle.getFile(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        File wboxFile = NetVHSMHandle.getFile(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File vhsmLibFile = NetVHSMHandle.getFile(storageDir, vhsmLibFilePath);
        return vhsmLibFile.exists();
    }
}

