package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.IsTrue;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.event.UpdateCertStateEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;

import okhttp3.Call;

/**
 * Created by jff on 2018/6/27.
 */

public class CertDetailInfoActivity extends BaseActivity implements View.OnClickListener {

    private TextView sn;
    private TextView ver;
    private TextView signAlg;
    private TextView user;
    private TextView issuer;
    private TextView notBefore;
    private TextView notAfter;

    private RelativeLayout rlSignCert;

    private RelativeLayout rlEncryptCert;

    private RelativeLayout rlCertRule;

    private View vSignDivider;

    private View vEncryptDivider;

    private CertDetailInfo signCertData;

    private CertDetailInfo encryptCertData;

    private String currentSelect = CertType.SIGNING;

    public ChipBean bean;

    public int containerNum;

    public String certType;

    public boolean inUse;

    public boolean allowApplyCert;

    private FrameLayout certStatus;
    private CertService certService = new CertService();
    private Context context;
    private CryptoDevType chipBeanType;
    private String cardID;


    private PinDialog pinDialog;

    private final int REVOKE_CERT = 1;
    private final int DELETE_CERT = 2;
    private final int UPDATE_CERT_INFO = 3;

    private int operate_type = -1; //操作类型  1 撤销证书；2 删除证书 ；3 更新证书 ；-1 默认值，表示不进行任何操作

    private boolean isShowUpdate = true;//是否展示更新弹框

    private static Handler myHandler = new Handler();


    /**
     * 弹窗提示用户用户开启权限
     */
    private BindIdentifyDialog bindIdentifyDialog = null;

    private void showInvalidPermissionDialog() {

        bindIdentifyDialog = new BindIdentifyDialog(context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(R.string.cert_creation_cert_have_expired);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_close);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_update);


        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                bindIdentifyDialog.dismiss();

                //更新证书
                operate_type = UPDATE_CERT_INFO;
                showPinDialog();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
            }
        });

    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        bean = (ChipBean) getIntent().getSerializableExtra("chipBean");
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
        inUse = getIntent().getBooleanExtra("inUse", false);
        allowApplyCert = getIntent().getBooleanExtra(ActivityParam.ALLOW_APPLY_CERT, false);

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cert_detail);
        context = this;

        initPrimaryView();

        initDataAndShow();

        showCertState();


    }

    /**
     * 根据数据初始化界面数据
     */
    private void initDataAndShow() {
        ModuleLog.e(bean.getType());
        chipBeanType = CryptoDevTypeUtil.formatType(bean.getType());

        currentSelect = certType;

        String rest = updateCertValue(bean.getCertBean());

        if (isDoubleCert()) {
            CertDetailInfo another = DeviceWrapper.getInstance().readCertFromContainer(
                    chipBeanType, containerNum, rest);
            if (another == null) {
                rlCertRule.setVisibility(View.GONE);
            }
            if (rest.equals(CertType.SIGNING)) {
                signCertData = another;
            } else {
                encryptCertData = another;
            }
        } else {
            rlCertRule.setVisibility(View.GONE);
        }

        selectShow();

        cardID = DeviceWrapper.getInstance().getCardID(chipBeanType);
        ModuleLog.e(chipBeanType);
    }

    /**
     *
     */
    private void selectShow() {

        if (isDoubleCert()) {
            // 双证再未手动切换时，默认展示的是签名证书
            showData(currentSelect.equals(CertType.SIGNING) ? signCertData : encryptCertData);
            updateDivider();
        } else {
            showOnlySingleCert();
        }

    }

    /**
     * 展示只有单证书的界面
     */
    private void showOnlySingleCert() {
        if (signCertData != null) {
            showData(signCertData);
            rlEncryptCert.setVisibility(View.GONE);
        } else {
            showData(encryptCertData);
            rlSignCert.setVisibility(View.GONE);
        }
    }

    /**
     * 更新加密证书和签名证书下面绿色选中状态的显示
     */
    private void updateDivider() {
        if (currentSelect.equals(CertType.SIGNING)) {
            vSignDivider.setVisibility(View.VISIBLE);
            vEncryptDivider.setVisibility(View.GONE);
        } else {
            vSignDivider.setVisibility(View.GONE);
            vEncryptDivider.setVisibility(View.VISIBLE);
        }
    }


    /**
     * 更新详情的值
     *
     * @return 返回剩余一张需要更新的证书
     * 如果是双证，更新的是签名证书，则返回加密证书；反之类推
     * 如果是单证，返回空串
     */
    private String updateCertValue(CertDetailInfo info) {

        if (certType.equals(CertType.SIGNING)) {
            signCertData = info;
            return isDoubleCert() ? CertType.ENCRYPT : "";
        } else {
            encryptCertData = info;
            return isDoubleCert() ? CertType.SIGNING : "";
        }
    }

    private boolean isDoubleCert() {
        return AppConfig.getInstance().getCertConfig().getCertRule(chipBeanType, containerNum)
                .equals(CertRule.DOUBLE_CERT);
    }


    @Override
    public void onBackPressed() {
        super.onBackPressed();

    }

    Button revoke;
    Button revoke_full;
    Button delete;
    Button update;
    Button refresh;

    RelativeLayout bottomButton;

    private void initPrimaryView() {
        certStatus = findViewById(R.id.cert_detail_status);
        sn = findViewById(R.id.sn_text);
        ver = findViewById(R.id.ver_text);
        signAlg = findViewById(R.id.signAlg_text);
        user = findViewById(R.id.user_text);
        issuer = findViewById(R.id.issuer_text);
        notBefore = findViewById(R.id.indate_start);
        notAfter = findViewById(R.id.indate_end);


        revoke = findViewById(R.id.revoked_btn);
        delete = findViewById(R.id.delete_cert_btn);
        update = findViewById(R.id.update_cert_btn);
        refresh = findViewById(R.id.refresh_cert_btn);
        revoke_full = findViewById(R.id.revoked_full_btn);

        bottomButton = findViewById(R.id.bottom_button);

        rlEncryptCert = findViewById(R.id.rl_encrypt_cert);
        rlEncryptCert.setOnClickListener(this);

        rlSignCert = findViewById(R.id.rl_sign_cert);
        rlSignCert.setOnClickListener(this);

        vSignDivider = findViewById(R.id.v_sign_divider);
        vEncryptDivider = findViewById(R.id.v_encrypt_divider);

        rlCertRule = findViewById(R.id.rl_cert_rule);


    }

    private void showBtn(Button btn) {
        revoke.setVisibility(View.GONE);
        delete.setVisibility(View.GONE);
        update.setVisibility(View.GONE);
        refresh.setVisibility(View.GONE);
        revoke_full.setVisibility(View.GONE);

        boolean allowUpdate = AppConfig.getInstance().getServerSettingConfig().getAllowUpdate()
                .equals(IsTrue.AYE);

        // 如果该容器只具备展示证书的权限（不能发证）
        // 那么同样不能进行撤销、删除、更新证书等操作
        if (!allowApplyCert) {
            bottomButton.setVisibility(View.GONE);
        }

        if (btn == revoke) {
            //撤销证书配置里设置否，底部操作栏不显示，但是删除按钮在应该的时候还需要显示
            if (AppConfig.getInstance().getServerSettingConfig().getRevoke().equals(IsTrue.NAY)) {
                bottomButton.setVisibility(View.GONE);
            } else {
                if (allowUpdate) {
                    revoke.setVisibility(View.VISIBLE);
                } else {
                    revoke_full.setVisibility(View.VISIBLE);
                }
            }
        }
        if (btn == delete) {
            delete.setVisibility(View.VISIBLE);
        }
        if (btn == update) {
            update.setVisibility(View.VISIBLE);
        }
        if (btn == refresh) {
            refresh.setVisibility(View.VISIBLE);
        }

    }


    private void showData(CertDetailInfo certDetailInfo) {
        sn.setText(certDetailInfo.getSn());
        ver.setText("" + certDetailInfo.getVer());


        //解析算法，因为SM2解析无法直接转成name，所以这里做两步处理，第一步，根据OID，转成名字；第二步，如果没有OID，根据配置文件里的算法显示 2022年2月9日10:40:53
        String algStr = "";
        if (certDetailInfo.getAlg() != null && certDetailInfo.getAlg().length() > 0) {
            if (certDetailInfo.getAlg().contains("1.2.156.10197.1")) {//SM2 OID前半截
                algStr = "SM3WithSM2";
            }
        } else {
            if (AppConfig.getInstance().getCertConfig().getAlgType(chipBeanType, containerNum).equals("SM2")) {
                algStr = "SM3WithSM2";
            }
        }
        if (algStr.length() > 0) {
            signAlg.setText(algStr);
        } else {
            signAlg.setText(certDetailInfo.getAlg());
        }


        String userStr = certDetailInfo.getSubjectCn();
        String userContent = userStr.replaceAll(",", "\n");
        user.setText(userContent);

        String issuerStr = certDetailInfo.getIssuerCn();
        String issuerContent = issuerStr.replaceAll(",", "\n");
        issuer.setText(issuerContent);

        notBefore.setText(certDetailInfo.getNotBefore());
        notAfter.setText(certDetailInfo.getNotAfter());
    }

    private CertDetailInfo getCertDetailInfo() {
        return signCertData != null ? signCertData : encryptCertData;
    }

    /**
     * 证书状态正常
     */
    private void showCertNormal() {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_normal, null);
        certStatus.removeAllViews();
        certStatus.addView(view);

        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate()
                .equals(IsTrue.AYE) && Util.certValidIsExpire(getCertDetailInfo())) {
            //展示更新的弹窗
            if (isShowUpdate) {
                showNotifyDialog();
            }
        }

        showBtn(revoke);

        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals(IsTrue.AYE)) {
            update.setVisibility(View.GONE);
        } else {
            update.setVisibility(View.VISIBLE);
        }
        update.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                //更新证书
                operate_type = UPDATE_CERT_INFO;
                showPinDialog();
            }
        });


        revoke.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });
        revoke_full.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });

    }

    private void showRARevokeReject(@StringRes int strId, String msg) {
        View view = LayoutInflater.from(this).inflate(R.layout.cert_detail_reject_revoke, null);
        certStatus.removeAllViews();
        certStatus.addView(view);

        TextView revokeText = (TextView) view.findViewById(R.id.revoked);
        revokeText.setText(strId);

        TextView reason = (TextView) view.findViewById(R.id.reason);
        String text = getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText(text);

        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate()
                .equals(IsTrue.AYE) && Util.certValidIsExpire(getCertDetailInfo())) {
            //展示更新的弹窗
            if (isShowUpdate) {
                showNotifyDialog();
            }
        }

        showBtn(revoke);

        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals(IsTrue.AYE)) {
            update.setVisibility(View.GONE);
        } else {
            update.setVisibility(View.VISIBLE);
        }
        update.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                //更新证书
                operate_type = UPDATE_CERT_INFO;
                showPinDialog();
            }
        });


        revoke.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });
        revoke_full.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // revokeFull是无证书更新状况下，因为没有更新按钮，所以撤销按钮长度接近布局长度
                // revoke是有证书更新情况下，长度只有布局的一半长

                //撤销证书
                operate_type = REVOKE_CERT;
                showPinDialog();
            }
        });


    }


    private void showUpdateWait(CertState state) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_update_wait, null);

        int strId = 0;

        if (state == CertState.RA_UPDATE_WAIT_56) {
            strId = R.string.cert_creation_cert_update_ra_wait;
        } else if (state == CertState.CERT_STATE_WAIT_VERIFY) {
            strId = R.string.cert_creation_data_need_verify_please_wait_1;
        }

        TextView tvWaitProgress = view.findViewById(R.id.tv_wait_progress);
        if (strId != 0) {
            tvWaitProgress.setText(strId);
        }

        certStatus.removeAllViews();
        certStatus.addView(view);
        showBtn(refresh);
        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //查询证书状态
                queryCertStateFromServer();
            }
        });

    }

    /**
     * 撤销等待审核
     *
     * @param strId
     */
    private void showWaitRevoke(@StringRes int strId) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_wait_agree_revoke, null);

        TextView message = view.findViewById(R.id.revokeInfo2);
        message.setText(strId);

        certStatus.removeAllViews();
        certStatus.addView(view);
        showBtn(refresh);
        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //查询证书状态
                queryCertStateFromServer();
            }
        });

    }

    /**
     * 非本系统证书
     *
     * @param strID
     */
    private void showNoCurrentPki(final int strID) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_verify_fail, null);
        TextView revokeInfo1 = (TextView) view.findViewById(R.id.revokeInfo1);
        revokeInfo1.setText(strID);

        certStatus.removeAllViews();
        certStatus.addView(view);

        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });
    }

    /**
     * 本地有证书，服务端无证书引导用户删除本地证书
     */
    private void showServerNoCert() {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_server_nocert, null);
        certStatus.removeAllViews();
        certStatus.addView(view);
        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });

    }

    /**
     * 证书已撤销
     *
     * @param notify 是否通知列表页更新
     */
    private void showAgreeRevoke(boolean notify) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_agree_revoke, null);

        TextView status = (TextView) view.findViewById(R.id.revoked);
        status.setText(getResources().getString(R.string.cert_creation_detail_revoke_success));
        showBtn(delete);
        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                operate_type = DELETE_CERT;
                showPinDialog();
            }
        });
        certStatus.removeAllViews();
        certStatus.addView(view);

        // 原先这里有个问题，证书已被撤销的情况下，点击证书进入详情页
        // 列表页会因为收到RevokeSuccessEvent的Otto事件导致列表刷新，出现查询的Loading
        // 看上去就和点击列表页出现了Loading一样
        // 为了解决这个问题，增加了notify这个参数
        if (notify) {
            OttoUtil.postRevokeSuccess(new RevokeSuccessEvent(chipBeanType, containerNum));
        }

    }

    /**
     * 状态异常
     *
     * @param message
     */
    private void showException(final String message) {
        View view = LayoutInflater.from(getApplicationContext()).inflate(R.layout.cert_detail_error, null);
        TextView reason = (TextView) view.findViewById(R.id.reason);
        reason.setText(message);


        showBtn(refresh);
        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!bean.getIsVerify()) {
                    showNoCurrentPki();
                } else {
                    queryCertStateFromServer();
                }
            }
        });

        certStatus.removeAllViews();
        certStatus.addView(view);

    }

    private void showNoCurrentPki() {
        showNoCurrentPki(R.string.cert_creation_cert_not_in_system);
    }

    private void showNotifyDialog() {
        showInvalidPermissionDialog();
    }

    /**
     * 显示输入pin码对话框
     */
    private void showPinDialog() {

        if (pinDialog == null) {
            pinDialog = new PinDialog(context, chipBeanType, containerNum, new PinDialog.HandlePinResult() {
                @Override
                public void onSuccess() {
                    if (operate_type == REVOKE_CERT) {
                        //撤销证书
                        startReasonActivity();
                    } else if (operate_type == DELETE_CERT) {
                        //删除证书
                        new ClearContainerTask().execute();
                    } else {
                        //启动更新证书选择界面
                        Intent intent = new Intent(context, UpdateCertActivity.class);
                        intent.putExtra("cardNum", cardID);
                        intent.putExtra("chipBean", bean);
                        intent.putExtra(ActivityParam.CERT_TYPE, certType);
                        startActivity(intent);
                    }
                    operate_type = -1;
                    pinDialog = null;
                }

                @Override
                public void onFail(int pinResult) {
                    //2021/11/19 jff 连接服务器网络异常时，如果是VHSM，pinResult==2131,
                    if (pinResult == 2131) {
                        //详情页，证书状态显示网络异常
                        bean.setState(CertState.NET_TIMEOUT);
                        showCertState();
                    } else {
                        handleErrorResponse(CryptoDevManager.getInstance().getErrorText(pinResult));
                    }
                }
            });
        }
        pinDialog.show();
    }


    private void showCertState() {
        if (!bean.getIsVerify()) {
            showNoCurrentPki();
        } else {
            switch (bean.getState()) {
                case NET_ERROR:
                    showException(getResources().getString(R.string.net_disconnected_text));
                    break;
                case NET_TIMEOUT:
                    showException(getResources().getString(R.string.net_timeout));
                    break;
                case SUCCESS:
                    showCertNormal();
                    break;
                case WAITING_AGREE_REVOKE:
                    //撤销等待中
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;
                case AGREE_REVOKE:
                    //已撤销
                    showAgreeRevoke(false);
                    break;
                case REJECT_REVOKE:
                    showRejectRevoke(R.string.cert_creation_revoke_check_reject, bean.getReason());
                    break;
                case SERVER_NOCERT:
                    showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
                    break;
                case CERT_OUT_OF_DATE:
                    showNoCurrentPki(R.string.cert_creation_cert_out_of_date);
                    break;
                case RA_REVOKE_WAIT_54:
                    showWaitRevoke(R.string.cc_cert_pass_ra_wait);
                    break;

                case RA_REVOKE_WAIT_45:
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;

                case RA_REVOKE_REJECT_55:
                    showRejectRevoke(R.string.cert_creation_revoke_reject, bean.getReason());
                    break;

                case RA_UPDATE_WAIT_56:
                    showUpdateWait(CertState.RA_UPDATE_WAIT_56);
                    break;

                case WAITING_VERIFY:
                    showUpdateWait(CertState.WAITING_VERIFY);
                    break;

                case RA_UPDATE_REJECT_57:
                    showRejectRevoke(R.string.cert_creation_update_check_reject, bean.getReason());
                    break;

                case UPDATE_REJECT_BY_SERVER:
                    showRejectRevoke(R.string.cert_creation_update_check_reject, bean.getReason());
                    break;

            }
        }
    }

    private void startReasonActivity() {
        Intent intent = new Intent(context, ReasonActivity.class);
        intent.putExtra("type", ReasonActivity.REVOKE);
        intent.putExtra("chipBean", bean);
        intent.putExtra("cardId", cardID);
        intent.putExtra(ActivityParam.CERT_TYPE, certType);
        intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
        ModuleLog.e(cardID);
        startActivity(intent);
    }

    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.rl_encrypt_cert) {
            currentSelect = CertType.ENCRYPT;
            updateDivider();
            selectShow();
        } else if (id == R.id.rl_sign_cert) {
            currentSelect = CertType.SIGNING;
            updateDivider();
            selectShow();
        }
    }

    private class ClearContainerTask extends AsyncTask {
        int result;

        @Override
        protected Object doInBackground(Object[] objects) {
            result = DeviceWrapper.getInstance().clearContainer(chipBeanType, containerNum);
            return result;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            showLoading(R.string.cert_creation_is_deleting_cert);

        }

        @Override
        protected void onPostExecute(Object o) {
            super.onPostExecute(o);

            if (result == 0) {
                //通知主页面更新对应状态
                bean.setState(CertState.DELETE_SUCCESS);

                OttoUtil.postCertOperate(containerNum, bean);
                //撤销成功之后发送广播，融合版安全接入断开网关 jff-2020.11.18
                Intent intent = new Intent("com.xdja.aircert.revoke.success");
                context.sendBroadcast(intent);

                dismissLoading();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                finish();
            } else {
                ModuleToast.show(context, getResources().getString(R.string.cert_creation_delete_cert_fail));
                dismissLoading();
            }
        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == ReasonActivity.RECOVERY) {
            // 解冻证书
            String reason = data.getStringExtra("reason");
            recoveryCert(reason);
        }
    }

    @Subscribe
    public void handleRevokeResult(RevokeResultEvent event) {

        CertState state = event.getChipBean().getState();

        if (state == CertState.WAITING_AGREE_REVOKE) {
            showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
        } else if (state == CertState.AGREE_REVOKE) {
            showAgreeRevoke(true);
        } else if (state == CertState.REJECT_REVOKE) {
            showRejectRevoke(R.string.cert_creation_revoke_reject, event.getReason());
        } else if (state == CertState.RA_REVOKE_WAIT_45) {//撤销证书RA审核中
            showWaitRevoke(R.string.cert_creation_ra_wait);
        }

        OttoUtil.postCertOperate(event.getContainerNum(), event.getChipBean());

    }


    private void showRejectRevoke(@StringRes int strId, String msg) {

        View view = LayoutInflater.from(this).inflate(R.layout.cert_detail_reject_revoke, null);
        certStatus.removeAllViews();
        certStatus.addView(view);

        TextView revoke = (TextView) view.findViewById(R.id.revoked);
        revoke.setText(strId);

        TextView reason = (TextView) view.findViewById(R.id.reason);
        String text = getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText(text);


        refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                queryCertStateFromServer();
            }
        });

        refresh.setVisibility(View.VISIBLE);

        delete.setVisibility(View.GONE);

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_cert_detail;
    }

    /**
     * 2.8.【I-airIssue-api-009】证书解冻申请
     */
    private void recoveryCert(String revokeReason) {
        showLoading(R.string.cert_creation_is_recoverying_cert);
        //todo 此处应该加上进度
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showException(getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000);
            return;
        } else {
            showException(getResources().getString(R.string.net_timeout));
        }
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        String sn;
        if (getCertDetailInfo() != null) {
            sn = getCertDetailInfo().getSn();
        } else {
            ModuleLog.e("sn为空");
            return;
        }
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            showPinDialog();
            return;
        } else {
            revokeRequest.setSign(sign);
        }
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));


        certService.thawingCert(revokeRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();

                if (result.equals("0")) {
                    // 正在审核
                    bean.setState(CertState.RECOVERY_PROGRESS);
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(containerNum, bean);  //通知证书列表页更新证书展示状态
                } else if (result.equals("1")) {
                    // 解冻成功
                    bean.setState(CertState.RECOVERY_SUCCESS);
                    OttoUtil.postCertOperate(containerNum, bean); //通知证书列表页更新证书展示状态
                } else if (result.equals("2")) {
                    // 解冻申请拒绝
                    showRejectRevoke(R.string.cert_creation_recovery_fail, commonResponse.getMessage());
                }

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 2.6【I-airIssue-api-007】查询证书状态
     * 查询证书状态
     */
    private void queryCertStateFromServer() {
        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/

        if (!CommonUtil.isNetworkConnected(context)) {

            ModuleToast.show(context, R.string.net_disconnected_text);

            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {

                    showException(getResources().getString(R.string.net_disconnected_text));
                    // 不要把dismissLoading放在外层，否则会立即消失，看上去像dialog没有显示过一样
                    dismissLoading();
                }
            }, 1000);
            return;
        } else {
            //当有网络，但是网络不可用时，弹出dialog框并在1s后关闭，避免造成没执行的假象
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    dismissLoading();
                }
            }, 1000);
        }

        showLoading(R.string.cert_creation_is_checking_cert);

        CertStateRequest certStateRequest = new CertStateRequest();
        if (getCertDetailInfo() != null) {
            //本地有证书，用本地证书的sn查询证书状态
            certStateRequest.setSn(getCertDetailInfo().getSn());
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));

        certService.certStateQuery(certStateRequest, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
                    showException(getResources().getString(R.string.cert_creation_device_not_exist));
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //                    ModuleLog.e("IOException:  " + e);
                //网络异常，请重试
                showException(getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
                //ModuleLog.e("查询证书状态成功result = " + result);
                if (result.equals("0")) {
                    //0表示等待撤销审核，显示撤销信息已提交，等待审核
                    bean.setState(CertState.WAITING_AGREE_REVOKE);
                    showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                } else if (result.equals("1")) {
                    //1-证书已经被注销
                    bean.setState(CertState.AGREE_REVOKE);
                    showAgreeRevoke(true);
                } else if (result.equals("2")) {
                    //2，证书注销申请被拒绝
                    bean.setState(CertState.REJECT_REVOKE);
                    bean.setReason(commonResponse.getMessage());
                    showRejectRevoke(R.string.cert_creation_revoke_check_reject, commonResponse.getMessage());
                } else if (result.equals("3")) {
                    //3-证书状态正常,本地没有找到证书，则再次写卡。
                    bean.setState(CertState.AGREE_UPDATE);
                    showCertNormal();
                } else if (result.equals("4")) {
                    //4-证书不存在查询实体认证结果
                    showServerNoCert();
                } else if (result.equals("5")) {
                    //5-证书被冻结

                } else if (result.equals("6")) {
                    //6-证书处于解冻申请中

                } else if (result.equals("7")) {
                    //7-证书解冻申请被拒绝

                } else if (result.equals("8")) {
                    //8-证书处于延期申请中

                } else if (result.equals("9")) {
                    //9-证书延期申请成功

                } else if (result.equals("10")) {
                    //10-证书延期申请被拒绝

                } else if (result.equals("11")) {
                    // 11-证书处于更新申请中

                } else if (result.equals("12")) {
                    //12-证书更新成功

                } else if (result.equals("13")) {
                    //13 –证书更新申请被拒绝
                    // TODO: 2020/7/17 0017
                    bean.setState(CertState.UPDATE_REJECT_BY_SERVER);
                    bean.setReason(commonResponse.getMessage());
                    showRejectRevoke(R.string.cert_creation_update_check_reject, bean.getReason());
                } else if (result.equals("14")) {
                    //14-证书已过期

                } else if (result.equals("55")) {
                    // 55-RA撤销审核拒绝

                    bean.setState(CertState.RA_REVOKE_REJECT_55);
                    bean.setReason(commonResponse.getMessage());

                    showRejectRevoke(R.string.cert_creation_revoke_check_reject, bean.getReason());


                } else if (result.equals("56")) {
                    bean.setState(CertState.RA_UPDATE_WAIT_56);
                    showUpdateWait(CertState.RA_UPDATE_WAIT_56);
                } else if (result.equals("47")) {
                    // 47 - 等待签发
                    // 现在只有更新用户信息和有效期才能进入到详情页里
                    applyRAstatus(PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(
                            chipBeanType, containerNum, getCertDetailInfo().getSubjectCn(), false));

                } else if (result.equals("57")) {
                    // 57-RA更新审核拒绝
                    bean.setState(CertState.RA_UPDATE_REJECT_57);
                    bean.setReason(commonResponse.getMessage());
                    showRejectRevoke(R.string.cert_creation_update_check_reject, commonResponse.getMessage());

                } else if (result.equals("54")) {
                    // 54-RA撤销申请审核中
                    bean.setState(CertState.RA_REVOKE_WAIT_54);
                    showWaitRevoke(R.string.cc_cert_pass_ra_wait);
                }
                OttoUtil.postCertOperate(containerNum, bean);  //通知证书列表页更新证书展示状态
                dismissLoading();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //404	0x10a4	cert_status_other 	证书状态异常
                //400	0x10a3	cert_revoke_fail	证书注销失败
                //String message = baseErrorResponse.getMessage();
                //ModuleLog.e("查询证书状态失败message: " + message);
                handleErrorResponse(baseErrorResponse.getErrCode());
                dismissLoading();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    /**
     * 2.27.【I-airIssue-api-0027】证书申请状态查询
     *
     * @param p10
     */
    private void applyRAstatus(final String p10) {

        if (!CommonUtil.isNetworkConnected(context)) {
            ModuleToast.show(context, R.string.net_disconnected_text);
            return;
        }

        CertApplyRequest certApplyRequest = getCertApplyReq(p10);

        if (certApplyRequest == null) {
            return;
        }

        certService.applyRAStatus(certApplyRequest, cardID, new HttpResponseCallBack<CertApplyRAStatusResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                if (result.equals("1")) {//1签发证书成功
                    String cert = certApplyResponse.getMessage();
                    //Log.e("jff", "2085 CertItemView onSuccessfulResponse cert : " + cert);
                    // 这个substring截取是为了去掉接口返回值中非证书格式的部分
                    // 第0至第9位为-----BEGIN CERTIFICATE-----之前的部分，即{"cert":"
                    // 最后两位为----END CERTIFICATE-----之后的部分，即"}

                    // 现在服务端返回部分内容举例
                    //  {"cert":"-----BEGIN CERTIFICATE-----\nMIIETTCCAzWg
                    // ***
                    // OytQw==\n-----END CERTIFICATE-----#55E12E91650D2FEC56EC74E1D3E4DDBFCE2EF3A65890C2A19ECF88A307E76A23"}

                    cert = cert.substring(9, cert.length() - 2);
                    WriteCertTask task = new WriteCertTask(cert);
                    task.execute();

                } else if (result.equals("52")) {//45-RA审核中
                    showWaitRevoke(R.string.cert_creation_cert_update_ra_wait);
                } else if (result.equals("53")) {//46-RA审核拒绝
                    //showRejectRevoke(R.string.cert_creation_cert_update_ra_reject,);
                    //showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                    //        , context.getString(R.string.cert_creation_ra_reject), true);

                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    class WriteCertTask extends AsyncTask<Void, Void, Integer> {

        private String cert;

        public WriteCertTask(String cert) {
            this.cert = cert;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            showLoading(R.string.cert_creation_is_update_cert);
        }

        @Override
        protected Integer doInBackground(Void... voids) {

            int result = DeviceWrapper.getInstance().writeUpdateCert(chipBeanType, containerNum, cert);

            return result;
        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);

            if (integer == 0) {

                CertDetailInfo afterUpdate = DeviceWrapper.getInstance().readCertFromContainer(chipBeanType, containerNum,

                        certType);

                String rest = updateCertValue(afterUpdate);
                if (!TextUtils.isEmpty(rest)) {
                    CertDetailInfo another = DeviceWrapper.getInstance().readCertFromContainer(chipBeanType, containerNum,
                            certType);
                    updateCertValue(another);
                }

                selectShow();

                showCertNormal();

                //通知列表页面更新证书状态
                bean.setState(CertState.AGREE_UPDATE);
                bean.setCertDetailInfo(certType.equals(CertType.SIGNING) ? signCertData : encryptCertData);
                OttoUtil.postCertOperate(containerNum, bean);

                dismissLoading();

            } else {
                writeCertToServer(chipBeanType, DeviceWrapper.getInstance().getSn(chipBeanType, containerNum, cert), "1");
            }
        }


    }


    //写卡状态上报
    private void writeCertToServer(CryptoDevType type, String sn, String status) {
        WriteFailRequest request = new WriteFailRequest();

        WriteFailInfo info = new WriteFailInfo();


        info.setSn(sn);
        info.setStatus(status);
        info.setTime(System.currentTimeMillis());
        request.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(type, containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            showException(sign.substring(9));
            return;
        } else {
            request.setSign(sign);
        }

        request.setCardType("" + CryptoDevTypeUtil.convertCardType(type.getType()));

        certService.uploadWriteCertResult(request, cardID, new HttpResponseCallBack<CommonResponse>() {
                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        //网络异常，请重试
                        int netRes;
                        if (!CommonUtil.isNetworkConnected(context)) {
                            netRes = R.string.net_disconnected_text;
                        } else {
                            netRes = R.string.net_timeout;

                        }
                        //                            ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                        showException(getResources().getString(netRes));
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {

                        //                            ModuleLog.e("onSuccessfulResponse " + commonResponse.getResult());
                        showException(getResources().getString(R.string.cert_creation_write_authentiation_fail));
                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                        //                    404	0x10a4	cert_status_other 	证书状态异常
                        //                    400	0x10a3	cert_revoke_fail	证书注销失败
                        //                        String message = baseErrorResponse.getMessage();
                        //                            ModuleLog.e("onFailResponse " + message);
                        handleErrorResponse(baseErrorResponse.getErrCode());
                    }

                    @Override
                    public void dismissDialog() {

                    }
                }
        );
    }


    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {

        //服务端通过审核撤销成功，客户端展示对应的提示
        if (errorCode.equals(OkNetError.NOT_EXIST_INFO_CODE)) {
            showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
            //更改列表页证书状态
            bean.setState(CertState.AGREE_REVOKE);

            OttoUtil.postCertOperate(containerNum, bean);

        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this, errorCode);
            showException(msg);
        }

    }

    @Subscribe
    public void handleUpdateCertStateEvent(UpdateCertStateEvent event) {
        ModuleLog.e("handleUpdate");
        showWaitRevoke(event.getResult());
    }

    private CertApplyRequest getCertApplyReq(String p10) {

        if (TextUtils.isEmpty(p10)) {
            return null;
        }

        //如果申请p10失败，则直接展示申请证书失败页面。
        if (p10.startsWith("errorCode")) {

            if (p10.contains("^[0-6]*$")) {
                // TODO: jff 2018-12-15 该出需要分析具体该怎么处理 第六迭代
                // dialog.show();
            }
            handleErrorResponse(p10.substring(9));
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return null;
        } else if (p10.isEmpty()) {
            //TODO JFF 18.7.24展示错误信息
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }

        CertApplyRequest certApplyRequest = new CertApplyRequest();

        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(context));
        certApplyRequest.setChipInfo(chipInfo);

        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);

        if (!AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE)) {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getIDCardNo(context, chipBeanType.getType()));
        } else {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getPhoneNum(context));
        }
        certApplyRequest.setP10(p10);
        return certApplyRequest;
    }


    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (getClass().getName().equals(activity.getTag())) {
            finish();
            overridePendingTransition(0, 0);
        }
    }


}
