package com.xdja.safeclient.certcreation.bean;

import android.support.annotation.NonNull;

import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;

/**
 * Created by gyx on 2018/7/3.
 */

public class CertItemBean implements Comparable<CertItemBean> {

    /**
     *
     */
    private CryptoDevInfo cryptoDevInfo;

    /**
     *
     * */
    private TableCertConfig certConfig;

    public TableCertConfig getCertConfig() {
        return certConfig;
    }

    public void setCertConfig(TableCertConfig certConfig) {
        this.certConfig = certConfig;
    }

    public CryptoDevInfo getCryptoDevInfo() {
        return cryptoDevInfo;
    }

    public void setCryptoDevInfo(CryptoDevInfo cryptoDevInfo) {
        this.cryptoDevInfo = cryptoDevInfo;
    }

    /**
     * 根据order进行排序
     *
     * @return
     */
    private int getOrder() {

        // 客户端密码模块展示先后顺序：内置安全芯片、智能薄膜卡、TF卡、XDJA_VHSM
        //
        if (cryptoDevInfo.getType() == CryptoDevType.DEV_TYPE_Chip) {
            return 1 * 100 + certConfig.getContainerNum();
        } else if (cryptoDevInfo.getType() == CryptoDevType.DEV_TYPE_SimKey) {
            return 2 * 100 + certConfig.getContainerNum();
        } else if (cryptoDevInfo.getType() == CryptoDevType.DEV_TYPE_SdCard) {
            return 3 * 100 + certConfig.getContainerNum();
        } else if (cryptoDevInfo.getType() == CryptoDevType.DEV_TYPE_Soft) {
            return 4 * 100 + certConfig.getContainerNum();
        } else {
            return 5 * 100 + certConfig.getContainerNum();
        }
    }

    @Override
    public int compareTo(@NonNull CertItemBean certItemBean) {
        return this.getOrder() - certItemBean.getOrder();
    }

    @Override
    public String toString() {
        return certConfig.toString();
    }
}
