package com.xdja.safeclient.certcreation.device;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;

import com.aircert.ApplicationContext;
import com.aircert.util.ModuleLog;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.vhsm.base.VHSMBase;
import com.xdja.vhsm.base.VHSM_INIT_PARAM;
import com.xdja.vhsm.base.VHSM_SERVER_INFO;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

/**
 * 联网卡VHSM相关操作
 * Created by jff on 2019/7/8.
 */
public class NetVHSMHandle {
    /**
     * vhsm初始化
     *
     * @param context
     * @param ip      联机版服务端的ip
     * @param port    联机版服务端的port
     * @return 初始化结果
     */
    public static void initVHSM(final Context context, final String ip, final int port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                NetRespository netRespository = NetRespository.create(context, ip, port);
                int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
                ModuleLog.e("vhsm initResult =  " + initResult);
                if (initResult == 0) {//联网版VHSM初始化成功
                    ModuleLog.e("VHSM初始化成功");
                    int initFile = NetRespository.initVhsmlibFile(context, ip, port);
                    Message msg = new Message();
                    msg.obj = "success";
                    Bundle data = new Bundle();
                    data.putInt("value", initFile);
                    msg.setData(data);
                    handler.sendMessage(msg);
                } else {
                    Message msg = new Message();
                    msg.obj = "fail";
                    Bundle data = new Bundle();
                    data.putInt("value", initResult);
                    msg.setData(data);
                    handler.sendMessage(msg);
                }
            }
        }).start();

    }

    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    private static String getNetVhsmCardId_1(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId(NetVhsmDeviceIdUtils.getDevId(context));
        ModuleLog.i("NetVhsmCardId : " + netVhsmCardId);
        return netVhsmCardId;
    }


    /**
     * vhsm初始化
     *
     * @param context
     * @param ip      联机版服务端的ip
     * @param port    联机版服务端的port
     * @return 初始化结果
     */
    public static void initVHSM(final Context context, final String ip, final int port, final String phoneStr, final byte[] sig) {
        int ret = 0;

        ModuleLog.i("start initVHSM : ");
        VHSM_SERVER_INFO serverInfo = new VHSM_SERVER_INFO();

        VHSMBase vhsm = new VHSMBase();

        if (ApplicationInit.isMultiPackageName(ApplicationContext.getContext())) {
            //设置VHSM的路径
            vhsm.SetDevPath(ApplicationInit.privatePath().getBytes());
        }

        byte[] buf = new byte[1024];
        int[] len = new int[1];

        vhsm.GetVersion(buf, len);
        vhsm.GetDateTime(buf, len);

        ret = vhsm.InitVHSM(vhsm.OP_CHECK, null);
        ModuleLog.e("initVHSM ret : " + ret);
        if (ret != vhsm.VHSM_RET_OK) {
            // 设置服务器信息
            serverInfo.addrType = vhsm.ADDR_IP;
            System.arraycopy(ip.getBytes(StandardCharsets.UTF_8), 0, serverInfo.ip, 0, ip.length());
            serverInfo.port = port;
            serverInfo.serverType = vhsm.SERVER_PRI;
            ret = vhsm.SetServerInfo(serverInfo);
            ModuleLog.e("initVHSM ret: " + ret);
            if (ret != vhsm.VHSM_RET_OK) {
                ModuleLog.e("initVHSM : ");
                return;
            }

            byte[] nameB = new byte[]{};
            String name = SharePreferencesUtil.getName(context);
            if (name != null && name.length() > 0) {
                nameB = name.getBytes(StandardCharsets.UTF_8);
            }

            byte[] phone = phoneStr.getBytes(StandardCharsets.UTF_8);
            String deptStr = "暂无";
            byte[] deptB = deptStr.getBytes(StandardCharsets.UTF_8);

            // 对 [name]#[phone]#[dept] 签名
            byte[] signature = sig;

            VHSM_INIT_PARAM param = new VHSM_INIT_PARAM();
            System.arraycopy(nameB, 0, param.name, 0, nameB.length);
            System.arraycopy(phone, 0, param.phone, 0, phone.length);
            System.arraycopy(deptB, 0, param.dept, 0, deptB.length);
            System.arraycopy(signature, 0, param.signature, 0, signature.length);

            param.initType = vhsm.INIT_TRUST;
            ret = vhsm.InitVHSM(vhsm.OP_INIT, param);
            ModuleLog.e("initVHSM ret : " + ret);
            if (ret != vhsm.VHSM_RET_OK) {
                Message msg = new Message();
                msg.obj = "fail";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            } else {
                ModuleLog.e("VHSM初始化成功");
                //int initFile = NetRespository.initVhsmlibFile(context, ip, port);
                Message msg = new Message();
                msg.obj = "success";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            }


            // 初始化并加载设备
            ret = vhsm.InitVHSM(vhsm.OP_QUERY, param);
            System.out.println("VHSM_InitVHSM（VHSM_OP_QUERY） return " + ret);
            //param.state = VHSM_APPLY_STATE_NOTAPPLY;
            if (ret != vhsm.VHSM_RET_OK) {
                return;
            }

        }

    }

    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    private static String getNetVhsmCardId() {
        byte[] buf = new byte[1024];
        int[] len = new int[1];
        VHSMBase vhsmBase = new VHSMBase();

        vhsmBase.GetSerialNumber(buf, len);
        vhsmBase.GetCardIdBySerialNumber(buf, len[0], buf, len);

        String netVhsmCardId = new String(Arrays.copyOf(buf, len[0]));
        return netVhsmCardId;
    }

    public static String getNetVhsmCardId(Context context) {
        if (CardType.REQUEST_PARAM_ONLINE_VHSM.equals("1")) {
            return getNetVhsmCardId_1(context);
        } else {
            return getNetVhsmCardId();
        }
    }


    private static Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            int initFile = (int) msg.getData().get("value");
            OttoUtil.postNet_VHSMinitResult(initFile);
        }
    };


    /**
     * @return 0 根目录可用  1 私有目录可用  2 都不可用
     */
    public static int isNetVHSMCanUse() {
        String rootPath = ApplicationInit.rootPath();
        File storageDir = Environment.getExternalStorageDirectory();

        String privatePath = ApplicationInit.privatePath();
        //根目录下是否可用：
        if (!isFileExist(rootPath, storageDir)) {
            //根目录不可用 1.继续检查私有目录文件是否可用
            if (isFileExist(privatePath, null)) {
                return 1;
            } else {
                return 2;
            }
        } else {
            //根目录可用使用根目录
            return 0;
        }
    }


    private static File getFile(File storageDir, String childPath) {
        File file;
        if (null == storageDir) {
            file = new File("", childPath);
        } else {
            file = new File(storageDir, childPath);
        }
        return file;
    }

    private static boolean isFileExist(final String file_Dir, File storageDir) {
        String randFilePath = file_Dir + "/rand.bin";
        String kdatFilePath = file_Dir + "/vhsm.dat";
        String wboxFilePath = file_Dir + "/wbox.lib";
        String vhsmLibFilePath = file_Dir + "/vhsm.lib";


        File randFile = getFile(storageDir, randFilePath);
        ModuleLog.e("randFilePath : " + randFilePath);
        if (!randFile.exists()) {
            ModuleLog.e("null ");
            return false;
        }

        File kdatFile = getFile(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        File wboxFile = getFile(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File vhsmLibFile = getFile(storageDir, vhsmLibFilePath);
        if (!vhsmLibFile.exists()) {
            return false;
        }
        return true;
    }

}
