package com.xdja.safeclient.certcreation.task;

import android.app.Activity;
import android.content.Context;

import java.util.Stack;

/**
 * modify by wanghao 2018-08-07
 */
public class AirActivityStackManager {

    private static AirActivityStackManager instance;

    public static AirActivityStackManager getInstance() {
        if (instance == null) {
            instance = new AirActivityStackManager();
        }
        return instance;
    }

    private Stack<Activity> stack = new Stack<>();


    public void add(Activity activity) {
        stack.add(activity);
    }

    public void remove(Activity activity) {
        stack.remove(activity);
    }

    public void removeAll() {
        for (Activity activity : stack) {
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
        setMainContext(null);
        stack.clear();
    }

    /**
     * 返回当前应用内栈顶的activity
     *
     * @return
     */
    public Context getTopContext() {
        if (stack.size() <= 0) {
            return null;
        }
        return stack.get(0);
    }


    public Stack<Activity> getActviityContext() {
        return stack;
    }

    private Context mContext;

    /**
     * 得到MainActivity
     *
     * @return
     */
    public void setMainContext(Context activity) {
        mContext = activity;
    }

    public Context getMainActivity() {
        return mContext;
    }

}
