package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by yangpeng on 2018/4/25.
 */

public class SharePreferencesUtil {

    /**
     * 保存手机号到本地
     */
    public static void savePhone(Context context, String phone) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("phone", phone);
        edit.commit();
    }

    /**
     * 获取手机号
     *
     * @param context
     * @return
     */
    public static String getPhoneNum(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String phone = sharedPreferences.getString("phone", "");
        return phone;
    }

    /**
     * 保存身份证号
     *
     * @param context
     * @param identityNum
     * @param type
     */
    public static void saveIDCardNo(Context context, int type, String identityNum) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        sharedPreferences.edit().putString("identityNum" + type, identityNum).commit();

    }

    /**
     * 获取身份证号
     *
     * @param context
     * @param type
     * @return
     */
    public static String getIDCardNo(Context context, int type) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        return sharedPreferences.getString("identityNum" + type, "");
    }


    /**
     * 存储实体认证结果
     *
     * @param context
     * @param result
     */
    public static void saveCheckResult(Context context, int type, int result) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        //        ModuleLog.e("保存实体认证结果( " + "checkResult_" + type + ") result = " + result);
        sharedPreferences.edit().putInt("checkResult_" + type, result).commit();
    }


    /**
     * 获取实体认证结果
     *
     * @param context
     * @return
     */
    public static int getCheckResult(Context context, int type) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        //        ModuleLog.e("读取实体认证结果( " + "checkResult_"+ type + ")");
        int devType = sharedPreferences.getInt("checkResult_" + type, -1);
        return devType;

    }


    /**
     * 存储当前操作的设备
     *
     * @param context
     * @param type    设备类型
     */
    public static void saveCurrentDevType(Context context, int type) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        sharedPreferences.edit().putInt("current_dev_type", type).commit();
    }

    /**
     * 获取当前操作的设备类型
     *
     * @param context
     * @return 设备类型
     */
    public static int getCurrentDevType(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        int devType = sharedPreferences.getInt("current_dev_type", -1);
        return devType;

    }

    /**
     * @param context
     * @param devCardID 设备类型
     */
    public static void saveDevCardID(Context context, String devCardID) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        sharedPreferences.edit().putString("current_dev_id", devCardID).commit();
    }

    /**
     * @param context
     * @return 卡ID
     */
    public static String getDevCardID(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String devType = sharedPreferences.getString("current_dev_id", "");
        return devType;

    }

    public static void saveSex(Context context, int type, int sex) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        sharedPreferences.edit().putInt("sex_" + type, sex).commit();
    }

    public static int getSex(Context context, int type) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        int devType = sharedPreferences.getInt("sex_" + type, 1);
        return devType;
    }

    /**
     * 保存名字到本地
     */
    public static void saveName(Context context, String name) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("name", name);
        edit.commit();
    }

    /**
     * 获取名字
     *
     * @param context
     * @return
     */
    public static String getName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String name = sharedPreferences.getString("name", "");
        return name;
    }

    public static void saveActivityObjectName(Context context, String object) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("objectName", object);
        edit.commit();
    }

    public String getActivityObjectName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String object = sharedPreferences.getString("objectName", "");
        return object;
    }


    /**
     * 使用SharedPreference保存序列化对象
     * 用Base64.encode将字节文件转换成Base64编码保存在String中
     *
     * @param context 上下文
     * @param key     储存对象的key
     * @param object  object对象  对象必须实现Serializable序列化，否则会出问题，
     *                out.writeObject 无法写入 Parcelable 序列化的对象
     */
    public static void saveObject(Context context, String key, Object object) {
        SharedPreferences sp = context.getSharedPreferences("cert_airIssue", Context.MODE_PRIVATE);
        //创建字节输出流
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        //创建字节对象输出流
        ObjectOutputStream out = null;
        try {
            //然后通过将字对象进行64转码，写入sp中
            out = new ObjectOutputStream(baos);
            out.writeObject(object);
            String objectValue = new String(Base64.encode(baos.toByteArray(), Base64.DEFAULT));
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(key, objectValue);
            editor.commit();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (baos != null) {
                    baos.close();
                }

                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 获取SharedPreference保存的对象
     * 使用Base64解密String，返回Object对象
     *
     * @param context 上下文
     * @param key     储存对象的key
     * @param <T>     泛型
     * @return 返回保存的对象
     */
    public static <T> T getObject(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences("cert_airIssue", Context.MODE_PRIVATE);
        if (sp.contains(key)) {
            String objectValue = sp.getString(key, null);
            byte[] buffer = Base64.decode(objectValue, Base64.DEFAULT);
            //一样通过读取字节流，创建字节流输入流，写入对象并作强制转换
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                T t = (T) ois.readObject();
                return t;
            } catch (StreamCorruptedException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }

                    if (ois != null) {
                        ois.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * 是否已导出到本地
     */
    public static void saveExportState(Context context, boolean state) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putBoolean("export", state);
        edit.commit();
    }

    /**
     * 获取是否已导出到本地
     *
     * @param context
     * @return
     */
    public static boolean getExportState(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        boolean state = sharedPreferences.getBoolean("export", false);
        return state;
    }


    /**
     * 保存云从授权码
     */
    public static void saveLicense(Context context, String license) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("license", license);
        edit.commit();
    }

    /**
     * 获取云从授权码
     *
     * @param context
     * @return
     */
    public static String getLicense(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String state = sharedPreferences.getString("license", "");
        return state;
    }

    /**
     * 保存VHSM服务端地址
     */
    public static void saveVHSMUrl(Context context, String url) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("vhsmUrl", url);
        edit.commit();
    }

    /**
     * 获取VHSM服务端地址
     *
     * @param context
     * @return
     */
    public static String getVHSMUrl(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        String url = sharedPreferences.getString("vhsmUrl", "");
        return url;
    }

    public static void saveSelfieStep(Context context, int step) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putInt("step", step);
        edit.commit();
    }

    public static int getSelfieStep(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        int step = sharedPreferences.getInt("step", 0);
        return step;
    }


    public static void saveContainerNum(Context context, String cardType, int containerNum) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putInt(cardType, containerNum);
        edit.commit();
    }

    public static int getContainerNum(Context context, String cardType) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("cert_airIssue", MODE_PRIVATE);
        int containerNum = sharedPreferences.getInt(cardType, 0);
        return containerNum;
    }


}
