package ocr.activity;

import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.request.RevokeOwnOldCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.response.SigResultResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.IOException;

import ocr.bean.IDCardInfo;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;


/**
 * 展示实体认证自动审核失败的结果
 * todo 2019-08-13 该界面非身份证信息自动识别IDCardInfo是否为null，需要进一步确认
 * Created by jff on 2018/9/28.
 */
public class AuthenticationFailActivity extends BaseActivity {

    private TextView fail_reason;
    private TextView one_fail_reason;
    private Button retry;

    public CompareResult compareResult;

    public CryptoDevType currentChipBeanType;

    public IDCardInfo info;

    public String faceImg;

    public int containerNum;

    /**
     * 重试
     */
    private final int ERROR_RETRY = 1;
    /**
     * 重新申请
     */
    private final int ERROR_REAPPLY = 2;
    private int error = ERROR_RETRY;

    private String errorMsg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.compare_fail);

        getErrorCode();

        initView();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        compareResult = (CompareResult) getIntent().getSerializableExtra("result");
        currentChipBeanType = (CryptoDevType) getIntent().getSerializableExtra("devType");
        info = getIntent().getParcelableExtra("identify_info");
        faceImg = ImageCache.getInstance().getSelfie();
        containerNum = getIntent().getIntExtra(CONTAINER_NUM, 0);
    }

    private void initView() {
        LinearLayout normalFail = findViewById(R.id.normal_fail);
        LinearLayout one_fail = findViewById(R.id.one_fail);
        if (errorMsg.contains(this.getString(R.string.cert_creation_one_person_one_cert))
                || errorMsg.contains(getString(R.string.cert_creation_one_person_one_cardType_one_cert))) {
            one_fail.setVisibility(View.VISIBLE);
            normalFail.setVisibility(View.GONE);
        } else {
            one_fail.setVisibility(View.GONE);
            normalFail.setVisibility(View.VISIBLE);
        }

        fail_reason = (TextView) findViewById(R.id.reason);
        // FIXME: 2018/12/26 0026 这个unknown_error肯定是有问题的
        if (errorMsg.equals(getString(R.string.cert_creation_unknown_error))
                && ((compareResult.getMessage().equals(getString(R.string.cert_creation_get_imsi_failed))))
                || (compareResult.getMessage().equals(getString(R.string.net_disconnected_text))
        )) {
            fail_reason.setText(compareResult.getMessage());
        } else {
            fail_reason.setText(errorMsg);
        }

        initOnePersonOneCert();

        retry = (Button) findViewById(R.id.retry);
        if (error == ERROR_RETRY) {
            //重新提交
            retry.setText(getResources().getString(R.string.cert_creation_identify_again));
        } else {
            //重新申请
            retry.setText(getResources().getString(R.string.cert_creation_apply_again));
        }

        retry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // 重新提交
                if (error == ERROR_RETRY) {

                    // TODO: 2019/2/12 0012 之后再重构请求这里

                    request();

                } else {
                    // 重新申请
                    // 先结束SelfieActivity的原因是，SelfieActivity的背景属性android:windowIsTranslucent = false
                    //            如果直接顺次结束Activity，会导致出现黑屏
                    //            因此先结束改Activity，此时界面依然处于最上层界面，用户无感知。之后顺次结束不再会有黑屏的问题
                    OttoUtil.post(new SpecificActivity(SelfieActivity.class));

                    // 重新申请，把Activity都结束掉，回到列表页
                    OttoUtil.postFinishActivity();

                }
            }
        });

    }


    /**
     * 一人一卡一证及一人一证错误提示界面内容
     */
    private void initOnePersonOneCert() {
        TextView fail_reason_detail = findViewById(R.id.fail_reason_detail);
        if (compareResult.getResult().matches(OkNetError.ONE_PERSON_ONE_CERT_CODE)) {//0x1034  一人一证
            fail_reason_detail.setText(getResources().getString(R.string.cert_creation_one_person_one_cert_detail));
        }
        if (compareResult.getResult().matches(OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE)) {//0x1033  一人一卡一证
            fail_reason_detail.setText(getResources().getString(R.string.cert_creation_one_person_one_cardType_one_cert_detail));
        }

        one_fail_reason = findViewById(R.id.one_fail_reason);
        one_fail_reason.setText(errorMsg);

        Button cancel = findViewById(R.id.btn_cancel);
        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                OttoUtil.postFinishActivity();
            }
        });
        Button commit = findViewById(R.id.btn_commit);
        commit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showLoading(R.string.cert_creation_is_revoking_cert);
                revokeOwnOldCert();
            }
        });
    }

    // TODO: 2019/8/15 jff 该方法入参的目的是什么
    private void initView(CryptoDevType currentChipBeanType, CompareResult compareResult) {
        this.currentChipBeanType = currentChipBeanType;
        this.compareResult = compareResult;
        initView();
    }

    // TODO: 2019/8/15 jff 是否需要带参数的这个方法
    private void getErrorCode(CompareResult compareResult) {
        this.compareResult = compareResult;
        getErrorCode();
    }

    private void getErrorCode() {

        String errorCode = compareResult.getResult();
        errorMsg = OkNetError.handleErrorCodeToMsg(this, errorCode);
        if (errorCode.matches(OkNetError.CAALG_ERROR_CODE)
                || compareResult.getMessage().equals(getString(R.string.net_disconnected_text))) {
            error = ERROR_RETRY;
        } else {
            error = ERROR_REAPPLY;
        }
    }

    private void revokeOwnOldCert() {
        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType chipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(chipBeanType);

        RevokeOwnOldCertRequest revokeOwnOldCertRequest = new RevokeOwnOldCertRequest();
        revokeOwnOldCertRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
        service.revokeOwnOldCert(revokeOwnOldCertRequest, cardID, new HttpResponseCallBack<SigResultResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {

            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                currentChipBeanType = chipBeanType;
                String identity;
                if (info != null) {
                    identity = info.getIdNum();
                    SharePreferencesUtil.saveIDCardNo(getContext(), devType, info.getIdNum());
                } else {
                    identity = SharePreferencesUtil.getIDCardNo(getContext(), chipBeanType.getType());
                }
                compareResult.setResult(commonResponse.getResult());

                //2021.12.27 jff ver2.3接口文档，3.26接口返回值变更
                //撤销老卡证书message包含dn和sig两个字段
                String msg = commonResponse.getMessage();
                String dn = commonResponse.getDn();
                String sig =commonResponse.getSig();

                compareResult.setMessage(msg);
                compareResult.setDn(dn);
                compareResult.setSig(sig);
                compareResult.setIdentity(identity);
                compareResult.setSuccess(true);

                handleAuthSuccess();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handAuthFail(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    @Override
    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_failed;
    }

    /**
     * 开始上传数据进行比对
     */
    private void request() {
        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(this, R.string.cert_creation_card_device_error);
            return;
        }

        CompareCardInfoAndFaceInfoRequest request = buildRequest();

        // TODO: 2019/2/12 0012 这里有一个问题
        // 多次调用showLoading时，可能出现Loading不显示的问题
        // 所以这个地方加个异步，在dismiss的时候加个异步
        // 理想状况下，出现问题的可能性很小
        // 但是之后依然需要找下出现问题的原因
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                showLoading();
            }
        }, 100);


        entityAuthAndHandResult(request, cardID, devType);

    }


    /**
     * 实体认证请求及结果处理
     *
     * @param request
     * @param cardID
     * @param devType
     */
    private void entityAuthAndHandResult(CompareCardInfoAndFaceInfoRequest request, String cardID, final int devType) {
        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //                ModuleLog.e("认证返回结果code= " + commonResponse.getResult());

                SharePreferencesUtil.saveIDCardNo(getContext(), devType, info.getIdNum());

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(info.getIdNum());
                compareResult.setSuccess(true);

                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有

                    getErrorCode(compareResult);
                    initView(currentChipBeanType, compareResult);

                } else {
                    handleAuthSuccess();
                }
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //                ModuleLog.e("认证失败");

                handAuthFail(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        dismissLoading();
                    }
                }, 500);
            }
        });
    }

    /**
     * 实体认证成功的处理
     */
    private void handleAuthSuccess() {
        dismissLoading();
        AuthResult auth = new AuthResult(currentChipBeanType, containerNum, compareResult, RequestCache.getInstance().getObject());
        OttoUtil.postAuthResult(auth);
        OttoUtil.postFinishActivity();
    }

    /**
     * 实体认证失败的错误
     *
     * @param baseErrorResponse 认证失败返回的错误信息
     */
    private void handAuthFail(BaseErrorResponse baseErrorResponse) {

        compareResult.setResult(baseErrorResponse.getErrCode());
        compareResult.setMessage(baseErrorResponse.getMessage());
        compareResult.setIdentity(info.getIdNum());
        compareResult.setSuccess(false);

        getErrorCode(compareResult);
        initView(currentChipBeanType, compareResult);
    }


    /**
     * 构建实体认证请求参数
     *
     * @return 实体认证请求参数
     */
    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();

        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));
        //ModuleLog.e("实体验证  卡类型 " + Util.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));

        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM)) {
            chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this));

        request.setIdCardInfo(info);
        request.setChipInfo(chipInfo);
        request.setFaceImg(faceImg);
        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(currentChipBeanType, containerNum));
        return request;

    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        finish();
    }


}
