package ocr.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.event.LiveResult;
import com.aircert.event.YuncongAuth;
import com.aircert.util.ModuleLog;
import com.baidu.idl.face.example.FaceLivenessExpActivity;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.listener.IInitCallback;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.KuangshiResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.config.FaceLicenseConfig;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.Base64Util;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.FaceInterface;
import cn.cloudwalk.libproject.Bulider;
import cn.cloudwalk.libproject.LiveActivity;
import cn.cloudwalk.libproject.callback.NoDoubleClickListener;
import cn.cloudwalk.libproject.progressHUD.CwProgressHUD;
import cn.cloudwalk.libproject.util.FileUtil;
import cn.cloudwalk.libproject.util.LogUtils;
import okhttp3.Call;

import static cn.cloudwalk.libproject.util.FileUtil.assetsDataToDest;
import static cn.cloudwalk.libproject.util.FileUtil.unZipFolder;

/**
 * Created by yangpeng on 2018/3/20.
 */

public class LiveStartActivity extends BaseActivity {
    public final String TAG = LogUtils.makeLogTag("LiveStartActivity");
    public static final String MODULES = "modules";//模型文件根目录
    public static final String MODULES_ZIP = "modules.zip";//模型文件压缩包
    private Button mBt_startdect;
    private CwProgressHUD processDialog;// 进度框

    TextView tv_tips1;

    public int containerNum;
    private String liveCompany;

    @Override
    protected int getToolbarType() {
        return ToolBarDef.NAVIGATE_BACK;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_live_start);

        tv_tips1 = findViewById(R.id.hint1);
        liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();
        if (ScreenUtil.isFullScreen(this)) {

            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

            layoutParams.setMargins(0, ScreenUtil.dip2px(this, 50), 0, 0);
            layoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
            tv_tips1.setLayoutParams(layoutParams);


        }

        prepare();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();

        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);

    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (getClass().getName().equals(activity.getTag())) {
            finish();
        }
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        finish();
    }

    @Subscribe
    public void handleLiveResult(LiveResult liveResult) {
        String img = liveResult.getImg();
        if (img != null && img.length() > 0) {
            gotoNext(liveResult.getImg());
        }
    }

    private Bulider builder;

    private void prepare() {

        mBt_startdect = (Button) findViewById(R.id.start);
        mBt_startdect.setOnClickListener(new NoDoubleClickListener() {

            @Override
            public void onNoDoubleClick(View v) {

                if (ContextCompat.checkSelfPermission(LiveStartActivity.this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(LiveStartActivity.this,
                            new String[]{Manifest.permission.CAMERA},
                            PERMISSION_CODE);
                } else {
                    start();
                }

            }
        });
    }

    public static final int PERMISSION_CODE = 23;

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (permissions[0].equals(Manifest.permission.CAMERA) && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            start();
        }

    }

    @Subscribe
    public void handleYuncongAuth(YuncongAuth yuncongAuth) {
        getYunCongLicense();
    }

    private void getYunCongLicense() {
        new CertService().getOcrAuthCode(SharePreferencesUtil.getDevCardID(this), new HttpResponseCallBack<CommonResponse>() {

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {

            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {

                if (commonResponse.getResult().equals("0")) {
                    String license = commonResponse.getMessage();
                    if (license != null && license.length() > 0) {
                        Bulider.setLicence(license);
                        SharePreferencesUtil.saveLicense(LiveStartActivity.this, license);
                        ModuleToast.show(LiveStartActivity.this, getString(R.string.cert_creation_license_success));
                    } else {
                        ModuleToast.show(LiveStartActivity.this, getString(R.string.cert_creation_license_fail));
                    }
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }

            @Override
            public void dismissDialog() {

            }
        });


    }


    private void start() {


        ModuleLog.e(liveCompany);

        final boolean isYuncong = liveCompany
                .equals(LiveCompany.YUNCONG);  //是否使用云从的活体检测
        if (isYuncong) {  //如果是云从，加载云从的活体检测模块
            builder = new Bulider();
            checkModule();
        }


        if (isYuncong) {  //云从活体检测
            Intent intent = new Intent(this, LiveActivity.class);
            Bulider.setStartCls(LiveActivity.class);
            Bundle bundle = new Bundle();
            bundle.putString("license", SharePreferencesUtil.getLicense(this));
            intent.putExtras(bundle);
            startActivity(intent);
            overridePendingTransition(R.anim.left_in, R.anim.left_out);

        } else if (liveCompany.equals(LiveCompany.KUANGSHI)) {  // 旷世的活体检测
            LiveCompany.kuangshi(LiveStartActivity.this);
        } else if (liveCompany.equals(LiveCompany.BAIDU)) {
            startBaidu();
        }
    }

    private void startBaidu() {
        if (FaceSDKManager.getInstance().getInitFlag()) {
            Intent intent = new Intent(this, FaceLivenessExpActivity.class);
            startActivity(intent);
        }
        FaceSDKManager.getInstance().initialize(this, FaceLicenseConfig.getLicenseKeyId(BuildConfig.isAAR),
                "idl-license.face-android", new IInitCallback() {
                    @Override
                    public void initSuccess() {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Intent intent = new Intent(getContext(), FaceLivenessExpActivity.class);
                                startActivity(intent);
                            }
                        });
                    }

                    @Override
                    public void initFailure(final int errCode, final String errMsg) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Log.e(TAG, "初始化失败 = " + errCode + " " + errMsg);
                                ModuleToast.show(getContext(), "初始化失败");
                            }
                        });
                    }
                });
    }

    /**
     * 处理旷世活体识别结果
     *
     * @param result
     */
    @Subscribe
    public void handleKuangshiResult(KuangshiResult result) {
        if (result.isSuccess()) {
            Intent intent = ChooseBindWayActivity.buildIntent(this, containerNum, getFaceImg());
            startActivity(intent);
        } else {
            ModuleToast.show(this, R.string.cert_creation_kuangshi_fail);
        }
    }

    private String getFaceImg() {
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/faceapp";
        String img = Base64Util.fromFile(this, Uri.parse(path + File.separator + "demo" + File.separator + "only.jpg"));
        ImageCache.getInstance().setSelfie(Selfie.KUANGSHI, img, false);
        return img;
    }


    //检查模型是否存在
    private void checkModule() {
        ArrayList<Integer> liveList = new ArrayList<Integer>();
        liveList.add(FaceInterface.LivessType.LIVESS_MOUTH);
        liveList.add(FaceInterface.LivessType.LIVESS_HEAD_LEFT);
        liveList.add(FaceInterface.LivessType.LIVESS_HEAD_RIGHT);
        liveList.add(FaceInterface.LivessType.LIVESS_EYE);
        builder.setLives(liveList);

        //再次检查模型文件是否已拷贝到app运行目录
        final File installation = new File(getFilesDir(), MODULES);
        String storagePath = installation.getAbsolutePath();
        StringBuilder pFaceDetectFile = new StringBuilder(storagePath + File.separator + "faceDetector_2_4.mdl");
        StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath + File.separator + "keypt_detect_model_sdm_9pts.bin");
        StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath + File.separator + "keypt_track_model_sdm_9pts.bin");
        StringBuilder pFaceQualityFile = new StringBuilder(storagePath + File.separator + "facequality_4_1.bin");
        StringBuilder pFaceLivenessFile = new StringBuilder(storagePath + File.separator + "liveness171120.bin");
        //检测每个模型文件是否存在
        boolean allModulesExist = false;
        if (installation.exists() && new File(pFaceDetectFile.toString()).exists()
                && new File(pFaceKeyPtFile.toString()).exists() && new File(pFaceKeyPtTrackFile.toString()).exists()
                && new File(pFaceQualityFile.toString()).exists() && new File(pFaceLivenessFile.toString()).exists()) {
            allModulesExist = true;
        }

        if (!allModulesExist) {
            processDialog = CwProgressHUD.create(this).setStyle(CwProgressHUD.Style
                    .SPIN_INDETERMINATE)
                    .setLabel(getString(R.string.cloudwalk_copy_modules)).setCancellable(true)
                    .setAnimationSpeed(2)
                    .setDimAmount(0.5f);

            processDialog.show();
            mBt_startdect.setEnabled(false);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable() {
                @Override
                public void run() {
                    //
                    boolean initStage = false;
                    String dataDirPath = getFilesDir().getAbsolutePath();//data/data/package_name/files/
                    try {
                        //模型文件拷贝
                        assetsDataToDest(LiveStartActivity.this, MODULES_ZIP, dataDirPath + File.separator + MODULES_ZIP);//拷贝模型文件
                        //接压缩模型文件
                        unZipFolder(dataDirPath + File.separator + MODULES_ZIP, dataDirPath);
                        //设置模型文         件路径
//                        String paht = dataDirPath + File.separator + MODULES;
                        CloudwalkSDK.getInstance().setModulePath(dataDirPath + File.separator + MODULES);
                        initStage = true;
                    } catch (IOException ex) {
                        initStage = false;
                        Log.e(TAG, "copy module IOException:" + ex.getMessage());
                    } catch (RuntimeException e) {
                        initStage = false;
                        Log.e(TAG, "copy module RuntimeException:" + e.getMessage());
                    } catch (Exception e) {
                        initStage = false;
                        Log.e(TAG, "copy module Exception:" + e.getMessage());
                    } finally {
                        //删除模型文件压缩包
                        File modelsZip = new File(dataDirPath + File.separator + MODULES_ZIP);
                        if (modelsZip.exists()) {
                            FileUtil.deleteFile(modelsZip);
                        }

                        if (initStage) {
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    //销毁进度对话框
                                    if (processDialog != null && processDialog.isShowing()) {
                                        processDialog.dismiss();
                                    }
                                    mBt_startdect.setEnabled(true);
                                }
                            });
                        } else {
                            //删除解压后模型文件
                            File modelsDir = new File(dataDirPath + File.separator + MODULES);
                            if (modelsDir.exists()) {
                                FileUtil.deleteFile(modelsDir);
                            }
                            //初始化失败
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    //销毁进度对话框
                                    if (processDialog != null && processDialog.isShowing()) {
                                        processDialog.dismiss();
                                    }
                                    //提示初始化失败

                                    ModuleToast.show(LiveStartActivity.this, getString(R.string.cloudwalk_copy_modules_failed));
                                    finish();
                                }
                            });
                        }

                    }

                }
            });
        } else {
            try {
                CloudwalkSDK.getInstance().setModulePath(getFilesDir().getAbsolutePath() + File.separator + MODULES);
            } catch (Exception e) {
                Log.e(TAG, "copy module Exception:" + e.getMessage());

            }

        }
    }

    /**
     * 跳转到绑定身份证界面
     *
     * @param imgBase64
     */
    private void gotoChooseBindWayActivity(String imgBase64) {

        ImageCache.getInstance().setSelfie(Selfie.YUNCONG, imgBase64, false);

            Intent intent = new Intent(this, ChooseBindWayActivity.class);
//            intent.putExtra(FACE_IMG, imgBase64);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            startActivity(intent);

    }


    /**
     * 云从人脸识别后回调回来要进入的下一步界面
     *
     * @param imgBase64
     */
    private void gotoNext(String imgBase64) {
        gotoChooseBindWayActivity(imgBase64);
    }


    @Override
    protected int getTitleRes() {
        return R.string.live_prepare_title;
    }


    @Override
    protected boolean isOCRActivity() {
        return true;
    }


}
