package ocr.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.Base64;
import android.view.Menu;
import android.view.MenuInflater;

import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.yishu.DynamicPermission;

import ocr.bean.IDCardInfo;
import ocr.command.NFCCommand;
import yishu.bluetooth.YSBluetoothCardReader.IdentityCard;
import yishu.nfc.YSnfcCardReader.NFCardReader;

/**
 * Created by Administrator on 2019/12/18 0018.
 */

public class TianjinYishuNFCActivity extends NFCActivity implements NFCCommand {


    private Context tcontext;
    //	private static String DB_NAME;
    //	private static final int DB_VERSION = 2;
    //	private static DatabaseHelper mOpenHelper;
    //	private static SQLiteDatabase db;

    private static final int SETTING_SERVER_IP = 11;
    private static final int SETTING_BT = 22;
    //	private ArrayList<String> IPArray = null;
    private static String remoteIPA = "";
    private static String remoteIPB = "";
    private static String remoteIPC = "";
    private int mode = 2;
    private static int AssignPort = 19158;

    private NfcAdapter mAdapter = null;
    //	private ReadCardAPI NFCReadCardAPI;
    private NFCardReader nfcReadCardAPI;

    private PendingIntent pi = null;
    //滤掉组件无法响应和处理的Intent
    private IntentFilter tagDetected = null;
    private String[][] mTechLists;
    private Intent inintent = null;

    private int readflag = 0;
    private static final int REQUEST_ENABLE_BT = 2;
    public final static String EXTRA_DEVICE_ADDRESS = "device_address";
    private static String addressmac = "";
    private int portin;

    private DynamicPermission dynamicPermission;

    public static final int MESSAGE_VALID_NFCBUTTON = 16;
    public static final int MESSAGE_VALID_PROCESS = 1001;
    /**
     * 服务器无法连接
     */
    public final static int SERVER_CANNOT_CONNECT = 90000001;
    /**
     * 开始读卡
     */
    public final static int READ_CARD_START = 10000001;
    /**
     * 读卡进度
     */
    public final static int READ_CARD_PROGRESS = 20000002;
    /**
     * 读卡成功
     */
    public final static int READ_CARD_SUCCESS = 30000003;
    public final static int READ_CARD_RESULT = 30000004;

    /**
     * 读照片成功
     */
    public final static int READ_PHOTO_SUCESS = 40000004;
    /**
     * 读卡失败
     */
    public final static int READ_CARD_FAILED = 90000009;

    private String liveFaceImg;

    //	public static String DB_CREATE_TABLE_IPCONFIG = "CREATE TABLE IF NOT EXISTS [setipconfig] " +
    //			"([ID] INTEGER PRIMARY KEY,[IP] VARCHAR)";
    //	private static class DatabaseHelper extends SQLiteOpenHelper {
    //		DatabaseHelper(Context context) {
    //			super(context, DB_NAME, null, DB_VERSION);
    //		}
    //		@Override
    //		public void onCreate(SQLiteDatabase db) {
    //			Log.e("ERROR", "test here DBOperation this channel onCreate");
    //			db.execSQL(DB_CREATE_TABLE_IPCONFIG);
    //		}
    //		@Override
    //		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    //		}
    //	}

    public void getData() {
        Bundle others = getIntent().getExtras();
        if (others != null && others.containsKey(FACE_IMG)) {
            liveFaceImg = others.getString(FACE_IMG);
        }

    }

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //权限判断
        dynamicPermission = new DynamicPermission(this, new DynamicPermission.PassPermission() {
            @Override
            public void operation() {
            }
        });
        dynamicPermission.getPermissionStart();

        //		if (19 <= android.os.Build.VERSION.SDK_INT) {
        //			if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.BASE) {
        //				final File appsDir = getExternalFilesDir("/");
        //			}
        //		}
        writeFile("pass onCreate 1.");
        tcontext = getContext();//this.getApplicationContext();
        //		IPArray = new ArrayList<String>();
        //		IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        //		this.registerReceiver(mUsbReceiver, filter);


        //		DB_NAME = "/sdcard/yishu/usingservice.db";
        //		mOpenHelper = new DatabaseHelper(this);
        //		db = mOpenHelper.getWritableDatabase();
        //		portin=9000;
        //
        //		DB_NAME = "/sdcard/yishu/usingservice.db";
        //		mOpenHelper = new DatabaseHelper(this);
        //		db = mOpenHelper.getWritableDatabase();
        //		String sql = "select IP from setipconfig where ID=1;";
        //		Cursor cur;
        //		cur = db.rawQuery(sql, null);
        //		if (cur.moveToFirst()==true)
        //		{
        //			while (!cur.isAfterLast()) {
        //				remoteIPA = cur.getString(0).trim();
        //				break;
        //			}
        //		}
        //		cur.close();
        //		sql = "select IP from setipconfig where ID=2;";
        //		cur = db.rawQuery(sql, null);
        //		if (cur.moveToFirst()==true)
        //		{
        //			while (!cur.isAfterLast()) {
        //				remoteIPB = cur.getString(0).trim();
        //				break;
        //			}
        //		}
        //		cur.close();
        //		sql = "select IP from setipconfig where ID=3;";
        //		cur = db.rawQuery(sql, null);
        //		if (cur.moveToFirst()==true)
        //		{
        //			while (!cur.isAfterLast()) {
        //				remoteIPC = cur.getString(0).trim();
        //				break;
        //			}
        //		}
        //		cur.close();
        //		sql = "select IP from setipconfig where ID=4;";
        //		cur = db.rawQuery(sql, null);
        //		if (cur.moveToFirst()==true)
        //		{
        //			while (!cur.isAfterLast()) {
        //				addressmac = cur.getString(0).trim();
        //				break;
        //			}
        //		}
        //		cur.close();
        //		sql = "select IP from setipconfig where ID=5;";
        //		cur = db.rawQuery(sql, null);
        //		if (cur.moveToFirst()==true)
        //		{
        //			while (!cur.isAfterLast()) {
        //				String pp=cur.getString(0).trim();
        //				if (pp.length()<2)
        //				{
        //					portin=9000;
        //				}else
        //				{
        //					portin = (int)Integer.parseInt(cur.getString(0).trim());
        //				}
        //				break;
        //			}
        //		}
        //		cur.close();
        //		db.close();
        //		mOpenHelper.close();
        //		IPArray.add(remoteIPA);
        //		IPArray.add(remoteIPB);
        //		IPArray.add(remoteIPC);
        //		btAdapt = BluetoothAdapter.getDefaultAdapter();// 初始化本机蓝牙功能

        //		BtReadCardAPI=new BluetoothReader(mHandler,getApplicationContext());
        writeFile("pass onCreate 2.");
        nfcReadCardAPI = new NFCardReader(mHandler, this);

        nfcReadCardAPI.setTheServer(AppConfig.getInstance().getServerSettingConfig().getNfcServerIP(),
                Integer.parseInt(AppConfig.getInstance().getServerSettingConfig().nfcServerPort));

        //		writeFile("Iparray"+IPArray);
        writeFile("pass onCreate 3.");
        //		nfcReadCardAPI.setTheServer(ip,port);
        //		BtReadCardAPI.setTheServer(ip,port);

        //		otgReadCardAPI=new OTGCardReader(mHandler,getApplicationContext());
        //		BtReadCardAPI.setlogflag(0);//0, nolog; //1, with log;
        nfcReadCardAPI.setlogflag(0);
        //		otgReadCardAPI.setlogflag(0);
        //		nfcReadCardAPI.writeFile("test addressmac 1="+addressmac);
        if (mode == 2)
            mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCSTART, 0);

        getData();

    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mode == 2)
            mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCSTART, 0);

        if (!dynamicPermission.checkPermissionPassState()) {
            dynamicPermission.showPermissionDialog();
        }
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        nfcReadCardAPI.writeFile("test 101");
        if (mode == 1) {
            new AlertDialog.Builder(this)
                    .setTitle("提示").setMessage("目前处于OTG模式！")
                    .setPositiveButton("确定", null).show();
            return;
        }
        if (mode == 3) {
            new AlertDialog.Builder(this)
                    .setTitle("提示").setMessage("目前处于蓝牙模式！")
                    .setPositiveButton("确定", null).show();
            return;
        }
        //		mHandler.sendEmptyMessageDelayed(MESSAGE_CLEAR_ITEMS, 0);
        nfcReadCardAPI.writeFile("test 102");
        if (readflag == 1) {
            //			return;
        }
        nfcReadCardAPI.writeFile("test 103");
        inintent = intent;
        readflag = 1;


        //		ReadCardAPI=new OTGReadCardAPI(tcontext,IPArray);

        nfcReadCardAPI.writeFile("test 104");
        mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCBUTTON, 0);
    }

    /*	@Override
        public void onPause() {
            super.onPause();
    //		mAdapter.disableForegroundDispatch(this);
            if (mode==1) return;
            if (mode==3) return;
            if (mAdapter!=null)	stopNFC_Listener();
        }
        @Override
        protected void onResume() {
            super.onResume();
            if (mode==1) return;
            if (mode==3) return;
    //		if (mAdapter!=null) startNFC_Listener();
        }
        private void startNFC_Listener() {
            mAdapter.enableForegroundDispatch(this, pi, new IntentFilter[] { tagDetected }, mTechLists);
    //		mAdapter.enableForegroundDispatch(this, pi,
    //				new IntentFilter[] { tagDetected }, null);
        }

        private void stopNFC_Listener() {
            mAdapter.disableForegroundDispatch(this);
        }

        private void init_NFC() {
    //		nfcIntent = new Intent(getApplicationContext(), interfaceActivity.class)
    //				.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
            pi = PendingIntent.getActivity(this, 0, new Intent(this, getClass())
                    .addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
    //		tagDetected = new IntentFilter(NfcAdapter.ACTION_TAG_DISCOVERED);
            tagDetected = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);//.ACTION_TAG_DISCOVERED);
            tagDetected.addCategory(Intent.CATEGORY_DEFAULT);
            mTechLists = new String[][] { new String[] { NfcB.class.getName() } };
        }
    */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.option_menu, menu);
        return true;
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == SETTING_BT) {
            if (resultCode != Activity.RESULT_OK)
                return;
            //	    	   testReadCardAPI.writeFile("come into data action 1 requestCode="+requestCode);
            //	    	   testReadCardAPI.writeFile("come into data action 1 resultCode="+resultCode);

            //	    	   if (data.equals(null)) return;
            //	    	   testReadCardAPI.writeFile("come into data action 2 ");
            //	    	   testReadCardAPI.writeFile("come into data action = "+data.getAction());
            String address = data.getStringExtra(EXTRA_DEVICE_ADDRESS);
            //			mOpenHelper = new DatabaseHelper(this);
            //			db = mOpenHelper.getWritableDatabase();
            //			String sql = "select IP from setipconfig where ID=4;";
            //			int p=0;
            //			Cursor cur;
            //			cur = db.rawQuery(sql, null);
            //			if (cur.moveToFirst()==true)
            //			{
            //				while (!cur.isAfterLast()) {
            //					p++;
            //					break;
            //				}
            //			}
            //			cur.close();
            //
            //			if (p==0)
            //			{
            //				sql= "insert into setipconfig (ID,IP) values(4,'"+address+"');";
            //				db.execSQL(sql);
            //			}else
            //			{
            //				sql="update setipconfig set IP='"+address+"'"+" where ID=4"+";";
            //				db.execSQL(sql);
            //			}
            //			db.close();
            //			mOpenHelper.close();
            addressmac = address;
            nfcReadCardAPI.writeFile("test addressmac 2=" + addressmac);
            //			BtReadCardAPI.setmac(address);
        }
        if (requestCode == SETTING_SERVER_IP) {
            if (data == null) {
                return;
            }
            String setIp = data.getStringExtra("ip");
            int setPort = data.getIntExtra("port", 0);
            nfcReadCardAPI.setTheServer(setIp, setPort);
            //			IPArray.clear();
            //			mOpenHelper = new DatabaseHelper(this);
            //			db = mOpenHelper.getWritableDatabase();
            //			String sql = "select IP from setipconfig where ID=1;";
            //			Cursor cur;
            //			cur = db.rawQuery(sql, null);
            //			if (cur.moveToFirst()==true)
            //			{
            //				while (!cur.isAfterLast()) {
            //					remoteIPA = cur.getString(0).trim();
            //					break;
            //				}
            //			}
            //			cur.close();
            //			sql = "select IP from setipconfig where ID=5;";
            //			cur = db.rawQuery(sql, null);
            //			if (cur.moveToFirst()==true)
            //			{
            //				while (!cur.isAfterLast()) {
            //					portin = (int)Integer.parseInt(cur.getString(0).trim());
            //					break;
            //				}
            //			}
            //			cur.close();
            //			db.close();
            //			mOpenHelper.close();
            //			nfcReadCardAPI.setTheServer(remoteIPA,portin);
            //			BtReadCardAPI.setTheServer(remoteIPA,portin);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray(b, 0, b.length);
        } else {
            return null;
        }
    }

    @Override
    protected void onDestroy() {
        //	    this.unregisterReceiver(mUsbReceiver);
        super.onDestroy();
    }

    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";

    public static final int MESSAGE_VALID_NFCSTART = 26;
    private final Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            int tt;
            //			nfcReadCardAPI.setport(portin);
            switch (msg.what) {
                case MESSAGE_VALID_NFCSTART:
                    Boolean enablenfcs = nfcReadCardAPI.EnableSystemNFCMessage();
                    if (enablenfcs == true) {
                    } else {

                        ModuleToast.show(getContext(), "NFC初始化失败");

                    }
                    break;
                case SERVER_CANNOT_CONNECT:
                    ModuleToast.show(getContext(), "没有连接到服务器！");

                    break;
                case READ_CARD_START:
                    //		        	new AlertDialog.Builder(context)
                    //        			.setTitle("提示" ).setMessage("开始读卡！" )
                    //        			.setPositiveButton("确定" ,  null ).show();
                    break;
                case READ_CARD_PROGRESS:
                    int progress_value = (Integer) msg.obj;
                    //					Readingtext.setText("      正在读卡，请稍候。。。");
                    break;
                case READ_CARD_SUCCESS:
                    nfcReadCardAPI.writeFile("test READ_CARD_SUCCESS 1");
                    IdentityCard identityCard = (IdentityCard) msg.obj;
                    nfcReadCardAPI.writeFile("test READ_CARD_SUCCESS 2");
                    readflag = 0;
                    writeFile("NFC End");

                    IDCardInfo id = new IDCardInfo();
                    id.setName(identityCard.name);

                    if (identityCard.sex.equals("男")) {
                        id.setSex(1);
                    } else {
                        id.setSex(2);
                    }

                    id.setBirthDate(identityCard.birth);
                    id.setNation(identityCard.ethnicity);
                    id.setAddr(identityCard.address);
                    id.setIdNum(identityCard.cardNo);
                    id.setIssueOffice(identityCard.authority);
                    // validDate 亿数的原始格式是20101126-20201126
                    //亿数西藏版本 2015082420250824
                    String validDate = IDUtil.formatValidDate(identityCard.period);
                    id.setValidDate(validDate);
                    //                        LogWrapper.e("validDate = " + validDate);

                    String base64 = Base64.encodeToString(nfcReadCardAPI.GetImage(),
                            Base64.DEFAULT);

//                    id.setPhoto(base64);


                    ModuleToast.show(getContext(), "读卡成功");

                    forward(nfcReadCardAPI.GetImage(), id);

                    break;
                case READ_PHOTO_SUCESS:
                    byte[] cardbmp = (byte[]) msg.obj;
                    Bitmap bm = BitmapFactory.decodeByteArray(cardbmp,
                            0, cardbmp.length);
                    //                    idimg.setImageBitmap(bm);
                    break;
                case READ_CARD_FAILED:
                    ModuleToast.show(getContext(), String.valueOf(msg.obj));

                    break;
                case MESSAGE_VALID_NFCBUTTON:
                    writeFile("NFC Begin");
                    Boolean judgenfc = nfcReadCardAPI.isNFC(inintent);
                    if (judgenfc == true) {
                        nfcReadCardAPI.NFCreadCardFast(inintent);
                    } else {
                        ModuleToast.show(getContext(), "读卡失败！");

                    }
                    //					nfcReadCardAPI.DisableSystemNFCMessage();

                    break;
                default:
                    break;
            }
        }
    };


    @Override
    public int getNFCState() {
        return setNFCState();
    }

    @Override
    public void openNFC() {
        Intent intent = new Intent(Settings.ACTION_NFC_SETTINGS);
        startActivity(intent);
    }

    private void forward(byte[] faceImg, IDCardInfo info) {

        Bitmap bitmap = Bytes2Bimap(faceImg);
        if (bitmap == null) {
            ModuleToast.show(this, "头像识别有误");
            return;
        } else {
            bitmap.recycle();
            bitmap = null;
        }

        if (info != null) {
            Bundle others = new Bundle();
            others.putByteArray("selfie", faceImg);
            others.putString(FACE_IMG, liveFaceImg);
            others.putParcelable(IDENTIFY_INFO, info);
            Intent intent = new Intent(this, YishuIDCardActivity.class);
            intent.putExtras(others);
            startActivity(intent);
        }

    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }


}
