package ocr.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.nfc.NfcAdapter;
import android.nfc.tech.NfcB;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;

import com.aircert.CommonActivity.ToolBarActivity;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishYishuNFC;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.yishu.DynamicPermission;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;

import ocr.bean.IDCardInfo;
import ocr.command.NFCCommand;
import yishu.bluetooth.YSBluetoothCardReader.IdentityCard;
import yishu.nfc.YSnfcCardReader.NFCardReader;

/**
 * Created by Administrator on 2020/5/14 0014.
 */

public class XiZangYishuNFCActivity extends NFCActivity implements NFCCommand {


    private Context tcontext;
    private static final int SETTING_SERVER_IP = 11;
    private static final int SETTING_BT = 22;
    //	private ArrayList<String> IPArray = null;
    private static String remoteIPA = "";
    private static String remoteIPB = "";
    private static String remoteIPC = "";
    private int mode = 2;
    private static int AssignPort = 19158;

    private NfcAdapter mAdapter = null;
    //	private ReadCardAPI NFCReadCardAPI;
    private NFCardReader nfcReadCardAPI;

    private PendingIntent pi = null;
    //滤掉组件无法响应和处理的Intent
    private IntentFilter tagDetected = null;
    private String[][] mTechLists;
    private Intent inintent = null;

    private int readflag = 0;
    private static final int REQUEST_ENABLE_BT = 2;
    public static final String EXTRA_DEVICE_ADDRESS = "device_address";
    private static String addressmac = "";
    private int portin;

    private DynamicPermission dynamicPermission;

    public static final int MESSAGE_VALID_NFCBUTTON = 16;
    public static final int MESSAGE_VALID_PROCESS = 1001;
    /**
     * 服务器无法连接
     */
    public final static int SERVER_CANNOT_CONNECT = 90000001;
    /**
     * 开始读卡
     */
    public final static int READ_CARD_START = 10000001;
    /**
     * 读卡进度
     */
    public final static int READ_CARD_PROGRESS = 20000002;
    /**
     * 读卡成功
     */
    public final static int READ_CARD_SUCCESS = 30000003;
    public final static int READ_CARD_RESULT = 30000004;

    /**
     * 读照片成功
     */
    public final static int READ_PHOTO_SUCESS = 40000004;
    /**
     * 读卡失败
     */
    public final static int READ_CARD_FAILED = 90000009;

    protected String liveFaceImg;

    public int containerNum;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //权限判断
        dynamicPermission = new DynamicPermission(XiZangYishuNFCActivity.this, new DynamicPermission.PassPermission() {
            @Override
            public void operation() {
            }
        });
        dynamicPermission.getPermissionStart();

        writeFile("pass onCreate 1.");
        tcontext = getContext();//this.getApplicationContext();

        writeFile("pass onCreate 2.");
        nfcReadCardAPI = new NFCardReader(mHandler, this);

        nfcReadCardAPI.setTheServer(AppConfig.getInstance().getServerSettingConfig().getNfcServerIP(),
                Integer.parseInt(AppConfig.getInstance().getServerSettingConfig().nfcServerPort));


        writeFile("pass onCreate 3.");
        nfcReadCardAPI.setlogflag(1);

        // MESSAGE_VALID_NFCSTART是NFC开始读取，现在期望onCreate中触发一次，然后在handler中判断NFC状态
        // 如果是NFC为开启就进行异常提示
        if (mode == 2) {
            mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCSTART, 0);
        }

    }

    @Override
    public void getData() {
       /* Bundle others = getIntent().getExtras();
        if (others != null && others.containsKey(FACE_IMG)) {
            liveFaceImg = others.getString(FACE_IMG);
        }*/
        liveFaceImg = ImageCache.getInstance().getSelfie();
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mode == 2) {
            mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCSTART, 0);
        }

        if (!dynamicPermission.checkPermissionPassState()) {
            dynamicPermission.showPermissionDialog();
        }

    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        nfcReadCardAPI.writeFile("test 101");
        if (mode == 1) {
            new AlertDialog.Builder(XiZangYishuNFCActivity.this)
                    .setTitle("提示").setMessage("目前处于OTG模式！")
                    .setPositiveButton("确定", null).show();
            return;
        }
        if (mode == 3) {
            new AlertDialog.Builder(XiZangYishuNFCActivity.this)
                    .setTitle("提示").setMessage("目前处于蓝牙模式！")
                    .setPositiveButton("确定", null).show();
            return;
        }
//		mHandler.sendEmptyMessageDelayed(MESSAGE_CLEAR_ITEMS, 0);
        nfcReadCardAPI.writeFile("test 102");
        if (readflag == 1) {
//			return;
        }
        nfcReadCardAPI.writeFile("test 103");
        inintent = intent;
        readflag = 1;


        nfcReadCardAPI.writeFile("test 104");
        mHandler.sendEmptyMessageDelayed(MESSAGE_VALID_NFCBUTTON, 0);
    }

    @Override
    public void onPause() {
        super.onPause();
//        mAdapter.disableForegroundDispatch(this);
//        stopNFC_Listener();
//        if (mode == 1) return;
//        if (mode == 3) return;
//        if (mAdapter != null) stopNFC_Listener();
    }

    private void startNFC_Listener() {
//        mAdapter.enableForegroundDispatch(this, pi, new IntentFilter[]{tagDetected}, mTechLists);
        mAdapter.enableForegroundDispatch(this, pi,
                new IntentFilter[]{tagDetected}, null);
    }

    private void stopNFC_Listener() {
        mAdapter.disableForegroundDispatch(this);
    }

    private void init_NFC() {
        mAdapter = NfcAdapter.getDefaultAdapter(this);
        //		nfcIntent = new Intent(getApplicationContext(), interfaceActivity.class)
        //				.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        pi = PendingIntent.getActivity(this, 0, new Intent(this, getClass())
                .addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
        //		tagDetected = new IntentFilter(NfcAdapter.ACTION_TAG_DISCOVERED);
        tagDetected = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);//.ACTION_TAG_DISCOVERED);
        tagDetected.addCategory(Intent.CATEGORY_DEFAULT);
        mTechLists = new String[][]{new String[]{NfcB.class.getName()}};
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.option_menu, menu);
        return true;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == SETTING_BT) {
            if (resultCode != Activity.RESULT_OK) {
                return;
            }
//	    	   testReadCardAPI.writeFile("come into data action 1 requestCode="+requestCode);
//	    	   testReadCardAPI.writeFile("come into data action 1 resultCode="+resultCode);

//	    	   if (data.equals(null)) return;
//	    	   testReadCardAPI.writeFile("come into data action 2 ");
//	    	   testReadCardAPI.writeFile("come into data action = "+data.getAction());
            String address = data.getStringExtra(EXTRA_DEVICE_ADDRESS);
//			mOpenHelper = new DatabaseHelper(this);
//			db = mOpenHelper.getWritableDatabase();
//			String sql = "select IP from setipconfig where ID=4;";
//			int p=0;
//			Cursor cur;
//			cur = db.rawQuery(sql, null);
//			if (cur.moveToFirst()==true)
//			{
//				while (!cur.isAfterLast()) {
//					p++;
//					break;
//				}
//			}
//			cur.close();
//
//			if (p==0)
//			{
//				sql= "insert into setipconfig (ID,IP) values(4,'"+address+"');";
//				db.execSQL(sql);
//			}else
//			{
//				sql="update setipconfig set IP='"+address+"'"+" where ID=4"+";";
//				db.execSQL(sql);
//			}
//			db.close();
//			mOpenHelper.close();
            addressmac = address;
            nfcReadCardAPI.writeFile("test addressmac 2=" + addressmac);
//			BtReadCardAPI.setmac(address);
        }
        if (requestCode == SETTING_SERVER_IP) {
            if (data == null) {
                return;
            }
            String setIp = data.getStringExtra("ip");
            int setPort = data.getIntExtra("port", 0);
            nfcReadCardAPI.setTheServer(setIp, setPort);
//			IPArray.clear();
//			mOpenHelper = new DatabaseHelper(this);
//			db = mOpenHelper.getWritableDatabase();
//			String sql = "select IP from setipconfig where ID=1;";
//			Cursor cur;
//			cur = db.rawQuery(sql, null);
//			if (cur.moveToFirst()==true)
//			{
//				while (!cur.isAfterLast()) {
//					remoteIPA = cur.getString(0).trim();
//					break;
//				}
//			}
//			cur.close();
//			sql = "select IP from setipconfig where ID=5;";
//			cur = db.rawQuery(sql, null);
//			if (cur.moveToFirst()==true)
//			{
//				while (!cur.isAfterLast()) {
//					portin = (int)Integer.parseInt(cur.getString(0).trim());
//					break;
//				}
//			}
//			cur.close();
//			db.close();
//			mOpenHelper.close();
//			nfcReadCardAPI.setTheServer(remoteIPA,portin);
//			BtReadCardAPI.setTheServer(remoteIPA,portin);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }


    @Override
    protected void onDestroy() {
//	    this.unregisterReceiver(mUsbReceiver);
        super.onDestroy();
    }

    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";

    public static final int MESSAGE_VALID_NFCSTART = 26;
    private final Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            int tt;
//			nfcReadCardAPI.setport(portin);
            switch (msg.what) {
                case MESSAGE_VALID_NFCSTART:
                    Boolean enablenfcs = nfcReadCardAPI.EnableSystemNFCMessage();
                    if (enablenfcs == true) {
                    } else {
                        ModuleToast.show(getContext(), "NFC初始化失败");
                    }
                    break;
                case SERVER_CANNOT_CONNECT:
                    ModuleToast.show(getContext(), "没有连接到服务器！");
                    break;
                case READ_CARD_START:
                    break;
                case READ_CARD_PROGRESS:
                    int progress_value = (Integer) msg.obj;
                    break;
                case READ_CARD_SUCCESS:
                    nfcReadCardAPI.writeFile("test READ_CARD_SUCCESS 1");
                    IdentityCard identityCard = (IdentityCard) msg.obj;
                    nfcReadCardAPI.writeFile("test READ_CARD_SUCCESS 2");

                    readflag = 0;
                    writeFile("NFC End");

                    IDCardInfo id = new IDCardInfo();
                    id.setName(identityCard.name);
                    SharePreferencesUtil.saveName(tcontext, identityCard.name);
                    if (identityCard.sex.equals("男")) {
                        id.setSex(1);
                    } else {
                        id.setSex(2);
                    }

                    id.setBirthDate(identityCard.birth);
                    id.setNation(identityCard.ethnicity);
                    id.setAddr(identityCard.address);
                    id.setIdNum(identityCard.cardNo);
                    id.setIssueOffice(identityCard.authority);
                    // validDate 亿数的原始格式是20101126-20201126
                    //亿数西藏版本 2015082420250824
                    Log.d("jff", "380 XiZangYishuNFCActivity handleMessage identityCardData: " + identityCard.period);
                    String validDate = IDUtil.formatValidDate(identityCard.period);
                    Log.d("jff", "380 XiZangYishuNFCActivity handleMessage validDate: " + validDate);
                    id.setValidDate(validDate);

                    String base64 = Base64.encodeToString(nfcReadCardAPI.GetImage(),
                            Base64.DEFAULT);
                    ImageCache.getInstance().setNfcFaceImgStr(base64);

                    ImageCache.getInstance().setNfcFaceImg(Bytes2Bimap(nfcReadCardAPI.GetImage()));
                    Log.d("jff", "XiZangYishuNFCActivity handleMessage cardInfo:" + id.toString());

                    ModuleToast.show(getContext(), "读卡成功");

                    forward(nfcReadCardAPI.GetImage(), id);
                    break;
//                case READ_PHOTO_SUCESS://亿数已废弃
//                    byte[] cardbmp = (byte[]) msg.obj;
//                    Bitmap bm = BitmapFactory.decodeByteArray(cardbmp,
//                            0, cardbmp.length);
//                    ImageCache.getInstance().setNfcFaceImg(bm);
//                    Log.d("jff", "399 XiZangYishuNFCActivity handleMessage READ_PHOTO_SUCESS: ");
//
//                    break;
                case READ_CARD_FAILED:
                    ModuleToast.show(getContext(), String.valueOf(msg.obj));
                    break;
                case MESSAGE_VALID_NFCBUTTON:
                    writeFile("NFC Begin");
                    Boolean judgenfc = nfcReadCardAPI.isNFC(inintent);
                    if (judgenfc == true) {
                        nfcReadCardAPI.NFCreadCardFast(inintent);
                    } else {
                        ModuleToast.show(getContext(), "读卡失败！");

                    }
                    break;
                default:
                    break;
            }
        }
    };


    public Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray(b, 0, b.length);
        } else {
            return null;
        }
    }


    @Override
    public void writeFile(String sb) {
        FileWriter fw = null;
        String datetime = "";
        try (BufferedWriter bw = new BufferedWriter(fw)) {
            SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd" + " "
                    + "hh:mm:ss:SSS");
            datetime = tempDate.format(new java.util.Date()).toString();
            fw = new FileWriter("/sdcard/yishu/yishu.txt", true);//
            // 创建FileWriter对象，用来写入字符流
            String myreadline = datetime + "[]" + sb;
            bw.write(myreadline + "\n"); // 写入文件
            bw.newLine();
            bw.flush(); // 刷新该流的缓冲
            bw.close();
            fw.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void forward(byte[] faceImg, IDCardInfo info) {

//        Bitmap bitmap = Bytes2Bimap(faceImg);
//        if (bitmap == null) {
//            ModuleToast.show(context, "头像识别有误");
//            return;
//        } else {
//            bitmap.recycle();
//            bitmap = null;
//        }

        if (info != null) {

            Bundle others = new Bundle();
//            others.putByteArray("selfie", faceImg);
//            others.putString(FACE_IMG, liveFaceImg);
            others.putParcelable(IDENTIFY_INFO, info);
            Intent intent = new Intent(this, YishuIDCardActivity.class);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            intent.putExtras(others);
            startActivity(intent);

//            finish();//重新检测是不需要关闭当前页面，之前关闭是因为西藏出现系统白标签的问题，该问题已经在onResume中添加处理
        }

    }

    @Override
    public int getNFCState() {
        return setNFCState();
    }

    @Override
    public void openNFC() {
        Intent intent = new Intent(Settings.ACTION_NFC_SETTINGS);
        startActivity(intent);
    }


    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    @Subscribe
    public void handleFinish(FinishYishuNFC event) {
        finish();
    }
}
