package com.xdja.safeclient.certcreation;

import android.content.Context;

import com.aircert.FileUtil;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.config.CertConfig;
import com.xdja.safeclient.certcreation.config.DefaultConfig;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;

/**
 * 应用配置
 */

public class AppConfig {

    private Context context;

    /**
     * 默认PIN码和BKS签名密码
     */
    private DefaultConfig defaultConfig;

    /**
     * 证书设备信息<br>
     * 即设备类型、容器号、密钥算法、证书机制、展示证书类型
     */
    private CertConfig certConfig;

    /**
     * 身份认证服务信息<br>
     * 即服务器地址、第三方服务配置等
     */
    private ServerSettingConfig serverSettingConfig;

    /**
     * 项目的名称、或者项目的地区<br><br>
     * 如天津、广东、陕西等
     */
    private int project;

    public boolean isHasDB() {
        return FileUtil.assetFileIsExist(context, "certDataBase.db");
    }

    private AppConfig() {

        defaultConfig = new DefaultConfig();

        serverSettingConfig = new ServerSettingConfig();

        certConfig = new CertConfig(0);

    }

    private static class RealCertIssueModuleHolder {
        static AppConfig instance = new AppConfig();
    }

    public static AppConfig getInstance() {
        return RealCertIssueModuleHolder.instance;
    }


    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int getRole(CryptoDevType cardType, int containerNum) {
        return 0x01;
    }

    public int getProject() {
        return project;
    }

    public void setProject(int project) {
        this.project = project;
    }

    @Override
    public String toString() {
        return "AppConfig{" +
                "context=" + context +
                ", project=" + project +
                '}';
    }

    public DefaultConfig getDefaultConfig() {
        return defaultConfig;
    }

    public void setDefaultConfig(DefaultConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public CertConfig getCertConfig() {
        return certConfig;
    }

    public void setCertConfig(CertConfig certConfig) {
        this.certConfig = certConfig;
    }

    public ServerSettingConfig getServerSettingConfig() {
        return serverSettingConfig;
    }

    public void setServerSettingConfig(ServerSettingConfig serverSettingConfig) {
        this.serverSettingConfig = serverSettingConfig;
    }
}
