package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.FileUtil;
import com.aircert.util.ModuleLog;
import com.baidu.idl.face.platform.ui.dialog.BindIdentifyDialog;
import com.baidu.idl.face.platform.ui.dialog.SinglePermissionDialog;
import com.baidu.idl.face.platform.ui.utils.HTMLText;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.IsTrue;
import com.xdja.safeclient.certcreation.databases.CertConfigDataBase;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.FileSizeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_BACK;
import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_DEFAULT;

/**
 * Created by zjc on 2019/5/21 0021.
 */
public class ConfigStep1Activity extends BaseActivity implements View.OnClickListener {

    private View next;

    private EditText etProjectName;

    private Button addAddress;

    private EditText etVHSMIP1;

    private EditText etVHSMPort1;

    private Button addVHSM;

    private int navigateType;


    private EditText serverIP1;

    private EditText serverPort1;

    private LinearLayout topLayout1;

    private ImageView deleteServer2;

    private LinearLayout topLayout2;

    private EditText serverIP2;

    private EditText serverPort2;

    private RelativeLayout serverLayout2;

    private ImageView deleteServer3;

    private LinearLayout topLayout3;

    private EditText serverIP3;

    private EditText serverPort3;

    private RelativeLayout serverLayout3;

    private ImageView deleteServer4;

    private LinearLayout topLayout4;

    private EditText serverIP4;

    private EditText serverPort4;

    private RelativeLayout serverLayout4;

    private EditText vhsmIP1;

    private EditText vhsmPort1;

    private LinearLayout vhsmTopLayout1;

    private ImageView deleteVHSM2;

    private LinearLayout vhsmTopLayout2;

    private EditText vhsmIP2;

    private EditText vhsmPort2;

    private RelativeLayout vhsmLayout2;

    private ImageView deleteVHSM3;

    private LinearLayout vhsmTopLayout3;

    private EditText vhsmIP3;

    private EditText vhsmPort3;

    private RelativeLayout vhsmLayout3;

    private ImageView deleteVHSM4;

    private LinearLayout vhsmTopLayout4;

    private EditText vhsmIP4;

    private EditText vhsmPort4;

    private RelativeLayout vhsmLayout4;

    private View vhsmLayout;

    private CheckBox enableVHSM;

    /**
     * 是否支持混合云
     */
    private CheckBox enableHHY;

    private String hhy = IsTrue.NAY;

    /**
     * 是否支持展示撤销证书
     */
    private CheckBox enableRevoke;

    private String isRevoke = IsTrue.AYE;

    private View uploadCert;

    private TextView tvFileName;

    private TextView tvFileSize;

    private ImageView ivDeleteCert;

    private String certPath = "";

    private boolean validCert;

    private void initCALayout() {
        uploadCert = findViewById(R.id.ll_upload_cert);
        uploadCert.setOnClickListener(this);

        tvFileName = findViewById(R.id.tv_file_name);

        tvFileSize = findViewById(R.id.tv_file_size);

        ivDeleteCert = findViewById(R.id.iv_delete_ca);
        ivDeleteCert.setOnClickListener(this);
    }

    private void initVHSMLayout() {

        vhsmIP1 = findViewById(R.id.vhsm_ip_1);

        vhsmIP2 = findViewById(R.id.vhsm_ip_2);

        vhsmIP3 = findViewById(R.id.vhsm_ip_3);

        vhsmIP4 = findViewById(R.id.vhsm_ip_4);

        vhsmPort1 = findViewById(R.id.vhsm_port_1);

        vhsmPort2 = findViewById(R.id.vhsm_port_2);

        vhsmPort3 = findViewById(R.id.vhsm_port_3);

        vhsmPort4 = findViewById(R.id.vhsm_port_4);

        deleteVHSM2 = findViewById(R.id.delete_vhsm_2);

        deleteVHSM3 = findViewById(R.id.delete_vhsm_3);

        deleteVHSM4 = findViewById(R.id.delete_vhsm_4);

        deleteVHSM2.setOnClickListener(this);

        deleteVHSM3.setOnClickListener(this);

        deleteVHSM4.setOnClickListener(this);

        vhsmTopLayout1 = findViewById(R.id.vhsm_top_layout_1);

        vhsmTopLayout2 = findViewById(R.id.vhsm_top_layout_2);

        vhsmTopLayout3 = findViewById(R.id.vhsm_top_layout_3);

        vhsmTopLayout4 = findViewById(R.id.vhsm_top_layout_4);

        vhsmLayout2 = findViewById(R.id.vhsm_layout_2);

        vhsmLayout3 = findViewById(R.id.vhsm_layout_3);

        vhsmLayout4 = findViewById(R.id.vhsm_layout_4);

        vhsmLayout = findViewById(R.id.vhsm_layout);

        enableVHSM = findViewById(R.id.enable_vhsm);
        enableVHSM.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                onSwitchOnClick(b);
            }
        });

        enableHHY = findViewById(R.id.enable_hhy);
        enableHHY.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                onSwitchHHy(b);
            }
        });

        enableRevoke = findViewById(R.id.enable_revoke);
        enableRevoke.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                onSwitchRevoke(b);
            }
        });

    }


    private void initServerLayout() {

        serverIP1 = findViewById(R.id.server_ip_1);
        serverPort1 = findViewById(R.id.server_port_1);

        topLayout1 = findViewById(R.id.top_layout_1);

        serverAddressesList.add(new ServerAddress("", ""));

        vhsmAddressList.add(new ServerAddress("", ""));

        deleteServer2 = findViewById(R.id.delete_server_2);
        deleteServer2.setOnClickListener(this);

        serverIP2 = findViewById(R.id.server_ip_2);
        serverPort2 = findViewById(R.id.server_port_2);

        topLayout2 = findViewById(R.id.top_layout_2);

        serverLayout2 = findViewById(R.id.server_layout_2);

        deleteServer3 = findViewById(R.id.delete_server_3);
        deleteServer3.setOnClickListener(this);

        serverIP3 = findViewById(R.id.server_ip_3);

        serverPort3 = findViewById(R.id.server_port_3);

        topLayout3 = findViewById(R.id.top_layout_3);

        serverLayout3 = findViewById(R.id.server_layout_3);

        deleteServer4 = findViewById(R.id.delete_server_4);
        deleteServer4.setOnClickListener(this);

        serverIP4 = findViewById(R.id.server_ip_4);

        serverPort4 = findViewById(R.id.server_port_4);

        serverLayout4 = findViewById(R.id.server_layout_4);

        topLayout4 = findViewById(R.id.top_layout_4);


    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // 隐藏界面左上角的返回
        if (BuildConfig.isAAR) {
            navigateType = NAVIGATE_BACK;
        } else {
            navigateType = NAVIGATE_DEFAULT;
        }

        super.onCreate(savedInstanceState);

        FlowManager.init(new FlowConfig.Builder(this).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
        FlowLog.setMinimumLoggingLevel(FlowLog.Level.V);
        // 解决Android9.0无法导出数据库的问题
        DatabaseWrapper wrapper = FlowManager.getDatabase(CertConfigDataBase.NAME).getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase) wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase) wrapper).getDatabase().disableWriteAheadLogging();


        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);

        setContentView(R.layout.activity_config_step1);

        if (!checkValidPermission(permissions)) {
            showInvalidPermissionDialog();
        }

        initView();

        initViewByData();


    }


    @Override
    protected int getToolbarType() {
        return navigateType;
    }

    private void initView() {

        if (!BuildConfig.isAAR) {
            leftBtn.setVisibility(View.GONE);
        } else {
            leftBtn.setVisibility(View.VISIBLE);
        }

        etProjectName = findViewById(R.id.project_name);
        etProjectName.setFilters(EditTextUtil.getDisableEmojFilter(20));

        etVHSMIP1 = findViewById(R.id.vhsm_ip_1);
        etVHSMIP1.setFilters(EditTextUtil.getDisableEmojFilter());

        etVHSMPort1 = findViewById(R.id.vhsm_port_1);
        etVHSMPort1.setFilters(EditTextUtil.getDisableEmojFilter());


        next = findViewById(R.id.next);
        next.setOnClickListener(this);

        addAddress = findViewById(R.id.add_address);
        addAddress.setOnClickListener(this);

        addVHSM = findViewById(R.id.add_vhsm);
        addVHSM.setOnClickListener(this);

        initServerLayout();

        initVHSMLayout();

        initCALayout();


    }

    private void initViewByData() {

        ServerSettingConfig serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        if (serverSettingConfig == null) {
            return;
        }

        String projectName = serverSettingConfig.getProjectName();
        if (!TextUtils.isEmpty(projectName)) {
            etProjectName.setText(projectName);
        }

        tvFileName.setText(serverSettingConfig.getCertPath());

        tvFileSize.setText(String.valueOf(FileSizeUtil.getFileOrFilesSize(serverSettingConfig.getCertPath(), FileSizeUtil.SIZETYPE_KB)) + "KB");

        uploadCert.setVisibility(View.GONE);
        ivDeleteCert.setVisibility(View.VISIBLE);


        initServerAddressByData(serverSettingConfig);

        initVHSMAddressByData(serverSettingConfig);

        if (serverSettingConfig.getRevoke().equals(IsTrue.AYE)) {
            isRevoke = IsTrue.AYE;
        } else {
            isRevoke = IsTrue.NAY;
        }

        if (serverSettingConfig.getHhy().equals(IsTrue.AYE)) {
            hhy = IsTrue.AYE;
        } else {
            hhy = IsTrue.NAY;
        }


    }

    private void initServerAddressByData(ServerSettingConfig serverSettingConfig) {

        String ip = serverSettingConfig.getIp();

        String port = serverSettingConfig.getPort();

        if (TextUtils.isEmpty(ip)) {
            return;
        }

        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");

        serverAddressesList.clear();

        for (int count = 0; count < ipArray.length; count++) {
            serverAddressesList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }

        int count = ipArray.length;

        if (count == 0) {
            return;
        }

        if (count > 3) {
            serverIP4.setText(ipArray[3]);
            serverPort4.setText(portArray[3]);
            serverLayout4.setVisibility(View.VISIBLE);
        }

        if (count > 2) {
            serverIP3.setText(ipArray[2]);
            serverPort3.setText(portArray[2]);
            serverLayout3.setVisibility(View.VISIBLE);
        }

        if (count > 1) {
            serverIP2.setText(ipArray[1]);
            serverPort2.setText(portArray[1]);
            serverLayout2.setVisibility(View.VISIBLE);
        }

        serverIP1.setText(ipArray[0]);
        serverPort1.setText(portArray[0]);




    }

    private void initVHSMAddressByData(ServerSettingConfig serverSettingConfig) {

        String ip = serverSettingConfig.getVhsm_ip();

        String port = serverSettingConfig.getVhsm_port();

        // TODO: 2020/3/6 0006 没有数据是不是要判断下？

        if (TextUtils.isEmpty(ip)) {
            return;
        }

        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");

        vhsmAddressList.clear();

        for (int count = 0; count < ipArray.length; count++) {
            vhsmAddressList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }

        int count = ipArray.length;

        if (count == 0) {
            return;
        }

        if (count > 3) {
            vhsmIP4.setText(ipArray[3]);
            vhsmPort4.setText(portArray[3]);
            vhsmLayout4.setVisibility(View.VISIBLE);
        }

        if (count > 2) {
            vhsmIP3.setText(ipArray[2]);
            vhsmPort3.setText(portArray[2]);
            vhsmLayout3.setVisibility(View.VISIBLE);
        }

        if (count > 1) {
            vhsmIP2.setText(ipArray[1]);
            vhsmPort2.setText(portArray[1]);
            vhsmLayout2.setVisibility(View.VISIBLE);
        }

        vhsmIP1.setText(ipArray[0]);
        vhsmPort1.setText(portArray[0]);

        if (serverSettingConfig.enableVHSM) {
            enableVHSM.setChecked(true);
            vhsmLayout.setVisibility(View.VISIBLE);
        } else {
            enableVHSM.setChecked(false);
            vhsmLayout.setVisibility(View.GONE);
        }

    }


    private ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

    private ArrayList<ServerAddress> vhsmAddressList = new ArrayList<>();

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.next) {
            next();
        } else if (id == R.id.add_address) {
            addServerAddress();
        } else if (id == R.id.add_vhsm) {
            addVHSMAddress();
        } else if (id == R.id.delete_server_2) {
            deleteServerAddress(2);
        } else if (id == R.id.delete_server_3) {
            deleteServerAddress(3);
        } else if (id == R.id.delete_server_4) {
            deleteServerAddress(4);
        } else if (id == R.id.delete_vhsm_2) {
            deleteVHSMAddress(2);
        } else if (id == R.id.delete_vhsm_3) {
            deleteVHSMAddress(3);
        } else if (id == R.id.delete_vhsm_4) {
            deleteVHSMAddress(4);
        } else if (id == R.id.ll_upload_cert) {
            uploadCert();
        } else if (id == R.id.iv_delete_ca) {
            deleteCA();
        }

    }

    private void uploadCert() {
        chooseFile();
    }

    private void deleteCA() {

        tvFileName.setText(R.string.cc_choose_ca_file);

        tvFileSize.setText(R.string.cc_cer_only);

        clearFilePath();

        ivDeleteCert.setVisibility(View.GONE);

        uploadCert.setVisibility(View.VISIBLE);

        //先不导入证书，点击下一步会提示需要传证书，传证书后再把证书删除，不会显示无证书的提示，这里做一下状态还原
        validCert = false;

    }

    private static final int CHOOSE_FILE = 12;

    private void chooseFile() {
        Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
        intent.setType("*/*");//设置类型，我这里是任意类型，任意后缀的可以这样写。
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        startActivityForResult(intent, CHOOSE_FILE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        //选择根证书的结果处理
        if (resultCode == RESULT_OK) {

            if (requestCode == CHOOSE_FILE) {
                Uri uri = data.getData();

                String currentFile = FileUtil.getPath(this, uri);
                if (TextUtils.isEmpty(currentFile)) {
                    return;
                }

                ModuleLog.e(certPath);

                String fileName = FileUtil.getFileNameFromPath(currentFile);
                if (!fileName.endsWith(".cer")) {
                    ModuleToast.show(getContext(), R.string.cc_cert_format_error);
                    return;
                } else {
                    setFilePath(currentFile);
                }

                BouncyCastleProvider provider = new BouncyCastleProvider();

                //Android中自带的 BouncyCastleProvider 不包含 SM3WITHSM2签名算法，所以此处删除该Provider，然后添加引用jar里的 BouncyCastleProvider
                Security.removeProvider("BC");
                Security.addProvider(provider);
                InputStream is = null;
                try {
                     is = new FileInputStream(new File(certPath));

                    //读取根证书
                    X509Certificate root = DeviceWrapper.getInstance().getX509Certificate(is, provider);

                    if (root == null) {
                        ModuleToast.show(getContext(), R.string.cc_cert_content_error);
                        validCert = false;
                        return;
                    } else {
                        validCert = true;
                    }

                } catch (IOException e) {
                    e.printStackTrace();
                    ModuleToast.show(getContext(), R.string.cc_read_cert_file_error);
                    return;
                } catch (OutOfMemoryError e) {
                    ModuleToast.show(getContext(), R.string.cc_cert_file_size_too_large);
                    return;
                } catch (Exception e) {
                    ModuleToast.show(getContext(), R.string.cc_read_cert_file_error);
                    return;
                }  finally {
                    try {
                        if(is != null){
                            is.close();
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }


                tvFileName.setText(currentFile);

                tvFileSize.setText(String.valueOf(FileSizeUtil.getFileOrFilesSize(certPath, FileSizeUtil.SIZETYPE_KB)) + "KB");

                uploadCert.setVisibility(View.GONE);
                ivDeleteCert.setVisibility(View.VISIBLE);


            }

        }

    }

    private void setFilePath(String certPath) {
        this.certPath = certPath;
    }

    private void clearFilePath() {
        certPath = "";
    }

    public static String IS2String(InputStream in) throws IOException {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        for (int n; (n = in.read(b)) != -1; ) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }


    private void deleteServerAddress(int num) {

        saveCurrentServerAddress();

        if (serverAddressesList.size() == 4) {
            serverIP4.setText("");
            serverPort4.setText("");
            serverLayout4.setVisibility(View.GONE);
            topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (serverAddressesList.size() == 3) {
            serverIP3.setText("");
            serverPort3.setText("");
            serverLayout3.setVisibility(View.GONE);
            topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (serverAddressesList.size() == 2) {
            serverIP2.setText("");
            serverPort2.setText("");
            serverLayout2.setVisibility(View.GONE);
            topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        }

        serverAddressesList.remove(num - 1);

        refreshServerValue();

    }

    private void deleteVHSMAddress(int num) {

        saveCurrentVHSMAddress();

        if (vhsmAddressList.size() == 4) {
            vhsmIP4.setText("");
            vhsmPort4.setText("");
            vhsmLayout4.setVisibility(View.GONE);
            vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (vhsmAddressList.size() == 3) {
            vhsmIP3.setText("");
            vhsmPort3.setText("");
            vhsmLayout3.setVisibility(View.GONE);
            vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (vhsmAddressList.size() == 2) {
            vhsmIP2.setText("");
            vhsmPort2.setText("");
            vhsmLayout2.setVisibility(View.GONE);
            vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        }

        vhsmAddressList.remove(num - 1);

        refreshVHSMValue();

    }

    private void refreshServerValue() {

        if (serverLayout2.getVisibility() == View.VISIBLE) {
            serverIP2.setText(serverAddressesList.get(1).getIp());
            serverPort2.setText(serverAddressesList.get(1).getPort());
        }

        if (serverLayout3.getVisibility() == View.VISIBLE) {
            serverIP3.setText(serverAddressesList.get(2).getIp());
            serverPort3.setText(serverAddressesList.get(2).getPort());
        }

    }

    private void refreshVHSMValue() {
        if (vhsmLayout2.getVisibility() == View.VISIBLE) {
            vhsmIP2.setText(vhsmAddressList.get(1).getIp());
            vhsmPort2.setText(vhsmAddressList.get(1).getPort());
        }

        if (vhsmLayout3.getVisibility() == View.VISIBLE) {
            vhsmIP3.setText(vhsmAddressList.get(2).getIp());
            vhsmPort3.setText(vhsmAddressList.get(2).getPort());
        }
    }


    private void addServerAddress() {


        if (serverLayout4.getVisibility() == View.VISIBLE) {
            ModuleToast.show(this, R.string.cert_creation_max_server_address);
            return;
        } else {
            serverAddressesList.add(new ServerAddress("", ""));
        }

        if (serverLayout2.getVisibility() == View.VISIBLE) {

            if (serverLayout3.getVisibility() == View.VISIBLE) {
                serverLayout4.setVisibility(View.VISIBLE);
            } else {
                serverLayout3.setVisibility(View.VISIBLE);
            }

        } else {
            serverLayout2.setVisibility(View.VISIBLE);
        }

    }

    private void addVHSMAddress() {

        if (vhsmLayout4.getVisibility() == View.VISIBLE) {
            ModuleToast.show(this, R.string.cert_creation_max_server_address);
            return;
        } else {
            vhsmAddressList.add(new ServerAddress("", ""));
        }

        if (vhsmLayout2.getVisibility() == View.VISIBLE) {

            if (vhsmLayout3.getVisibility() == View.VISIBLE) {
                vhsmLayout4.setVisibility(View.VISIBLE);
            } else {
                vhsmLayout3.setVisibility(View.VISIBLE);
            }

        } else {
            vhsmLayout2.setVisibility(View.VISIBLE);
        }

    }


    @Override
    public boolean valid() {

        if (!validProjectName()) {
            return false;
        }

        if (!validServerAddress()) {
            return false;
        }

        if (enableVHSM.isChecked()) {
            if (!validVHSMAddress()) {
                return false;
            }
        }

        if (!validCert) {
            ModuleToast.show(getContext(), R.string.cc_choose_ca_file);
            return false;
        }

        return true;




    }

    class ValidResult {
        boolean ipResult;

        boolean portResult;

        public ValidResult(boolean ipResult, boolean portResult) {
            this.ipResult = ipResult;
            this.portResult = portResult;
        }
    }

    private boolean show = true;

    private boolean validServerAddress() {

        show = true;

        saveCurrentServerAddress();

        boolean success = true;

        List<ValidResult> resultList = new ArrayList<>();

        for (int position = 0; position < serverAddressesList.size(); position++) {
            ServerAddress address = serverAddressesList.get(position);
            resultList.add(new ValidResult(validIP(address.getIp()), validPort(address.getPort())));
        }

        for (int position = 0; position < resultList.size(); position++) {
            ValidResult result = resultList.get(position);
            if (result.ipResult && result.portResult) {
                updateServerBackground(position, true);
                continue;
            } else {
                updateServerBackground(position, false);
                success = false;
            }

        }

        return success;

    }

    private boolean validVHSMAddress() {

        show = true;

        saveCurrentVHSMAddress();

        boolean success = true;

        List<ValidResult> resultList = new ArrayList<>();

        for (int position = 0; position < vhsmAddressList.size(); position++) {
            ServerAddress address = vhsmAddressList.get(position);
            resultList.add(new ValidResult(validIP(address.getIp()), validPort(address.getPort())));
        }

        for (int position = 0; position < resultList.size(); position++) {
            ValidResult result = resultList.get(position);
            if (result.ipResult && result.portResult) {
                updateVHSMBackground(position, true);
                continue;
            } else {
                updateVHSMBackground(position, false);
                success = false;
            }

        }

        return success;

    }


    private void saveCurrentServerAddress() {
        serverAddressesList.set(0, new ServerAddress(serverIP1.getText().toString(), serverPort1.getText().toString()));

        if (serverLayout2.getVisibility() == View.VISIBLE) {
            serverAddressesList.set(1, new ServerAddress(serverIP2.getText().toString(), serverPort2.getText().toString()));
        }

        if (serverLayout3.getVisibility() == View.VISIBLE) {
            serverAddressesList.set(2, new ServerAddress(serverIP3.getText().toString(), serverPort3.getText().toString()));
        }

        if (serverLayout4.getVisibility() == View.VISIBLE) {
            serverAddressesList.set(3, new ServerAddress(serverIP4.getText().toString(), serverPort4.getText().toString()));
        }
    }

    private void saveCurrentVHSMAddress() {
        vhsmAddressList.set(0, new ServerAddress(vhsmIP1.getText().toString(), vhsmPort1.getText().toString()));

        if (vhsmLayout2.getVisibility() == View.VISIBLE) {
            vhsmAddressList.set(1, new ServerAddress(vhsmIP2.getText().toString(), vhsmPort2.getText().toString()));
        }

        if (vhsmLayout3.getVisibility() == View.VISIBLE) {
            vhsmAddressList.set(2, new ServerAddress(vhsmIP3.getText().toString(), vhsmPort3.getText().toString()));
        }

        if (vhsmLayout4.getVisibility() == View.VISIBLE) {
            vhsmAddressList.set(3, new ServerAddress(vhsmIP4.getText().toString(), vhsmPort4.getText().toString()));
        }
    }


    private void updateServerBackground(final int position, final boolean success) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (position == 0) {
                    if (success) {
                        topLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        topLayout1.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 1) {
                    if (success) {
                        topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 2) {
                    if (success) {
                        topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 3) {
                    if (success) {
                        topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                }


            }
        });
    }

    private void updateVHSMBackground(final int position, final boolean success) {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if (position == 0) {
                    if (success) {
                        vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 1) {
                    if (success) {
                        vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 2) {
                    if (success) {
                        vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 3) {
                    if (success) {
                        vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                }


            }
        });

    }

    /**
     * 不可为空，最大可输入20个字，只能输入汉字和英文字符
     *
     * @return
     */

    private boolean validProjectName() {

        String projectName = etProjectName.getText().toString();

        if (TextUtils.isEmpty(projectName)) {

            ModuleToast.show(this, R.string.cert_creation_project_name_hint);

            return false;

        }

        if (projectName.length() > 20) {

            ModuleToast.show(this, R.string.cert_creation_err_length_project_name);

            return false;

        }

        return true;

    }

    /**
     * 不可为空，IP地址格式校验：
     * <p>
     * 4组数字组成。
     * <p>
     * 1、第一位不能是小数点；
     * <p>
     * 2、第一位不能是0；
     * <p>
     * 3、只能输入数字和小数点；
     * <p>
     * 4、每位ip只能输入0-255之间的整数 ；
     * <p>
     * 5、必须是4位；
     * <p>
     * 错误提示：【服务器IP地址错误】
     *
     * @return
     */
    private boolean validIP(String ip) {

        if (TextUtils.isEmpty(ip)) {

            if (show) {
                ModuleToast.show(this, R.string.cert_creation_config_empty_server_address);
            }

            show = false;

            return false;
        }

        boolean success = AddressUtil.validIP(ip);

        if (!success) {

            if (show) {
                ModuleToast.show(this, R.string.cert_creation_config_error_server_address);
            }
            show = false;

        }

        return success;

    }

    /**
     * 不可为空，1-65535
     * <p>
     * 错误提示：【服务器端口错误】
     * <p>
     * 为空提示：【请输入服务器端口】
     *
     * @return
     */
    private boolean validPort(String port) {

        if (TextUtils.isEmpty(port)) {

            if (show) {
                ModuleToast.show(this, R.string.cert_creation_config_please_input_server_port);
            }
            show = false;
            return false;
        }

        boolean success = AddressUtil.validPort(port);

        if (!success) {
            if (show) {
                ModuleToast.show(this, R.string.cert_creation_config_error_server_port);
            }
            show = false;
        }

        return success;

    }


    @Override
    public void saveValue() {
        super.saveValue();

        if (enableVHSM.isChecked()) {
            saveCurrentVHSMAddress();
        }

    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CONFIG_STEP2;
    }

    @Override
    public void route() {
        super.route();

        if (BuildConfig.isAAR || DEBUG_AAR) {
            Intent intent = new Intent(this, ConfigStep2Activity.class);
            intent.putExtra("projectName", etProjectName.getText().toString());
            intent.putExtra("serverAddressesList", serverAddressesList);
            intent.putExtra("vhsmAddressList", vhsmAddressList);
            intent.putExtra("enableVHSM", enableVHSM.isChecked());
            intent.putExtra("certPath", certPath);

            intent.putExtra("enableHHY", hhy);
            intent.putExtra("enableRevoke", isRevoke);

            startActivity(intent);
        }

    }


    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    private String[] permissions = new String[]{
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    };

    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    /**
     * 弹窗提示用户用户开启权限
     */
    private void showInvalidPermissionDialog() {

        ArrayList<String> list = new ArrayList<>();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                ActivityCompat.requestPermissions(ConfigStep1Activity.this,
                        new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        PERMISSION_CODE);

                bindIdentifyDialog.dismiss();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.finish();
            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d("权限回调");

        switch (requestCode) {

            case PERMISSION_CODE:

                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                } else {
                    showNoPhonePermissionDialog();
                }

                break;

        }


    }

    public static final int PERMISSION_CODE = 23;


    /**
     * 展示权限申请对话框
     */
    public void showNoPhonePermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build(this, SinglePermissionDialog.PERMISSION_STORAGE);
        dialog.show();
    }



    private void onSwitchHHy(boolean isH){
        if(isH){
           hhy = enableHHY.isChecked()? IsTrue.AYE : IsTrue.NAY;
        }
    }

    private void onSwitchRevoke(boolean isR){
        if(isR){
           isRevoke = enableRevoke.isChecked()? IsTrue.AYE : IsTrue.NAY;
        }
    }

    private void onSwitchOnClick(boolean enableVHSM) {
        if (enableVHSM) {
            vhsmLayout.setVisibility(View.VISIBLE);

            vhsmLayout.setFocusable(true);
            vhsmLayout.requestFocus();

        } else {
            vhsmLayout.setVisibility(View.GONE);

            vhsmIP1.setText("");
            vhsmPort1.setText("");
            vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);

            vhsmIP2.setText("");
            vhsmPort2.setText("");
            vhsmLayout2.setVisibility(View.GONE);
            vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);

            vhsmIP3.setText("");
            vhsmPort3.setText("");
            vhsmLayout3.setVisibility(View.GONE);
            vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);

            vhsmIP4.setText("");
            vhsmPort4.setText("");
            vhsmLayout4.setVisibility(View.GONE);
            vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);

            vhsmAddressList.clear();
            vhsmAddressList.add(new ServerAddress());
        }
    }

    @Override
    protected void showLoading() {
//        super.showLoading();
    }

    @Override
    protected void showLoading(int resId) {
//        super.showLoading(resId);
    }
}
