package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.baidu.idl.face.platform.ui.dialog.BindIdentifyDialog;
import com.baidu.idl.face.platform.ui.dialog.SinglePermissionDialog;
import com.baidu.idl.face.platform.ui.utils.HTMLText;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.ConfigBean;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.a3rdplugin.demo.NFCCompany;
import com.xdja.a3rdplugin.demo.OCRCompany;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.CertConfigAdapter;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.IsTrue;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.databases.CertConfigDataBase;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ConfigDialog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;

import org.apache.commons.net.telnet.TelnetClient;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import static com.xdja.safeclient.certcreation.bean.device.CardType.ONLINE_VHSM;

/**
 * Created by zjc on 2019/5/21 0021.
 */
public class ConfigStep3Activity extends BaseActivity implements View.OnClickListener {

    public static final String DEFAULT_CARD_TYPE_TEXT = "请选择";

    public String projectName;

    public String procedure;

    public ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

    public ArrayList<ServerAddress> vhsmAddressList = new ArrayList<>();

    public boolean enableVHSM;

    public String enableHHY;

    public String enableRevoke;

    RecyclerView recyclerView;

    List<TableCertConfig> list;

    CertConfigAdapter adapter;

    Button addNewCard;

    Button export;

    /**
     * 活体检测
     */
    private View liveCompanyView;

    private TextView liveCompanyResult;

    /**
     * OCRCompany
     */
    private View ocrView;

    private TextView ocrResult;

    /**
     * nfc
     */
    private View nfcView;

    private TextView nfcResult;

    private View nfcIPView;

    private EditText nfcIPResult;

    private View nfcPortView;

    private EditText nfcPortResult;

    private TextView exportHint;

    private CheckBox sAllowUpdate;
    private CheckBox sAllowIdentifer;

    private Button connect;

    private View layout3rdNServer;

    private View dividerLive;

    ConfigHandler handler = new ConfigHandler();

    private ServerSettingConfig serverSettingConfig;

    public static final String path
            = Environment.getExternalStorageDirectory() + "/" + CertConfigDataBase.NAME + ".db";

    private boolean exportSuccess;

    public String certPath;

    public String certContent;

    @Override
    protected void getIntentData() {
        super.getIntentData();

        projectName = getIntent().getStringExtra("projectName");

        serverAddressesList = getIntent().getParcelableArrayListExtra("serverAddressesList");

        vhsmAddressList = getIntent().getParcelableArrayListExtra("vhsmAddressList");

        procedure = getIntent().getStringExtra(ConfigParam.PROCEDURE);

        enableVHSM = getIntent().getBooleanExtra("enableVHSM", false);

        enableHHY = getIntent().getStringExtra("enableHHY");
        enableRevoke = getIntent().getStringExtra("enableRevoke");

        certPath = getIntent().getStringExtra("certPath");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_config_step3);


        initData();

        modifyList();

        initView();

        initViewByData();

        if (list.size() == 0 || list == null) {
            list = new ArrayList<>();
            list.add(defaultCertConfig());
        }

        recyclerView = findViewById(R.id.list_device_detail);

        adapter = new CertConfigAdapter(this, list, enableVHSM);

        LinearLayoutManager layoutManager = new LinearLayoutManager(this);

        recyclerView.setNestedScrollingEnabled(false);

        recyclerView.setLayoutManager(layoutManager);

        recyclerView.setAdapter(adapter);

        resize();

        readCert();
    }

    private void readCert() {

        new Handler().post(new Runnable() {
            @Override
            public void run() {

                if (TextUtils.isEmpty(certPath)) {
                    return;
                }

                try {
                    InputStream is = new FileInputStream(new File(certPath));

                    certContent = ApplicationInit.IS2String(is);

                    ModuleLog.e(certContent);

                } catch (IOException e) {
                    e.printStackTrace();
                } catch (OutOfMemoryError e) {
                    ModuleToast.show(getContext(), "文件太大了！");
                } catch (Exception e) {

                }

            }
        });

    }

    /**
     * 在已经配置过空包，第二次（及以后）进入到此界面时
     * 如果之前的配置启用了VHSM并配置了VHSM设备
     * 此次进入，没有启用VHSM，并跳转到此页
     * 将之前配置的VHSM设备改为已选择
     */
    private void modifyList() {

        if (enableVHSM) {
            return;
        }

        for (int position = 0; position < list.size(); position++) {
            TableCertConfig config = list.get(position);
            if (config.cardType.equals(CardType.ONLINE_VHSM)) {
                config.setCardType(DEFAULT_CARD_TYPE_TEXT);
            }
        }

    }


    private void initData() {

        serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        list = SQLite.select().from(TableCertConfig.class).queryList();

        ModuleLog.d(serverSettingConfig);
        ModuleLog.d(list);
    }

    @Override
    public void onClick(View view) {

        int id = view.getId();

        if (id == R.id.connect) {

            ping();

        } else if (id == R.id.add_new_card) {

            list.add(defaultCertConfig());

            adapter.notifyDataSetChanged();

            resize();

        } else if (id == R.id.export) {

            boolean success = validBeforeExport();

            if (!success) {
                return;
            }

            showExportDialog();


        }

    }

    private void ping() {

        // 按钮显示连接中
        setConnecting();

        // 本次尝试ping连接完成前不允许再次点击按钮
        disablePing();

        pingServer();

    }

    private void setConnecting() {
        handler.sendEmptyMessage(SET_CONNECTING);
    }

    private void disablePing() {
        handler.sendEmptyMessage(DISABLE_PIN);
    }

    private void pingServer() {
        ping(nfcIPResult.getText().toString(), nfcPortResult.getText().toString());
    }

    public static final int CONNECT_SUCCESS = 0;

    public static final int CONNECT_FAILED = 1;

    public static final int SET_CONNECT_TEST = 2;

    public static final int SET_CONNECTING = 3;

    public static final int DISABLE_PIN = 4;

    public static final int ENABLE_PIN = 5;

    public static final int SERVER_SUCCESS = 6;

    public static final int SERVER_FAILED = 7;

    /**
     * @param ip
     */
    private void ping(final String ip, final String port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                TelnetClient telnet = new TelnetClient();
                try {
                    // 2000毫秒超时
                    telnet.setConnectTimeout(2 * 1000);
                    telnet.connect(ip, Integer.parseInt(port));

                    handler.sendEmptyMessage(SERVER_SUCCESS);

                } catch (Exception e) {
                    handler.sendEmptyMessage(SERVER_FAILED);
                    e.printStackTrace();
                } finally {
                    try {
                        telnet.disconnect();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();

    }


    class ConfigHandler extends Handler {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            if (msg.what == CONNECT_SUCCESS) {

                ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_connect_success);

            } else if (msg.what == CONNECT_FAILED) {

                ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_connect_failed);

            } else if (msg.what == SET_CONNECT_TEST) {
                connect.setText(R.string.cert_creation_config_test);
            } else if (msg.what == SET_CONNECTING) {
                connect.setText(R.string.cert_creation_config_connecting);
            } else if (msg.what == DISABLE_PIN) {
                connect.setClickable(false);
            } else if (msg.what == ENABLE_PIN) {
                connect.setClickable(true);
            } else if (msg.what == SERVER_SUCCESS) {
                showResult(true);
            } else if (msg.what == SERVER_FAILED) {
                showResult(false);
            }

        }
    }

    private void showResult(final boolean success) {

        handler.sendEmptyMessage(success ? CONNECT_SUCCESS : CONNECT_FAILED);

        setConnectText();

        enablePing();

    }

    private void setConnectText() {
        handler.sendEmptyMessage(SET_CONNECT_TEST);
    }

    private void enablePing() {
        handler.sendEmptyMessage(ENABLE_PIN);
    }


    /**
     * 设备信息增加后，重新设置RecyclerView的高度
     */
    private void resize() {

        recyclerView.setMinimumHeight(ScreenUtil.dip2px(getContext(), 324) * list.size());


        ModuleLog.e(recyclerView.getHeight());


    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Subscribe
    public void handleConfig(ChooseConfigEvent event) {

        ConfigBean value = event.getConfig();

        String text = value.getContent();

        int position = event.getPosition();

        // 选择的是身份认证服务（活体检测、OCRCompany、NFCCompany）中的一个
        if (position == LiveCompany.POSITION) {
            liveCompanyResult.setText(text);
        } else if (position == NFCCompany.POSITION) {
            nfcResult.setText(text);
        } else if (position == OCRCompany.POSITION) {
            ocrResult.setText(text);
        } else {

            //             选择的是证书设备信息
            // （签发设备、签发容器号、密钥算法、证书机制、展示证书类型、操作权限）中的一个

            TableCertConfig item = list.get(position);

            if (CardType.getList().contains(value)) {
                item.setCardType(text);
            } else if (ContainerNum.getList().contains(value)) {
                item.setContainerNum(Integer.parseInt(text));
            } else if (AlgType.getList().contains(value)) {
                item.setAlgType(text);
            } else if (CertRule.getList().contains(value)) {
                item.setCertRule(text);
            } else if (CertType.getList().contains(value)) {
                item.setCertType(text);
            } else if (CertPermission.getList().contains(value)) {
                item.setCertPermission(text);
            }

            list.set(position, item);
            adapter.notifyDataSetChanged();

        }

    }

    /**
     * 签发设备
     * 选择框
     * 内置安全芯片、智能薄膜卡、TF卡、联网VHSM、离线VHSM，无默认项
     * <p>
     * 签发容器号
     * 选择框
     * 0.1.2.3.4.6，必填，默认0号
     * <p>
     * 密钥算法
     * 单选
     * SM2,RSA ，默认选择SM2
     * <p>
     * 证书机制
     * 单选
     * 双证，单证，默认选择双证
     * <p>
     * 展示证书类型
     * 选择框
     * 签名证书，加密证书，默认选择签名证书
     *
     * @return
     */
    public TableCertConfig defaultCertConfig() {

        TableCertConfig certConfig = new TableCertConfig();
        certConfig.setPosition(list.size());
        certConfig.setCardType(DEFAULT_CARD_TYPE_TEXT);
        certConfig.setContainerNum(ContainerNum.getDefault());
        certConfig.setAlgType(AlgType.getDefaule());
        certConfig.setCertType(CertType.getDefault());
        certConfig.setCertRule(CertRule.getDefault());
        certConfig.setCertPermission(CertPermission.getDefault());
        return certConfig;
    }

    @Subscribe
    public void handleDeleteConfigDetail(DeleteCertConfigEvent event) {
        list.remove(event.getPosition());
        adapter.notifyDataSetChanged();
        resize();
    }

    private void initView() {

        dividerLive = findViewById(R.id.divider_live);

        connect = findViewById(R.id.connect);
        connect.setOnClickListener(this);

        sAllowUpdate = findViewById(R.id.switch_allow_update);
        sAllowIdentifer = findViewById(R.id.switch_allow_Identifer);

        exportHint = findViewById(R.id.export_hint);

        // 已导出
        exportSuccess = SharePreferencesUtil.getExportState(this);

        if (exportSuccess) {

            exportHint.setVisibility(View.VISIBLE);

            if (BuildConfig.isAAR) {
                exportHint.setText(R.string.cert_creation_save_success);
            } else {
                exportHint.setText("导出路径：" + path);
            }

        }

        addNewCard = findViewById(R.id.add_new_card);
        addNewCard.setOnClickListener(this);

        export = findViewById(R.id.export);
        export.setOnClickListener(this);

        liveCompanyView = findViewById(R.id.live_company);
        liveCompanyView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(getContext(), LiveCompany.POSITION, LiveCompany.getList());
            }
        });
        liveCompanyResult = findViewById(R.id.live_company_result);

        ocrView = findViewById(R.id.ocr);
        ocrView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ConfigDialog.show(getContext(), OCRCompany.POSITION, OCRCompany.getList());
            }
        });
        ocrResult = findViewById(R.id.ocr_result);

        nfcView = findViewById(R.id.nfc);
        nfcView.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {

                ConfigDialog.show(getContext(), NFCCompany.POSITION, NFCCompany.getList());
            }
        });
        nfcResult = findViewById(R.id.nfc_result);

        nfcPortView = findViewById(R.id.nfc_port_view);

        nfcPortResult = findViewById(R.id.nfc_port);

        nfcIPView = findViewById(R.id.nfc_ip_view);

        nfcIPResult = findViewById(R.id.nfc_ip_result);

        layout3rdNServer = findViewById(R.id.layout_3rd_n_server);

        initDefault3rdConfig();
    }

    private void initViewByData() {

        if (serverSettingConfig == null) {
            return;
        }

        liveCompanyResult.setText(serverSettingConfig.getLiveCompany());

        ocrResult.setText(serverSettingConfig.getOcrCompany());

        nfcResult.setText(serverSettingConfig.getNfcCompany());

        nfcIPResult.setText(serverSettingConfig.getNfcServerIP());

        nfcPortResult.setText(serverSettingConfig.getNfcServerPort());

        sAllowUpdate.setChecked(serverSettingConfig.getAllowUpdate().equals(IsTrue.AYE));
        sAllowIdentifer.setChecked(serverSettingConfig.getAllowIdentifer().equals(IsTrue.AYE));


    }

    private void initDefault3rdConfig() {

        //如果用户在证书申请流程中，选择了标准流程，需要进行活体检测、OCRCompany、NFC配置
        if (procedure.equals(Procedure.STANDARD)) {
            //默认全显示，什么也不做
        } else if (procedure.equals(Procedure.STD_NO_OCR)) {
            //如果选择标准流程（无OCR），需要进行活体检测和NFC配置
            ocrView.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.STD_NO_NFC)) {
            //如果选择标准流程（无NFC），需要进行活体检测配置
            connect.setVisibility(View.GONE);
            ocrView.setVisibility(View.GONE);
            nfcView.setVisibility(View.GONE);
            nfcIPView.setVisibility(View.GONE);
            nfcPortView.setVisibility(View.GONE);
            dividerLive.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.PHONE) || procedure.equals(Procedure.PHONE_UPGRADE)) {
            //如果选择持证拍照、手机号认证，则不展示身份认证服务配置
            layout3rdNServer.setVisibility(View.GONE);
        } else if (procedure.equals(Procedure.SIMPLIFIED)) {
            layout3rdNServer.setVisibility(View.GONE);
        }

        //活体检测，默认云从
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && liveCompanyView.getVisibility() == View.VISIBLE) {
            liveCompanyResult.setText(LiveCompany.YUNCONG);
        }

        //OCRCompany，默认云从
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && ocrView.getVisibility() == View.VISIBLE) {
            ocrResult.setText(OCRCompany.YUNCONG);
        }

        //NFCCompany，默认信大捷安
        if (layout3rdNServer.getVisibility() == View.VISIBLE
                && nfcView.getVisibility() == View.VISIBLE) {
            nfcResult.setText(NFCCompany.XDJA);
        }

    }

    private boolean validBeforeExport() {

        // 标准流程、标准流程无OCR需要校验NFC地址

        if (procedure.equals(Procedure.STANDARD)
                || procedure.equals(Procedure.STD_NO_OCR)
        ) {

            String ip = nfcIPResult.getText().toString();

            if (TextUtils.isEmpty(ip)) {
                ModuleToast.show(this, R.string.cert_creation_config_empty_server_address);
                return false;
            }

            boolean success = AddressUtil.validIP(ip);

            if (!success) {
                ModuleToast.show(this, R.string.cert_creation_config_error_server_address);
                return false;
            }

            String port = nfcPortResult.getText().toString();

            if (TextUtils.isEmpty(port)) {
                ModuleToast.show(this, R.string.cert_creation_config_please_input_server_port);
                return false;
            }

            success = AddressUtil.validPort(port);

            if (!success) {
                ModuleToast.show(this, R.string.cert_creation_config_error_server_port);
                return false;
            }

        }

        boolean success = validCertConfig();

        return success;
    }

    /**
     * 校验设备信息是否符合规则
     * 由于是选项，所以不用校验值是否是选项内，只用校验必填就可以
     *
     * @return
     */
    private boolean validCertConfig() {

        //容器号、密钥算法、证书机制、展示证书类型都是有默认值的
        //所以只要校验设备类型不是“请选择”就行

        boolean success = true;

        for (TableCertConfig config : list) {

            if (config.cardType.equals(DEFAULT_CARD_TYPE_TEXT)) {
                success = false;

                ModuleToast.show(this, R.string.cert_creation_config_please_choose_card_type);

                break;
            }

            // 特殊说明：同一类型的安全设备，不能存在相同的容器号，
            // toast提示【同一设备类型，容器号不能相同】

            // 新增约束：【同一设备类型，有且仅有一个容器可申请证书】

            int first = list.indexOf(config);

            int last = list.lastIndexOf(config);

            if (first != last) {
                success = false;

                TableCertConfig config1 = list.get(first);

                TableCertConfig config2 = list.get(last);

                String cardType1 = config1.getCardType();

                String cardType2 = config2.getCardType();

                if (cardType1.equals(ONLINE_VHSM)
                        && (cardType2.equals(CardType.OFFLINE_VHSM))) {
                    ModuleToast.show(this, "不能同时使用离线VHSM和联网VHSM");
                    break;
                } else if (cardType1.equals(CardType.OFFLINE_VHSM)
                        && (cardType2.equals(ONLINE_VHSM))
                ) {
                    ModuleToast.show(this, "不能同时使用离线VHSM和联网VHSM");
                    break;
                } else {

                    if (config1.cardType.equals(config2.cardType)) {
                        if (config1.containerNum == config2.containerNum) {
                            ModuleToast.show(this, R.string.cert_creation_repeat_container_num);
                        } else if (config1.certPermission.equals(CertPermission.APPLY)
                                && config2.certPermission.equals(CertPermission.APPLY)
                        ) {
                            ModuleToast.show(this, R.string.cert_creation_repeat_cert_permission);
                        }
                    }

                }

                break;
            }

        }

        return success;

    }


    private void showExportDialog() {

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this);

        bindIdentifyDialog.setTitle(R.string.cert_creation_export_config_title);
        bindIdentifyDialog.setMessage(R.string.cert_creation_export_config_message);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_export_config_positive);
        bindIdentifyDialog.setCancelable(true);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {

                boolean hasPermission = checkValidPermission(permissions);

                if (!hasPermission) {
                    showInvalidPermissionDialog();
                    return;
                }

                deleteDatabase();

                exportToSDCard();

                bindIdentifyDialog.cancel();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.cancel();
            }
        });
    }

    /**
     * 删除表，防止出现多条数据
     */
    private void clearTableValue() {
        // Delete a whole table
        Delete.table(ServerSettingConfig.class);
        Delete.table(TableCertConfig.class);
    }

    private void exportToSDCard() {

        clearTableValue();

        // 保存到数据库（此时数据库仍在私有目录下）

        // 表1
        ServerSettingConfig table = new ServerSettingConfig();

        table.liveCompany = liveCompanyResult.getText().toString();
        table.ocrCompany = ocrResult.getText().toString();
        table.nfcCompany = nfcResult.getText().toString();

       /* table.ip = serverIP;
        table.port = serverPort;*/

        saveServerAddress(table);

        saveVHSMAddress(table);

        table.nfcServerIP = nfcIPResult.getText().toString();
        table.nfcServerPort = nfcPortResult.getText().toString();

        table.allowUpdate =
                sAllowUpdate.isChecked() ? IsTrue.AYE : IsTrue.NAY;

        table.allowIdentifer = sAllowIdentifer.isChecked() ? IsTrue.AYE : IsTrue.NAY;

        table.procedure = procedure;

        table.projectName = projectName;

        table.enableVHSM = enableVHSM;

        table.certContent = certContent;

        table.certPath = certPath;

        table.hhy = enableHHY;
        table.setRevoke(enableRevoke);

        ModuleLog.i("enableRevoke : " + enableRevoke);

        table.save();

        // 表2
        for (TableCertConfig config : list) {
            config.save();
        }

        // 独立版导出把数据库复制到根目录
        // 融合版界面显示保存，点击保存数据库，安全接入自己调用导出接口
        if (!BuildConfig.isAAR) {
            DatabaseManager.getInstance().exportDatabase2Sdcard(this);
            ModuleToast.show(this, R.string.cert_creation_export_success);
        }

        exportHint.setTextColor(this.getResources().getColor(R.color.config_hint));
        exportHint.setVisibility(View.VISIBLE);

        if (BuildConfig.isAAR) {
            exportHint.setText(R.string.cert_creation_save_success);
        } else {
            exportHint.setText("导出路径：" + path);
        }

        // 存储导出成功的状态
        SharePreferencesUtil.saveExportState(this, true);

    }

    private void saveServerAddress(ServerSettingConfig table) {

        StringBuilder ip = new StringBuilder();
        StringBuilder port = new StringBuilder();

        for (int position = 0; position < serverAddressesList.size(); position++) {
            ServerAddress address = serverAddressesList.get(position);

            ip.append(address.getIp());
            port.append(address.getPort());

            if (position != serverAddressesList.size() - 1) {
                ip.append("|");
                port.append("|");
            }
        }

        table.ip = ip.toString();
        table.port = port.toString();

    }

    private void saveVHSMAddress(ServerSettingConfig table) {
        if (!enableVHSM) {
            return;
        }

        StringBuilder ip = new StringBuilder();
        StringBuilder port = new StringBuilder();

        for (int position = 0; position < vhsmAddressList.size(); position++) {
            ServerAddress address = vhsmAddressList.get(position);

            ip.append(address.getIp());
            port.append(address.getPort());

            if (position != vhsmAddressList.size() - 1) {
                ip.append("|");
                port.append("|");
            }
        }

        table.vhsm_ip = ip.toString();
        table.vhsm_port = port.toString();
    }


    /**
     * 弹窗提示用户用户开启权限
     */

    private void showInvalidPermissionDialog() {

        ArrayList<String> list = new ArrayList<>();

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                checkoutPermission();
            }

            @Override
            public void doCancel() {
                ConfigStep3Activity.this.finish();
            }
        });


    }

    public static final int PERMISSION_CODE = 23;

    /**
     * 权限检测（只检测敏感权限即可，其他权限只要在manifest里写入，系统自动赋予）
     */
    private void checkoutPermission() {

        ActivityCompat.requestPermissions(ConfigStep3Activity.this,
                permissions,
                PERMISSION_CODE);

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (grantResults[0] != 0) {
            showNoPermissionDialog();
        }


    }

    private void showNoPermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build(this, SinglePermissionDialog.PERMISSION_STORAGE);
        dialog.show();
    }


    private String[] permissions = new String[]{
            Manifest.permission.WRITE_EXTERNAL_STORAGE
    };

    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    private void deleteDatabase() {
        File file = new File(path);
        if (file.exists()) {
            ModuleLog.e("db文件已存在，尝试删除");
            boolean success = file.delete();
            ModuleLog.e(success ? "删除成功" : "删除失败，有可能是没有授予存储权限");
        }
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }
}
