package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;

import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.CertStatusResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.bean.result.VerifyPhoneResult;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;
import java.lang.ref.WeakReference;

import ocr.activity.AuthenticationFailActivity;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;

/**
 * Created by Administrator on 2019/12/10 0010.
 */
public class PhoneApplyActivity extends BaseActivity {

    private EditText etPhone;

    private LinearLayout idcard_layout;
    private EditText idCard;

    private PinDialog pinDialog;

    public CryptoDevType cardType;

    public int containerNum;

    public String cardNum;

    public String certType;


    ExitHandler exitHandler = new ExitHandler(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.cert_creation_activity_phone_apply_cert);

        verifyPin();

        initView();

    }

    @Override
    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        cardType = (CryptoDevType) getIntent().getSerializableExtra("cardType");
        cardNum = getIntent().getStringExtra("cardNum");
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
    }

    private void initView() {

        etPhone = (EditText) findViewById(R.id.et_phone);
        etPhone.setFilters(EditTextUtil.getDisableEmojFilter());

        if(AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_UPGRADE)) {
            idcard_layout = findViewById(R.id.idcard_layout);
            idcard_layout.setVisibility(View.VISIBLE);
            idCard = (EditText) findViewById(R.id.et_id);
            idCard.setFilters(EditTextUtil.getDisableEmojFilter(18));
        }
        Button btn_submit = (Button) findViewById(R.id.btn_submit);
        btn_submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                submit();
            }
        });

    }

    private void verifyPin() {
        if (cardType == CryptoDevType.DEV_TYPE_Soft && 2 == NetVHSMHandle.isNetVHSMCanUse(new ToolBarActivity().getContext())) {
            //软卡证书未初始化不进行pin码校验

        } else {
            int pinResult = DeviceWrapper.getInstance().verifyPin(cardType, containerNum,
                    AppConfig.getInstance().getDefaultConfig().getPin());

            if (pinResult != 0) {
                pinDialog = new PinDialog(this, cardType);
                pinDialog.show();
            }
        }
    }

    private void submit() {

        KeyboardUtils.hideKeyboard(etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {

            final String phone = etPhone.getText().toString();
            if (TextUtils.isEmpty(phone)) {
                ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }

            if(AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_UPGRADE)) {
                final String cardNum = idCard.getText().toString();
                if (TextUtils.isEmpty(cardNum)) {
                    ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_not_null_id_num);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                if (!cardNum.isEmpty() && cardNum.length() < 18) {
                    ModuleToast.show(getContext(), getResources().getString(R.string.cert_creation_error_id_size));
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                String idNo = idCard.getText().toString();
                SharePreferencesUtil.saveIDCardNo(getContext(), cardType.getType(), idNo);
            }

            DeviceWrapper.getInstance().setApplyCertEnd(true);

            // TODO: 2023/8/29 jff 再次查一次证书状态，如果本次还是查询无证书，则继续申请证书的业务，如果本次查询服务端有证书，则结束当前业务回到主界面
            showLoading();
            CertStateRequest certStateRequest = buildRequest();
            // TODO: 2023/8/29 jff 查询证书状态
            query(certStateRequest, phone);

        }
    }

    private CertStateRequest buildRequest() {
        final CertStateRequest certStateRequest = new CertStateRequest();
        certStateRequest.setSn(SharePreferencesUtil.getCertSn(this));

        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));

        return certStateRequest;
    }



    private void query(BaseRequest certStateRequest, final String phone) {

        ModuleLog.d("开始查询证书状态");
        final CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                dismissLoading();
            }


            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showRequestError();
                dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                dismissDialog();
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
                ModuleLog.d(" 查询结果" + result + "\n");
                if (result.equals("2")||result.equals("3")) {//3服务端证书状态正常或者2还处于可用状态，返回首页，不再继续申请证书

                    //如果非正常情况，需要界面给出用户提示等待一会重试或者联系管理员，2023年8月29日jff
                    CertStatusResult certStatusResult = new CertStatusResult();
                    certStatusResult.setContainerNum(containerNum);
                    certStatusResult.setResult("-1");

                    OttoUtil.postCertStatusResult(certStatusResult);
                    finish();

                } else {
                    verifyPhoneNum(phone);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void dismissDialog() {

            }
        });

    }

    /**
     * 验证手机号是否合法
     */
    private void verifyPhoneNum(final String phone) {

        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);

        showLoading();

        service.verifyPhoneNum(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showRequestError();
                dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String resultCode = commonResponse.getResult();
                if (resultCode.equals(VerifyPhoneResult.RESULT_OK)) {
                    //直接进行实体认证
                    startVerify();
                } else {

                    PhoneResult phoneResult
                            = buildPhoneResult(getCardType(), getCardNum(), commonResponse, null);

                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(containerNum);
                    authResult.setPhoneResult(phoneResult);

                    OttoUtil.postPhoneAuthResult(authResult);
                    finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                //                ModuleLog.d("手机号验证失败：" + baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type,
                                         String cardNum,
                                         CommonResponse response,
                                         BaseErrorResponse errorResponse) {

        CompareResult result = new CompareResult();

        // TODO: 2018/11/8 0008 三种情况的处理需要重写

        //IO异常的处理
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            //错误的处理
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty(errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            //正确的处理
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            //注意，成功的时候是没有errCode的
            result.setSuccess(true);
        }

        result.setIdentity(cardNum);


        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    /**
     * 进行实体认证
     */
    private void startVerify() {

        if (cardType == null || TextUtils.isEmpty(cardNum)) {
            return;
        }

        String phoneNum = etPhone.getText().toString();
        SharePreferencesUtil.savePhone(this, phoneNum);

        ApplyCertUtil.start(this, containerNum, new ApplyCertUtil.WhatHappen() {
            @Override
            public void showDialog() {
                // 现在在验证手机号前已经showLoading了，所以这里可以不加
            }

            @Override
            public void cancelDialog() {
//                dismissLoading();
            }

            @Override
            public void IOError() {
                Log.e("jff", "289 PhoneApplyActivity IOError : ");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                dismissLoading();
                showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                Log.e("jff", "302 PhoneApplyActivity handleError : ");
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });

    }

    static class ExitHandler extends Handler {

        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            reference = new WeakReference<Activity>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            Activity activity = reference.get();

            if (activity == null) {
                return;
            } else {
                activity.finish();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (exitHandler != null) {
            exitHandler.removeCallbacksAndMessages(null);
        }
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {

        Log.e("jff", "342 PhoneApplyActivity handleError : ");
        AuthResult result = ApplyCertUtil.buildAuthResult(getCardType(), containerNum, getCardNum(), null, baseErrorResponse);

        //一人一卡一证，跳转到认证失败的界面
        if (baseErrorResponse.getErrCode().equals(OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE)) {
            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra(CONTAINER_NUM, containerNum);
            intent.putExtra("result", result.getResult());
            intent.putExtra("photoType", cardType);
            startActivity(intent);
        }

        OttoUtil.postAuthResult(result);
        finish();

    }

}
